/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CourseTocCloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.BbList;
import blackboard.data.ValidationException;
import blackboard.data.navigation.CourseToc;
import blackboard.persist.PersistenceException;
import blackboard.persist.navigation.CourseTocDbLoader;
import blackboard.persist.navigation.CourseTocDbPersister;
import blackboard.platform.log.LogServiceFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CourseTocOrderingOperator
extends CourseTocCloneOperator {
    public CourseTocOrderingOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        long lStart = System.currentTimeMillis();
        this.processCourseToc();
        this.doCallbackSegment(CloneCallback.Stage.COURSE_TOC_REORDERING, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.coursetoc.reordering"), System.currentTimeMillis() - lStart);
    }

    private void processCourseToc() throws PersistenceException, ValidationException {
        CourseToc tgtToc;
        if (this._cfg.getReconcileFlag().booleanValue()) {
            return;
        }
        CourseTocDbPersister cPersister = (CourseTocDbPersister)CourseTocDbPersister.Default.getInstance();
        List<CourseToc> tocList = this.updatePositionNumberOfNewTocItems();
        CourseTocPositionComparator courseTocPositionComparator = new CourseTocPositionComparator();
        Collections.sort(tocList, courseTocPositionComparator);
        boolean foundEntryPoint = false;
        for (CourseToc tgtToc2 : tocList) {
            if (!tgtToc2.getIsEntryPoint()) continue;
            foundEntryPoint = true;
        }
        if (!foundEntryPoint && (tgtToc = tocList.get(0)) != null) {
            tgtToc.setIsEntryPoint(true);
        }
        int tgtTocPos = 0;
        for (CourseToc tgtToc3 : tocList) {
            tgtToc3.setPosition(tgtTocPos);
            cPersister.persist(tgtToc3);
            ++tgtTocPos;
        }
    }

    private List<CourseToc> updatePositionNumberOfNewTocItems() throws PersistenceException {
        CourseTocDbLoader cLoader = CourseTocDbLoader.Default.getInstance();
        BbList sourceTocList = cLoader.loadByCourseId(this._srcSite.getId());
        BbList targetTocListUpdated = cLoader.loadByCourseId(this._tgtSite.getId());
        ArrayList<CourseToc> targetTocListOriginal = this._cfg.getOriginalTargetCourseTocList();
        List<CourseToc> newTocItemsList = this.getNewCourseTocList(targetTocListOriginal, (List<CourseToc>)targetTocListUpdated);
        for (CourseToc newToc : newTocItemsList) {
            if (newToc.getTargetType() == CourseToc.Target.CONTENT_ITEM) {
                newToc.setPosition(targetTocListUpdated.size() * 2 + newToc.getPosition());
                continue;
            }
            CourseToc srcToc = this.matchTocByAttributes(newToc, (List<CourseToc>)sourceTocList);
            if (srcToc != null) {
                newToc.setPosition(targetTocListUpdated.size() + srcToc.getPosition());
                continue;
            }
            newToc.setPosition(targetTocListUpdated.size() * 2 + newToc.getPosition());
        }
        this.reLabelCourseToc((List<CourseToc>)targetTocListUpdated);
        return targetTocListUpdated;
    }

    private List<CourseToc> getNewCourseTocList(List<CourseToc> originalList, List<CourseToc> updatedList) {
        ArrayList<CourseToc> newTocItemsList = new ArrayList<CourseToc>();
        if (originalList.size() < updatedList.size()) {
            for (CourseToc updatedToc : updatedList) {
                if (updatedToc.getTargetType() == CourseToc.Target.CONTENT_ITEM) {
                    if (null != this.matchTocById(updatedToc.getId(), originalList)) continue;
                    newTocItemsList.add(updatedToc);
                    continue;
                }
                if (null != this.matchTocByAttributes(updatedToc, originalList)) continue;
                newTocItemsList.add(updatedToc);
            }
        }
        return newTocItemsList;
    }

    private void reLabelCourseToc(List<CourseToc> list) {
        HashMap<String, CourseToc> labelMap = new HashMap<String, CourseToc>();
        HashMap<String, CourseToc> collisions = new HashMap<String, CourseToc>();
        ArrayList<CourseToc> duplicatedTocLabels = new ArrayList<CourseToc>();
        for (CourseToc cToc : list) {
            boolean isDuplicated = false;
            if (cToc.getTargetType() != CourseToc.Target.CONTENT || duplicatedTocLabels.contains(cToc)) continue;
            String persistentLabel = cToc.getPersistentLabel();
            int idx = persistentLabel.lastIndexOf(":");
            if (!(idx <= 0 || idx >= 4 && persistentLabel.substring(idx - 4, idx).equalsIgnoreCase("http") || idx >= 5 && persistentLabel.substring(idx - 5, idx).equalsIgnoreCase("https") || idx >= persistentLabel.trim().length() - 1)) {
                String tmpLabel = persistentLabel.substring(0, idx).trim();
                for (CourseToc cToc2 : list) {
                    if (cToc2 == cToc || cToc2.getTargetType() != CourseToc.Target.CONTENT || collisions.get(cToc2.getId().toExternalString()) != null || !tmpLabel.equals(cToc2.getPersistentLabel().trim())) continue;
                    persistentLabel = tmpLabel;
                    cToc.setLabel(persistentLabel);
                    if (!duplicatedTocLabels.contains(cToc2)) {
                        duplicatedTocLabels.add(cToc2);
                    }
                    collisions.put(cToc.getId().toExternalString(), cToc);
                    isDuplicated = true;
                    break;
                }
            }
            if (isDuplicated) continue;
            labelMap.put(persistentLabel, cToc);
        }
        if (collisions.isEmpty()) {
            return;
        }
        for (CourseToc cToc : collisions.values()) {
            try {
                this.renameCourseToc(labelMap, cToc, 1);
            }
            catch (Exception e) {
                LogServiceFactory.getInstance().logWarning("Error occurred during renaming of Content TOC with title:" + cToc.getLabel());
            }
        }
    }

    private void renameCourseToc(Map<String, CourseToc> labelMap, CourseToc cToc, int posLabel) throws Exception {
        String tocLabel = cToc.getPersistentLabel() + posLabel;
        if (!labelMap.containsKey(tocLabel)) {
            cToc.setLabel(tocLabel);
            labelMap.put(tocLabel, cToc);
            CourseTocDbPersister persister = (CourseTocDbPersister)CourseTocDbPersister.Default.getInstance();
            persister.persist(cToc);
        } else {
            this.renameCourseToc(labelMap, cToc, posLabel + 1);
        }
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
    }

    private static class CourseTocPositionComparator
    implements Comparator<CourseToc>,
    Serializable {
        private CourseTocPositionComparator() {
        }

        @Override
        public int compare(CourseToc o1, CourseToc o2) {
            CourseToc ct2;
            int pos2;
            CourseToc ct1 = o1;
            int pos1 = ct1.getPosition();
            if (pos1 < (pos2 = (ct2 = o2).getPosition())) {
                return -1;
            }
            if (pos1 == pos2) {
                return 0;
            }
            return 1;
        }
    }
}

