/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.data.course.Group;
import blackboard.db.DbUtil;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.impl.Bb5Util;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.proxytool.ProxyToolManagerFactory;
import blackboard.platform.proxytool.ProxyToolUtil;
import blackboard.platform.proxytool.dao.ProxyTool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class GroupCloneOperator
extends CloneOperator {
    public GroupCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        boolean hadWarnings;
        long lStart = System.currentTimeMillis();
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.GROUP)) {
            return;
        }
        this.executeCloneProcedure("groups_cp", this._cfg.getMaximumTransactionCount());
        if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            this.executeCloneProcedure("group_users_cp", this._cfg.getMaximumTransactionCount());
        }
        if (hadWarnings = this.handleProxyToolCopies(this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT))) {
            this._cfg.setHadWarnings(hadWarnings);
        }
        this.doCallbackSegment(CloneCallback.Stage.GROUP, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.group"), System.currentTimeMillis() - lStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleProxyToolCopies(boolean exact) throws Exception {
        boolean bl;
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rst = null;
        boolean hadWarnings = false;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement("select tk.old_pk1, tk.new_pk1, pt.pk1, pl.url from tmp_key_maps tk, groups gr, group_application ga, application ap, proxy_tools pt, proxy_links pl where session_id = ? and table_name = ?  and tk.old_pk1 = gr.pk1 and gr.pk1 = ga.groups_pk1 and ga.application = ap.application and ap.proxy_tools_pk1 = pt.pk1 and pt.active_ind = 'Y' and pt.available_ind = 'Y' and pt.pk1 = pl.proxy_tools_pk1 and pl.link_type = 'group-copied' ");
            stmt.setString(1, this._sessionId);
            stmt.setString(2, "GROUPS");
            rst = stmt.executeQuery();
            while (rst.next()) {
                Id oldId = Bb5Util.unmarshallId((ResultSet)rst, (String)"old_pk1", (DataType)Group.DATA_TYPE, (Container)this._pm.getContainer());
                Id newId = Bb5Util.unmarshallId((ResultSet)rst, (String)"new_pk1", (DataType)Group.DATA_TYPE, (Container)this._pm.getContainer());
                Id ptId = Bb5Util.unmarshallId((ResultSet)rst, (String)"pk1", (DataType)ProxyTool.DATA_TYPE, (Container)this._pm.getContainer());
                String url = rst.getString("url");
                if (oldId == null || newId == null || ptId == null || url == null || url.trim().length() == 0) continue;
                ProxyTool proxyTool = ProxyToolManagerFactory.getInstance().loadToolById(ptId);
                boolean res = ProxyToolUtil.getInstance().sendGroupCopiedEx(proxyTool, oldId, this._srcSite.getId(), newId, this._tgtSite.getId(), url, exact);
                if (res) continue;
                LogServiceFactory.getInstance().logError("Failed to copy proxy tool group for Tool:" + ptId.toExternalString() + " at " + proxyTool.getBaseurl() + " for " + proxyTool.getOurGuid() + ", Original Group Id: " + oldId.toExternalString());
                hadWarnings = true;
            }
            bl = hadWarnings;
        }
        catch (Throwable throwable) {
            DbUtil.close(rst);
            DbUtil.close(stmt);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((ResultSet)rst);
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
        return bl;
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
    }
}

