/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.data.course.Course;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.Id;
import blackboard.persist.course.impl.CourseMembershipDAO;
import blackboard.persist.impl.Bb5Util;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.manager.CourseFileManager;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class MembershipCloneOperator
extends CloneOperator {
    public MembershipCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        long lStart = System.currentTimeMillis();
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            return;
        }
        if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT)) {
            this.executeMembershipCloneProcedure("course_users_exact_cp", this._cfg.getMembershipDataSourceId(), this._cfg.getMaximumTransactionCount());
        } else {
            this.executeMembershipCloneProcedure("course_users_cp", this._cfg.getMembershipDataSourceId(), this._cfg.getMaximumTransactionCount());
        }
        this.executeMembershipCloneProcedure("limited_grader_cp", this._cfg.getMembershipDataSourceId(), this._cfg.getMaximumTransactionCount());
        this.doCallbackSegment(CloneCallback.Stage.MEMBERSHIP, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.membership"), System.currentTimeMillis() - lStart);
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return this.getDirectoryTranslation(dir, "COURSE_USERS");
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT)) {
            return;
        }
        File tgtPath = ((CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE)).getRootDirectory(this._tgtSite.getCourseId());
        tgtPath = new File(tgtPath, "uploads" + File.separator + "homepage");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeMembershipCloneProcedure(String procedureName, Id membershipDataSourceId, int commitFrequency) throws SQLException, ConnectionNotAvailableException {
        CallableStatement stmt = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = MembershipCloneQuery.getCloneQuery(procedureName, con);
            MembershipCloneQuery.marshallParams(this._srcSite, this._tgtSite, membershipDataSourceId, this._sessionId, commitFrequency, stmt);
            stmt.execute();
            CourseMembershipDAO.get().evictCache();
        }
        catch (Throwable throwable) {
            DbUtil.close(stmt);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    static class MembershipCloneQuery {
        MembershipCloneQuery() {
        }

        public static CallableStatement getCloneQuery(String procedureName, Connection con) throws SQLException {
            StringBuilder sqlStmt = new StringBuilder();
            sqlStmt.append("{ call " + procedureName);
            sqlStmt.append(" ( ?, ?, ?, ?, ? ) } ");
            return con.prepareCall(sqlStmt.toString());
        }

        public static void marshallParams(Course srcCourse, Course tgtCourse, Id membershipDataSourceId, String sessionId, int commitFrequency, CallableStatement stmt) throws SQLException {
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)srcCourse.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)tgtCourse.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)3, (Id)membershipDataSourceId);
            stmt.setInt(4, commitFrequency);
            stmt.setString(5, sessionId);
        }
    }
}

