/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.cxutil.CSFileCopyHandler;
import blackboard.admin.cxutil.CSFileCopyHandlerFactory;
import blackboard.admin.cxutil.CSResultSet;
import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.data.course.Course;
import blackboard.data.course.CourseManagerExFactory;
import blackboard.data.course.CourseSettingCXHelper;
import blackboard.data.navigation.CourseToolSettings;
import blackboard.data.navigation.NavigationApplicationUtil;
import blackboard.data.registry.CourseRegistryEntry;
import blackboard.data.registry.CourseRegistryUtil;
import blackboard.db.BbDatabase;
import blackboard.db.DbUtil;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.course.CourseDbLoader;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.navigation.NavigationApplicationDbLoader;
import blackboard.persist.navigation.ToolSettingsManagerFactory;
import blackboard.persist.registry.CourseRegistryEntryDbLoader;
import blackboard.persist.registry.CourseRegistryEntryDbPersister;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.proxytool.ProxyToolUtil;
import blackboard.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SettingCloneOperator
extends CloneOperator {
    public SettingCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        long lStart = System.currentTimeMillis();
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.SETTING)) {
            return;
        }
        Set<String> settingRestrictions = this._cfg.getIncludedObjects(CloneConfig.Area.SETTING);
        this.executeCloneProcedure("course_navigation_item_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_application_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedureForCrsToolRec("crs_app_settings_rec", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_content_handlers_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_toc_settings_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_registry_cp", this._cfg.getMaximumTransactionCount());
        try {
            CourseRegistryEntryDbLoader crsRegLdr = CourseRegistryEntryDbLoader.Default.getInstance();
            CourseRegistryEntryDbPersister crsRegPstr = (CourseRegistryEntryDbPersister)CourseRegistryEntryDbPersister.Default.getInstance();
            CourseRegistryEntry cre = crsRegLdr.loadByKeyAndCourseId("is_template", this._tgtSite.getId());
            cre.setValue("N");
            crsRegPstr.persist(cre);
        }
        catch (KeyNotFoundException knfe) {
        }
        catch (Exception ex) {
            LogServiceFactory.getInstance().logError("Error setting Template value during Course Copy Operation", (Throwable)ex);
        }
        this.duplicateSettings(this._srcSite, this._tgtSite, settingRestrictions);
        this._tgtSite = CourseDbLoader.Default.getInstance().loadById(this._tgtSite.getId());
        this.clearHomeDirectorySetting(this._tgtSite);
        boolean hadWarnings = this.doProxyToolNotifications(this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT));
        if (hadWarnings) {
            this._cfg.setHadWarnings(hadWarnings);
        }
        this.doCallbackSegment(CloneCallback.Stage.SETTING, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.settings"), System.currentTimeMillis() - lStart);
    }

    private boolean doProxyToolNotifications(boolean exact) throws Exception {
        boolean hadWarnings = false;
        List courseAppSettings = ToolSettingsManagerFactory.getInstance().loadAllCourseToolSettings(this._srcSite.getId(), CourseToolSettings.CourseToolType.Application, false);
        courseAppSettings = NavigationApplicationUtil.applyFilter((List)courseAppSettings, (NavigationApplicationDbLoader.Filter)NavigationApplicationDbLoader.Filter.PROXYTOOL, (boolean)false);
        for (CourseToolSettings settings : courseAppSettings) {
            boolean res;
            Id ptId;
            if (!settings.getToolEnabledSetting().isAvailable() || (ptId = settings.getApplication().getProxyToolId()) == null || (res = ProxyToolUtil.getInstance().sendCourseCopied(ptId.toExternalString(), this._srcSite.getId(), this._tgtSite.getId(), exact))) continue;
            LogServiceFactory.getInstance().logError("Failed to notify proxytool of course-copy for Tool:" + ptId + " for sourceid " + this._srcSite.getId().toExternalString());
            hadWarnings = true;
        }
        return hadWarnings;
    }

    private void duplicateSettings(Course srcSite, Course tgtSite, Set<String> settingRestrictions) throws Exception {
        if (settingRestrictions == null) {
            settingRestrictions = new HashSet<String>();
            settingRestrictions.add(CourseSettingCXHelper.LIMITED_SETTINGS);
            settingRestrictions.add(CourseSettingCXHelper.BANNER_IMAGE);
            settingRestrictions.add(CourseSettingCXHelper.NAV_SETTINGS);
            settingRestrictions.add(CourseSettingCXHelper.LANGUAGE_PACK);
        }
        CourseManagerExFactory.getInstance().duplicateSettings(srcSite, tgtSite, settingRestrictions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearHomeDirectorySetting(Course tgtSite) throws Exception {
        String path = CourseRegistryUtil.getString((Id)tgtSite.getId(), (String)"home_directory", (String)"");
        if (StringUtil.notEmpty((String)path)) {
            PreparedStatement update = null;
            Connection con = null;
            String deleteClause = "delete from course_registry where crsmain_pk1 = ? and (registry_key = 'home_directory' or registry_key = 'bbcms_target_location') ";
            try {
                con = this._bbDatabase.getConnectionManager().getConnection();
                update = con.prepareStatement(deleteClause);
                Bb5Util.setId((PreparedStatement)update, (int)1, (Id)tgtSite.getId());
                update.execute();
            }
            catch (Exception e) {
                try {
                    LogServiceFactory.getInstance().logError("Failed to delete home_directory from course registry table ", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbUtil.close(update);
                    this._bbDatabase.getConnectionManager().releaseConnection(con);
                    throw throwable;
                }
                DbUtil.close((Statement)update);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
            }
            DbUtil.close((Statement)update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
        }
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
        this.updateDatabaseIdForImageFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDatabaseIdForImageFiles() throws Exception {
        boolean copyCSItemsByArea = this._cfg.shouldCopyCSItemByArea();
        Map<String, String> bannerInfoIdMap = this.getDbBasedIdMap("COURSE_MAIN");
        if (bannerInfoIdMap.isEmpty()) {
            return;
        }
        List<PreparedStatement> selectStmtList = null;
        PreparedStatement update = null;
        Connection con = null;
        Map<String, String> xythosIdMap = this.getDbBasedIdMap("XYTHOS_DATAVALUES");
        CSFileCopyHandler csFileHandler = CSFileCopyHandlerFactory.getInstance();
        String selectClause = "select pk1, banner_url, course_name from COURSE_MAIN ";
        String qryUpdate = "update COURSE_MAIN set banner_url = ? where pk1 = ?";
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            update = con.prepareStatement(qryUpdate);
            selectStmtList = this.prepareStatement(selectClause, bannerInfoIdMap.values(), Course.DATA_TYPE, con, this._cfg);
            for (PreparedStatement select : selectStmtList) {
                try {
                    ResultSet rst = select.executeQuery();
                    while (rst.next()) {
                        CSResultSet resultSet = null;
                        String imageText = null;
                        String title = null;
                        try {
                            Id cId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)Course.DATA_TYPE, (Container)this._pm.getContainer());
                            imageText = DbUtil.getString((ResultSet)rst, (String)"banner_url", null);
                            title = DbUtil.getString((ResultSet)rst, (String)"course_name", null);
                            if (imageText == null || imageText.length() == 0 || !StringUtil.notEmpty((String)imageText)) continue;
                            resultSet = new CSResultSet(this._tgtSite.getId(), cId, title, "cx.import.copy.link.component.name.banner.image");
                            String replace = csFileHandler.copyCSFileByXythosIdUrl(imageText, this._cfg.getSrcHomeDir(), this._cfg.getCsDir(), this._tgtSite, this._srcSite, copyCSItemsByArea, xythosIdMap, imageText, resultSet, true, this._cfg.isFromAdminPanel(), this._cfg.getExcludedCsFolderIds());
                            if (!StringUtil.notEmpty((String)replace) || StringUtil.isEqual((String)imageText, (String)replace)) continue;
                            DbUtil.setNString((BbDatabase)this._bbDatabase, (PreparedStatement)update, (int)1, (String)replace);
                            Bb5Util.setId((PreparedStatement)update, (int)2, (Id)cId);
                            update.execute();
                        }
                        catch (Exception e) {
                            LogServiceFactory.getInstance().logError("Failed to update embedded Course Files link in the Course Banner with title: " + title + ", banner_url:" + imageText, (Throwable)e);
                        }
                        finally {
                            if (resultSet == null) continue;
                            this.addCsLinkStatus(resultSet);
                        }
                    }
                    DbUtil.close((ResultSet)rst);
                }
                catch (Exception e) {
                    LogServiceFactory.getInstance().logError("Failed to load Course Banners for updating embedded links in VTBE.", (Throwable)e);
                }
                finally {
                    DbUtil.close((Statement)select);
                }
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)update);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }
}

