/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.cxutil.CSFileCopyHandler;
import blackboard.admin.cxutil.CSFileCopyHandlerFactory;
import blackboard.admin.cxutil.CSResultSet;
import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.data.content.StaffInfo;
import blackboard.data.course.Course;
import blackboard.db.BbDatabase;
import blackboard.db.DbUtil;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.impl.Bb5Util;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.manager.CourseFileManager;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class StaffInformationCloneOperator
extends CloneOperator {
    public StaffInformationCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        long lStart = System.currentTimeMillis();
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.STAFF_INFORMATION)) {
            return;
        }
        this.executeCloneProcedure("staffinformation_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_toc_staff_cp", this._cfg.getMaximumTransactionCount());
        this.doCallbackSegment(CloneCallback.Stage.STAFF_INFORMATION, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.staff"), System.currentTimeMillis() - lStart);
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return this.getDirectoryTranslation(dir, "STAFFINFORMATION");
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.STAFF_INFORMATION)) {
            return;
        }
        File tgtPath = ((CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE)).getRootDirectory(this._tgtSite.getCourseId());
        tgtPath = new File(tgtPath, "staffinformation");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
        this.updateEmbeddedDatabaseIdForVTBE();
        this.updateDatabaseIdForImageFiles();
        CSFileCopyHandler csFileHandler = CSFileCopyHandlerFactory.getInstance();
        csFileHandler.updateCSLinks(this._srcSite.getId(), this._tgtSite.getId(), StaffInfo.DATA_TYPE, this.getDbBasedIdMap("STAFFINFORMATION"), this.getDbBasedIdMap("XYTHOS_DATAVALUES"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEmbeddedDatabaseIdForVTBE() throws Exception {
        Map<String, String> staffInfoIdMap = this.getDbBasedIdMap("STAFFINFORMATION");
        if (staffInfoIdMap.isEmpty()) {
            return;
        }
        List<PreparedStatement> selectStmtList = null;
        PreparedStatement update = null;
        Connection con = null;
        String selectClause = "select pk1, biography, title from STAFFINFORMATION ";
        String qryUpdate = "update STAFFINFORMATION set biography = ? where pk1 = ?";
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            update = con.prepareStatement(qryUpdate);
            selectStmtList = this.prepareStatement(selectClause, staffInfoIdMap.values(), StaffInfo.DATA_TYPE, con, this._cfg);
            for (PreparedStatement select : selectStmtList) {
                try {
                    ResultSet rst = select.executeQuery();
                    while (rst.next()) {
                        CSResultSet resultSet = null;
                        String text = null;
                        String title = null;
                        try {
                            String replace;
                            Id cId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)StaffInfo.DATA_TYPE, (Container)this._pm.getContainer());
                            text = DbUtil.getClob((BbDatabase)this._bbDatabase, (ResultSet)rst, (String)"biography", null);
                            title = DbUtil.getString((ResultSet)rst, (String)"title", null);
                            if (!StringUtil.notEmpty((String)text) || StringUtil.isEqual((String)text, (String)(replace = this.parseVTBEText(text, resultSet = new CSResultSet(this._tgtSite.getId(), cId, title, "cx.import.copy.link.component.name.contact"))))) continue;
                            DbUtil.setNClob((BbDatabase)this._bbDatabase, (PreparedStatement)update, (int)1, (String)replace);
                            Bb5Util.setId((PreparedStatement)update, (int)2, (Id)cId);
                            update.execute();
                        }
                        catch (Exception e) {
                            LogServiceFactory.getInstance().logError("Failed to update embedded Course Files link in the Staff Info with title: " + title + ", biography:" + text, (Throwable)e);
                        }
                        finally {
                            if (resultSet == null) continue;
                            this.addCsLinkStatus(resultSet);
                        }
                    }
                    DbUtil.close((ResultSet)rst);
                }
                catch (Exception e) {
                    LogServiceFactory.getInstance().logError("Failed to load Staff Info for updating embedded links in VTBE.", (Throwable)e);
                }
                finally {
                    DbUtil.close((Statement)select);
                }
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)update);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDatabaseIdForImageFiles() throws Exception {
        boolean copyCSItemsByArea = this._cfg.shouldCopyCSItemByArea();
        Map<String, String> staffInfoIdMap = this.getDbBasedIdMap("STAFFINFORMATION");
        if (staffInfoIdMap.isEmpty()) {
            return;
        }
        List<PreparedStatement> selectStmtList = null;
        PreparedStatement update = null;
        Connection con = null;
        Map<String, String> xythosIdMap = this.getDbBasedIdMap("XYTHOS_DATAVALUES");
        CSFileCopyHandler csFileHandler = CSFileCopyHandlerFactory.getInstance();
        String selectClause = "select pk1, image, title from STAFFINFORMATION ";
        String qryUpdate = "update STAFFINFORMATION set image = ? where pk1 = ?";
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            update = con.prepareStatement(qryUpdate);
            selectStmtList = this.prepareStatement(selectClause, staffInfoIdMap.values(), StaffInfo.DATA_TYPE, con, this._cfg);
            for (PreparedStatement select : selectStmtList) {
                try {
                    ResultSet rst = select.executeQuery();
                    while (rst.next()) {
                        CSResultSet resultSet = null;
                        String imageText = null;
                        String title = null;
                        try {
                            Id cId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)StaffInfo.DATA_TYPE, (Container)this._pm.getContainer());
                            imageText = DbUtil.getString((ResultSet)rst, (String)"image", null);
                            title = DbUtil.getString((ResultSet)rst, (String)"title", null);
                            if (StringUtil.isEmpty((String)imageText)) continue;
                            resultSet = new CSResultSet(this._tgtSite.getId(), cId, title, "cx.import.copy.link.component.name.contact");
                            String replace = csFileHandler.copyCSFileByXythosIdUrl(imageText, this._cfg.getSrcHomeDir(), this._cfg.getCsDir(), this._tgtSite, this._srcSite, copyCSItemsByArea, xythosIdMap, imageText, resultSet, true, this._cfg.isFromAdminPanel(), this._cfg.getExcludedCsFolderIds());
                            if (StringUtil.notEmpty((String)replace) && !StringUtil.isEqual((String)imageText, (String)replace)) {
                                DbUtil.setNString((BbDatabase)this._bbDatabase, (PreparedStatement)update, (int)1, (String)replace);
                                Bb5Util.setId((PreparedStatement)update, (int)2, (Id)cId);
                                update.execute();
                            }
                            if (resultSet == null) continue;
                        }
                        catch (Exception e) {
                            LogServiceFactory.getInstance().logError("Failed to update embedded Course Files link in the Staff Info image files with title: " + title + ", image:" + imageText, (Throwable)e);
                            continue;
                        }
                        finally {
                            if (resultSet == null) continue;
                            this.addCsLinkStatus(resultSet);
                            continue;
                        }
                        this.addCsLinkStatus(resultSet);
                    }
                    DbUtil.close((ResultSet)rst);
                }
                catch (Exception e) {
                    LogServiceFactory.getInstance().logError("Failed to load Staff Info for updating embedded links in image files.", (Throwable)e);
                }
                finally {
                    DbUtil.close((Statement)select);
                }
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)update);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }
}

