/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator.helper;

import blackboard.admin.cxutil.CSResultSet;
import blackboard.admin.cxutil.CourseContentCopyUtil;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.data.ExtendedData;
import blackboard.data.content.Content;
import blackboard.data.content.LessonPlanComponent;
import blackboard.data.content.LessonPlanComponentXMLConverter;
import blackboard.data.course.Course;
import blackboard.db.BbDatabase;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.DatabaseContainer;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.impl.mapping.ExtendedDataMapping;
import blackboard.persist.impl.mapping.Mapping;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.persistence.PersistenceServiceFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class LessonPlanVtbeComponentDeepCopier {
    private CloneOperator _cloneOperator;
    private ExtendedDataMapping _extendedDataMapping;
    private Map<String, String> _filesIdMap;
    private Map<String, String> _contentIdMap;
    private BbDatabase _bbDatabase;
    private Course _tgtSite;
    private BbPersistenceManager _pm;
    private static final String COMPONENTS = "Components";
    private static final String LESSON_PLAN_SELECT_SQL = "select pk1, extended_data, title from COURSE_CONTENTS where crsmain_pk1 = ? and extended_data is not null and cnthndlr_handle='resource/x-bb-lesson-plan'";
    private static final String LESSON_PLAN_UPDATE_SQL = "update COURSE_CONTENTS set extended_data = ? where pk1 = ?";

    public LessonPlanVtbeComponentDeepCopier(CloneOperator cloneOperator, Course tgtSite) {
        this._cloneOperator = cloneOperator;
        this._tgtSite = tgtSite;
        this._filesIdMap = this._cloneOperator.getDbBasedIdMap("FILES");
        this._contentIdMap = this._cloneOperator.getDbBasedIdMap("COURSE_CONTENTS");
        this._extendedDataMapping = new ExtendedDataMapping("ExtendedData", "extended_data", Mapping.Use.INPUT, Mapping.Use.INPUT);
        this._pm = PersistenceServiceFactory.getInstance().getDbPersistenceManager();
        this._bbDatabase = ((DatabaseContainer)this._pm.getContainer()).getBbDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEmbeddedDatabaseIdForExtendedData() throws Exception {
        PreparedStatement select = null;
        PreparedStatement update = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            select = con.prepareStatement(LESSON_PLAN_SELECT_SQL);
            update = con.prepareStatement(LESSON_PLAN_UPDATE_SQL);
            Bb5Util.setId((PreparedStatement)select, (int)1, (Id)this._tgtSite.getId());
            ResultSet rst = select.executeQuery();
            while (rst.next()) {
                this.processLessonPlanRow(update, rst);
            }
            DbUtil.close((ResultSet)rst);
        }
        catch (Throwable throwable) {
            DbUtil.close(select);
            DbUtil.close(update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)select);
        DbUtil.close((Statement)update);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    private boolean processLessonPlanRow(PreparedStatement update, ResultSet rst) throws SQLException, PersistenceException, Exception {
        boolean isRowUpdated = false;
        boolean lessonPlanNeedsUpdate = false;
        Id contentId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)Content.DATA_TYPE, (Container)this._pm.getContainer());
        ExtendedData extendedData = (ExtendedData)this._extendedDataMapping.unmarshall(this._pm.getContainer(), rst, null);
        List<LessonPlanComponent> lessonPlanComponents = this.getLessonPlanComponents(extendedData);
        for (LessonPlanComponent lessonPlanComponent : lessonPlanComponents) {
            boolean replacedEmbeddedLinks = this.replaceEmbeddedLinks(lessonPlanComponent, rst, contentId);
            if (!replacedEmbeddedLinks || lessonPlanNeedsUpdate) continue;
            lessonPlanNeedsUpdate = true;
        }
        if (lessonPlanNeedsUpdate) {
            String xml = LessonPlanComponentXMLConverter.toXML(lessonPlanComponents);
            extendedData.setValue(COMPONENTS, xml);
            this._extendedDataMapping.marshall(this._pm.getContainer(), update, 1, (Object)extendedData);
            Bb5Util.setId((PreparedStatement)update, (int)2, (Id)contentId);
            update.execute();
            isRowUpdated = true;
        }
        return isRowUpdated;
    }

    private List<LessonPlanComponent> getLessonPlanComponents(ExtendedData extendedData) throws Exception {
        String text = extendedData.getValue(COMPONENTS);
        List lessonPlanComponents = LessonPlanComponentXMLConverter.fromXml((String)text);
        return lessonPlanComponents;
    }

    private boolean replaceEmbeddedLinks(LessonPlanComponent lessonPlanComponent, ResultSet rst, Id contentId) throws SQLException {
        boolean replacedEmbeddedLinks = false;
        if (lessonPlanComponent.hasEmbeddedLinks()) {
            String title = DbUtil.getString((ResultSet)rst, (String)"title", null);
            String replace = lessonPlanComponent.getValue();
            replace = CourseContentCopyUtil.resolveTextBasedMapping(this._filesIdMap, replace);
            if (this._contentIdMap != null && this._contentIdMap.containsValue(contentId.toExternalString())) {
                CSResultSet resultSet = new CSResultSet(this._tgtSite.getId(), contentId, title, "cx.import.copy.link.component.name.content.item");
                try {
                    replace = this._cloneOperator.parseVTBEText(replace, resultSet);
                }
                catch (Exception e) {
                    LogServiceFactory.getInstance().logError("Failed to update Course Files link in the Course Content with title: " + title, (Throwable)e);
                }
                this._cloneOperator.addCsLinkStatus(resultSet);
            }
            if (!lessonPlanComponent.getValue().equals(replace)) {
                lessonPlanComponent.setValue(replace);
                replacedEmbeddedLinks = true;
            }
        }
        return replacedEmbeddedLinks;
    }
}

