/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.mapping;

import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbLink;
import blackboard.db.BbDatabase;
import blackboard.db.ConstraintViolationException;
import blackboard.db.DbUtil;
import blackboard.persist.Container;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.mapping.AbstractMapping;
import blackboard.persist.impl.mapping.Mapping;
import blackboard.xml.XmlUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AdminDbBbLinkMapping
extends AbstractMapping {
    private String _strNameColumnName = null;
    private String _strUrlColumnName = null;
    private String _strDescColumnName = null;

    public AdminDbBbLinkMapping(String strName, String strNameColumnName, String strUrlColumnName, String strDescColumnName, Mapping.Use eInsertUse, Mapping.Use eUpdateUse, boolean bPrimaryKey) {
        super(strName, eInsertUse, eUpdateUse, bPrimaryKey);
        this._strNameColumnName = strNameColumnName;
        this._strUrlColumnName = strUrlColumnName;
        this._strDescColumnName = strDescColumnName;
    }

    public String[] getColumns() {
        String[] aColumns = new String[]{this._strNameColumnName, this._strUrlColumnName, this._strDescColumnName};
        return aColumns;
    }

    public Object unmarshall(Container container, ResultSet rst, String strTableAlias) throws SQLException {
        try {
            return new BbLink(DbUtil.getString((ResultSet)rst, (String)this.buildColumnName(strTableAlias, this._strNameColumnName)), DbUtil.getString((ResultSet)rst, (String)this.buildColumnName(strTableAlias, this._strUrlColumnName)), DbUtil.getString((ResultSet)rst, (String)this.buildColumnName(strTableAlias, this._strDescColumnName)));
        }
        catch (ConstraintViolationException cve) {
            return null;
        }
    }

    public Object unmarshall(Container container, CallableStatement stmt, int nStartPos) throws SQLException, PersistenceException {
        throw new RuntimeException("Unmarshalling from a CallableStatement is not implemented yet");
    }

    public int marshall(Container container, PreparedStatement stmt, int nStartPos, Object obj) throws SQLException {
        BbLink bLink = (BbLink)obj;
        BbDatabase bbDatabase = BbDatabase.getDefaultInstance();
        if (bLink != null) {
            DbUtil.setNString((BbDatabase)bbDatabase, (PreparedStatement)stmt, (int)nStartPos, (String)bLink.getName());
            DbUtil.setInteger((PreparedStatement)stmt, (int)(nStartPos + 1), (int)ConversionUtility.booleanToInt(bLink.getBbAttributes().getBbAttribute("Name").getIsDirty()));
            DbUtil.setString((PreparedStatement)stmt, (int)(nStartPos + 2), (String)bLink.getUrl());
            DbUtil.setInteger((PreparedStatement)stmt, (int)(nStartPos + 3), (int)ConversionUtility.booleanToInt(bLink.getBbAttributes().getBbAttribute("Url").getIsDirty()));
            DbUtil.setNString((BbDatabase)bbDatabase, (PreparedStatement)stmt, (int)(nStartPos + 4), (String)bLink.getDescription());
            DbUtil.setInteger((PreparedStatement)stmt, (int)(nStartPos + 5), (int)ConversionUtility.booleanToInt(bLink.getBbAttributes().getBbAttribute("Description").getIsDirty()));
        } else {
            DbUtil.setNString((BbDatabase)bbDatabase, (PreparedStatement)stmt, (int)nStartPos, null);
            DbUtil.setInteger((PreparedStatement)stmt, (int)(nStartPos + 1), (int)ConversionUtility.booleanToInt(false));
            DbUtil.setString((PreparedStatement)stmt, (int)(nStartPos + 2), null);
            DbUtil.setInteger((PreparedStatement)stmt, (int)(nStartPos + 3), (int)ConversionUtility.booleanToInt(false));
            DbUtil.setNString((BbDatabase)bbDatabase, (PreparedStatement)stmt, (int)(nStartPos + 4), null);
            DbUtil.setInteger((PreparedStatement)stmt, (int)(nStartPos + 5), (int)ConversionUtility.booleanToInt(false));
        }
        return 6;
    }

    public void registerOutParameter(CallableStatement stmt, int nStartPos) throws SQLException {
        throw new RuntimeException("Output parameter handling for a CallableStatement is not implemented yet");
    }

    public Object unmarshall(Element e) throws PersistenceException {
        Element target = this.getRootElement(e);
        BbLink link = new BbLink();
        link.setName(target.getAttribute(this._strNameColumnName));
        link.setUrl(XmlUtil.getElementValue((Element)target, (String)this._strUrlColumnName));
        link.setDescription(XmlUtil.getElementValue((Element)target, (String)this._strDescColumnName));
        return link;
    }

    public Element marshall(Document doc, Object obj) throws PersistenceException {
        BbLink link = (BbLink)obj;
        Element e = doc.createElement(this.getName());
        e.setAttribute(this._strNameColumnName, link.getName());
        XmlUtil.buildChildElement((Document)doc, (Element)e, (String)this._strUrlColumnName, (String)link.getUrl());
        XmlUtil.buildChildElement((Document)doc, (Element)e, (String)this._strDescColumnName, (String)link.getDescription());
        return e;
    }
}

