/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.soap.admincoursecourse;

import blackboard.admin.data.course.AdminCourseCourse;
import blackboard.admin.persist.course.AdminCourseCourseLoader;
import blackboard.admin.persist.course.AdminCourseCoursePersister;
import blackboard.admin.persist.course.impl.soap.admincoursecourse.ClientUtility;
import blackboard.admin.persist.impl.soap.IServerUtility;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.authority.RuntimeAuthority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.DataType;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.Loader;
import blackboard.persist.PersistenceException;
import blackboard.persist.Persister;
import blackboard.util.ObjectSerializer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ServerUtility
implements IServerUtility {
    public static final String ID_LIST = "admincoursecourse.id.list";

    public static String insert(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        AdminCourseCoursePersister p = (AdminCourseCoursePersister)ServerUtility.getPersister();
        List<AdminCourseCourse> list = ServerUtility.unMarshallObjects(obj, AdminCourseCourse.DATA_TYPE);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        for (AdminCourseCourse tmp : list) {
            p.insert(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String update(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        AdminCourseCoursePersister p = (AdminCourseCoursePersister)ServerUtility.getPersister();
        List<AdminCourseCourse> list = ServerUtility.unMarshallObjects(obj, AdminCourseCourse.DATA_TYPE);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        for (AdminCourseCourse tmp : list) {
            p.update(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        AdminCourseCoursePersister p = (AdminCourseCoursePersister)ServerUtility.getPersister();
        List<AdminCourseCourse> list = ServerUtility.unMarshallObjects(obj, AdminCourseCourse.DATA_TYPE);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        for (AdminCourseCourse tmp : list) {
            p.save(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj, String session, String strProps) throws PersistenceException {
        AdminCourseCoursePersister p = (AdminCourseCoursePersister)ServerUtility.getPersister();
        Properties props = (Properties)ObjectSerializer.deSerializeObject((String)strProps);
        List<AdminCourseCourse> list = ServerUtility.unMarshallObjects(props, obj, AdminCourseCourse.DATA_TYPE);
        Results results = p.save(list, session);
        Iterator<AdminCourseCourse> iter = list.iterator();
        ArrayList<String> aList = new ArrayList<String>(list.size());
        while (iter.hasNext()) {
            AdminCourseCourse tmp = iter.next();
            aList.add(tmp.getId().toExternalString());
        }
        ((RemoteResults)results).setAttribute(ID_LIST, aList);
        return ObjectSerializer.serializeObject((Object)results);
    }

    public static void remove(String obj) throws PersistenceException, ValidationException {
        AdminCourseCoursePersister p = (AdminCourseCoursePersister)ServerUtility.getPersister();
        List<AdminCourseCourse> list = ServerUtility.unMarshallObjects(obj, AdminCourseCourse.DATA_TYPE);
        AdminCourseCourse sa = list.get(0);
        p.remove(sa);
    }

    public static String removeList(String obj) throws PersistenceException {
        AdminCourseCoursePersister p = (AdminCourseCoursePersister)ServerUtility.getPersister();
        List<AdminCourseCourse> list = ServerUtility.unMarshallObjects(obj, AdminCourseCourse.DATA_TYPE);
        return ObjectSerializer.serializeObject((Object)p.remove(list));
    }

    public static String createSession(String dataSourceBatchUid) throws PersistenceException {
        AdminCourseCoursePersister p = (AdminCourseCoursePersister)ServerUtility.getPersister();
        return p.createSession(dataSourceBatchUid);
    }

    public static void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        AdminCourseCoursePersister p = (AdminCourseCoursePersister)ServerUtility.getPersister();
        p.createSession(dataSourceBatchUid, sessionId);
    }

    public static void closeSession(String strSessionId) throws PersistenceException {
        AdminCourseCoursePersister p = (AdminCourseCoursePersister)ServerUtility.getPersister();
        p.closeSession(strSessionId);
    }

    public static String load(String crsBatchUid, String personBatchUid) throws PersistenceException, KeyNotFoundException {
        AdminCourseCourseLoader l = (AdminCourseCourseLoader)ServerUtility.getLoader();
        AdminCourseCourse obj = l.load(crsBatchUid, personBatchUid);
        return ClientUtility.convertToString(obj);
    }

    public static String loadByTemplate(String template) throws PersistenceException {
        AdminCourseCourseLoader l = (AdminCourseCourseLoader)ServerUtility.getLoader();
        List<AdminCourseCourse> list = ServerUtility.unMarshallObjects(template, AdminCourseCourse.DATA_TYPE);
        if (list.size() == 0) {
            return "";
        }
        list = l.load(list.get(0));
        return ClientUtility.convertToString(list);
    }

    private static Persister getPersister() throws PersistenceException {
        return AdminCourseCoursePersister.Default.getInstance();
    }

    private static Loader getLoader() throws PersistenceException {
        return AdminCourseCourseLoader.Default.getInstance();
    }

    public static List<AdminCourseCourse> unMarshallObjects(String src, DataType dType) throws PersistenceException {
        return ServerUtility.unMarshallObjects(new Properties(), src, dType);
    }

    public static List<AdminCourseCourse> unMarshallObjects(Properties props, String src, DataType dType) throws PersistenceException {
        try {
            props.setProperty("DATA_TYPE_TOGGLE", dType.getName());
            RuntimeAuthority ra = new RuntimeAuthority(props, new StringReader(src), Authority.Operation.MANUAL);
            ra.execute();
            return ra.getObjectList();
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }
}

