/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.soap.coursestandardsubdocument;

import blackboard.admin.data.course.CourseStandardSubDocument;
import blackboard.admin.persist.course.CourseStandardSubDocumentXmlPersister;
import blackboard.admin.persist.impl.soap.IClientUtility;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.persist.PersistenceException;
import blackboard.util.ObjectSerializer;
import blackboard.xml.XmlUtil;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;

public class ClientUtility
implements IClientUtility {
    private static final String SOAP_URN = "CourseStdSubDocServerUtility";
    private static final String SAVE = "save";
    private static final String REMOVE = "remove";
    private String _sMethod;
    private final Vector<String> _vArgs = new Vector();

    public String getObjectNameSpace() {
        return SOAP_URN;
    }

    public String getMethodName() {
        return this._sMethod;
    }

    public Vector<String> getArguments() {
        return this._vArgs;
    }

    public void save(List<CourseStandardSubDocument> objList) throws PersistenceException {
        this._sMethod = SAVE;
        this.setArgs(objList);
    }

    public void remove(List<CourseStandardSubDocument> objList) throws PersistenceException {
        this._sMethod = REMOVE;
        this.setArgs(objList);
    }

    private void setArgs(List<CourseStandardSubDocument> objList) throws PersistenceException {
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(objList));
        this._vArgs.add(ObjectSerializer.serializeObject((Object)Authority.getSettings()));
    }

    private static final String convertToString(List<CourseStandardSubDocument> list) throws PersistenceException {
        try {
            Document doc = XmlUtil.buildDocument();
            ((CourseStandardSubDocumentXmlPersister)CourseStandardSubDocumentXmlPersister.Default.getInstance()).persist(list, doc);
            return XmlUtil.createEncodedStringFromDoc((Document)doc, (boolean)false, (String)"UTF-8");
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (IOException io) {
            throw new PersistenceException((Throwable)io);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

