/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.soap.membership;

import blackboard.admin.data.course.Enrollment;
import blackboard.admin.data.course.Membership;
import blackboard.admin.data.course.OrganizationMembership;
import blackboard.admin.data.course.StaffAssignment;
import blackboard.admin.persist.course.EnrollmentLoader;
import blackboard.admin.persist.course.EnrollmentPersister;
import blackboard.admin.persist.course.OrganizationMembershipLoader;
import blackboard.admin.persist.course.OrganizationMembershipPersister;
import blackboard.admin.persist.course.StaffAssignmentLoader;
import blackboard.admin.persist.course.StaffAssignmentPersister;
import blackboard.admin.persist.course.impl.soap.membership.ClientUtility;
import blackboard.admin.persist.impl.soap.IServerUtility;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.authority.RuntimeAuthority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.SnapshotPersister;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.DataType;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.Loader;
import blackboard.persist.PersistenceException;
import blackboard.platform.persistence.PersistenceServiceFactory;
import blackboard.util.ObjectSerializer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ServerUtility
implements IServerUtility {
    public static final String ID_LIST = "membership.id.list";

    public static String insert(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        List<? extends Membership> list = ServerUtility.unMarshallObjects(obj, Membership.DATA_TYPE);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        SnapshotPersister p = ServerUtility.getPersister(list);
        for (Membership membership : list) {
            if (p instanceof EnrollmentPersister) {
                ((EnrollmentPersister)p).insert((Enrollment)membership);
            } else if (p instanceof OrganizationMembershipPersister) {
                ((OrganizationMembershipPersister)p).insert((OrganizationMembership)membership);
            } else {
                ((StaffAssignmentPersister)p).insert((StaffAssignment)membership);
            }
            aList.add(membership.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String update(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        List<? extends Membership> list = ServerUtility.unMarshallObjects(obj, Membership.DATA_TYPE);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        SnapshotPersister p = ServerUtility.getPersister(list);
        for (Membership membership : list) {
            if (p instanceof EnrollmentPersister) {
                ((EnrollmentPersister)p).update((Enrollment)membership);
            } else if (p instanceof OrganizationMembershipPersister) {
                ((OrganizationMembershipPersister)p).update((OrganizationMembership)membership);
            } else {
                ((StaffAssignmentPersister)p).update((StaffAssignment)membership);
            }
            aList.add(membership.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        List<? extends Membership> list = ServerUtility.unMarshallObjects(obj, Membership.DATA_TYPE);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        SnapshotPersister p = ServerUtility.getPersister(list);
        for (Membership membership : list) {
            if (p instanceof EnrollmentPersister) {
                ((EnrollmentPersister)p).save((Enrollment)membership);
            } else if (p instanceof OrganizationMembershipPersister) {
                ((OrganizationMembershipPersister)p).save((OrganizationMembership)membership);
            } else {
                ((StaffAssignmentPersister)p).save((StaffAssignment)membership);
            }
            aList.add(membership.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj, String session, String strProps) throws PersistenceException {
        Properties props = (Properties)ObjectSerializer.deSerializeObject((String)strProps);
        List<? extends Membership> list = ServerUtility.unMarshallObjects(props, obj, Membership.DATA_TYPE);
        SnapshotPersister p = ServerUtility.getPersister(list);
        Results results = p.save(list, session);
        Iterator<? extends Membership> iter = list.iterator();
        ArrayList<String> aList = new ArrayList<String>(list.size());
        while (iter.hasNext()) {
            Membership tmp = iter.next();
            aList.add(tmp.getId().toExternalString());
        }
        ((RemoteResults)results).setAttribute(ID_LIST, aList);
        return ObjectSerializer.serializeObject((Object)results);
    }

    public static void remove(String obj) throws PersistenceException, ValidationException {
        List<? extends Membership> list = ServerUtility.unMarshallObjects(obj, Membership.DATA_TYPE);
        SnapshotPersister p = ServerUtility.getPersister(list);
        Membership sa = list.get(0);
        if (p instanceof EnrollmentPersister) {
            ((EnrollmentPersister)p).remove((Enrollment)sa);
        } else if (p instanceof OrganizationMembershipPersister) {
            ((OrganizationMembershipPersister)p).remove((OrganizationMembership)sa);
        } else {
            ((StaffAssignmentPersister)p).remove((StaffAssignment)sa);
        }
    }

    public static String removeList(String obj) throws PersistenceException {
        List<? extends Membership> list = ServerUtility.unMarshallObjects(obj, Membership.DATA_TYPE);
        SnapshotPersister p = ServerUtility.getPersister(list);
        return ObjectSerializer.serializeObject((Object)p.remove(list));
    }

    public static String createSession(String dataSourceBatchUid, String persisterType) throws PersistenceException {
        return ServerUtility.getPersister(persisterType).createSession(dataSourceBatchUid);
    }

    public static void createSession(String dataSourceBatchUid, String persisterType, String sessionId) throws PersistenceException {
        ServerUtility.getPersister(persisterType).createSession(dataSourceBatchUid, sessionId);
    }

    public static void closeSession(String strSessionId, String persisterType) throws PersistenceException {
        SnapshotPersister p = ServerUtility.getPersister(persisterType);
        p.closeSession(strSessionId);
    }

    public static String load(String crsBatchUid, String personBatchUid, String loaderType) throws PersistenceException, KeyNotFoundException {
        Membership obj = null;
        Loader oLoader = ServerUtility.getLoader(loaderType);
        obj = loaderType.equals("EnrollmentLoader") ? ((EnrollmentLoader)oLoader).load(crsBatchUid, personBatchUid) : (loaderType.equals("OrganizationMembershipLoader") ? ((OrganizationMembershipLoader)oLoader).load(crsBatchUid, personBatchUid) : ((StaffAssignmentLoader)oLoader).load(crsBatchUid, personBatchUid));
        return ClientUtility.convertToString(obj);
    }

    public static String loadByTemplate(String template) throws PersistenceException {
        List<? extends Membership> list = ServerUtility.unMarshallObjects(template, Membership.DATA_TYPE);
        if (list.size() == 0) {
            return "";
        }
        Membership pObj = list.get(0);
        if (pObj instanceof Enrollment) {
            EnrollmentLoader oLoader = EnrollmentLoader.Default.getInstance();
            list = oLoader.load((Enrollment)pObj);
        } else if (pObj instanceof OrganizationMembership) {
            OrganizationMembershipLoader oLoader = OrganizationMembershipLoader.Default.getInstance();
            list = oLoader.load((OrganizationMembership)pObj);
        } else {
            StaffAssignmentLoader oLoader = StaffAssignmentLoader.Default.getInstance();
            list = oLoader.load((StaffAssignment)pObj);
        }
        return ClientUtility.convertToString(list);
    }

    private static SnapshotPersister getPersister(List l) throws PersistenceException {
        String type = "StaffAssignmentPersister";
        if (l.size() > 0) {
            Object pObj = l.get(0);
            if (pObj instanceof Enrollment) {
                type = "EnrollmentPersister";
            } else if (pObj instanceof OrganizationMembership) {
                type = "OrganizationMembershipPersister";
            }
        }
        return ServerUtility.getPersister(type);
    }

    private static SnapshotPersister getPersister(String type) throws PersistenceException {
        return (SnapshotPersister)PersistenceServiceFactory.getInstance().getDbPersistenceManager().getPersister(type);
    }

    private static Loader getLoader(String type) throws PersistenceException {
        return PersistenceServiceFactory.getInstance().getDbPersistenceManager().getLoader(type);
    }

    public static List<? extends Membership> unMarshallObjects(String src, DataType dType) throws PersistenceException {
        return ServerUtility.unMarshallObjects(new Properties(), src, dType);
    }

    public static List<? extends Membership> unMarshallObjects(Properties props, String src, DataType dType) throws PersistenceException {
        try {
            props.setProperty("DATA_TYPE_TOGGLE", dType.getName());
            RuntimeAuthority ra = new RuntimeAuthority(props, new StringReader(src), Authority.Operation.MANUAL);
            ra.execute();
            return ra.getObjectList();
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }
}

