/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.datasource;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.data.category.CourseCategoryMembership;
import blackboard.admin.data.category.OrganizationCategory;
import blackboard.admin.data.category.OrganizationCategoryMembership;
import blackboard.admin.data.course.AdminCourseCourse;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.Enrollment;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.institutinalhierarchy.CourseAssociation;
import blackboard.admin.data.institutinalhierarchy.InstitutionalHierarchyNode;
import blackboard.admin.data.institutinalhierarchy.OrganizationAssociation;
import blackboard.admin.data.institutinalhierarchy.UserAssociation;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.data.user.Person;
import blackboard.data.ValidationException;
import blackboard.persist.DataType;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.platform.api.PublicAPI;
import blackboard.platform.institutionalhierarchy.NodeInternal;
import blackboard.platform.term.Term;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

@PublicAPI
public interface DataSourceManager {
    public static final DataType[] NON_ROW_STATUS_ENTITY_DATA_TYPES = new DataType[]{NodeInternal.DATA_TYPE, UserAssociation.DATA_TYPE, CourseAssociation.DATA_TYPE, OrganizationAssociation.DATA_TYPE};

    public List<DataSource> loadAll() throws PersistenceException;

    public DataSource loadByBatchUid(String var1) throws PersistenceException, KeyNotFoundException;

    public DataSource create(String var1, String var2) throws PersistenceException, ValidationException;

    public void modify(DataSource var1) throws PersistenceException, KeyNotFoundException, ValidationException;

    public void delete(String var1) throws PersistenceException, KeyNotFoundException;

    public void disableAll(String var1, Calendar var2) throws PersistenceException;

    public void disableEntity(String var1, EntityType var2, Calendar var3) throws PersistenceException;

    public void purgeAll(String var1, Calendar var2) throws PersistenceException;

    public void purgeEntity(String var1, EntityType var2, Calendar var3) throws PersistenceException;

    public void purgeSnapshotSessions() throws PersistenceException;

    public String beginSnapshotSession() throws PersistenceException;

    public void beginSnapshotSession(String var1) throws PersistenceException;

    public void endSnapshotSession(String var1) throws PersistenceException;

    public Map<EntityType, Long> loadObjectCounts(String var1, IAdminObject.RowStatus var2) throws PersistenceException;

    public Map<EntityType, Long> loadObjectCountsForDisable(String var1) throws PersistenceException;

    public Map<EntityType, Long> loadObjectCountsForPurge(String var1) throws PersistenceException;

    public static enum EntityType {
        Person(blackboard.admin.data.user.Person.DATA_TYPE, "users"),
        Membership(Enrollment.DATA_TYPE, "course_users"),
        CourseOrg(CourseSite.DATA_TYPE, "course_main"),
        CourseCategory(blackboard.admin.data.category.CourseCategory.DATA_TYPE, "gateway_categories"),
        CourseCategoryMembership(blackboard.admin.data.category.CourseCategoryMembership.DATA_TYPE, "gateway_course_categories"),
        CourseCourse(AdminCourseCourse.DATA_TYPE, "course_course"),
        OrganizationCategory(blackboard.admin.data.category.OrganizationCategory.DATA_TYPE, "community_categories"),
        OrganizationCategoryMembership(blackboard.admin.data.category.OrganizationCategoryMembership.DATA_TYPE, "community_course_categories"),
        InstitutionRoleMembership(PortalRoleMembership.DATA_TYPE, "user_roles"),
        ObserverAssociation(blackboard.admin.data.user.ObserverAssociation.DATA_TYPE, "observer_user"),
        Term(blackboard.platform.term.Term.DATA_TYPE, "term"),
        InstitutionalHierarchyNode(blackboard.admin.data.institutinalhierarchy.InstitutionalHierarchyNode.DATA_TYPE, "mi_node"),
        UserAssociation(blackboard.admin.data.institutinalhierarchy.UserAssociation.DATA_TYPE, "domain_user_coll"),
        CourseAssociation(blackboard.admin.data.institutinalhierarchy.CourseAssociation.DATA_TYPE, "domain_course_coll"),
        OrganizationAssociation(blackboard.admin.data.institutinalhierarchy.OrganizationAssociation.DATA_TYPE, "domain_organization_coll");

        private DataType _dataType;
        private String _tableName;

        private EntityType(DataType dataType, String tableName) {
            this._dataType = dataType;
            this._tableName = tableName;
        }

        public DataType getDataType() {
            return this._dataType;
        }

        public String getTableName() {
            return this._tableName;
        }

        public static EntityType fromTableName(String tableName) {
            for (EntityType e : EntityType.values()) {
                if (!e.getTableName().equalsIgnoreCase(tableName)) continue;
                return e;
            }
            throw new IllegalArgumentException("Associated element not found in enum: " + tableName);
        }
    }
}

