/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.impl;

import blackboard.admin.persist.impl.soap.IClientUtility;
import blackboard.base.AppVersion;
import blackboard.base.NestedException;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.Loader;
import blackboard.persist.PersistenceException;
import blackboard.platform.LicenseComponent;
import blackboard.platform.LicenseManagerFactory;
import blackboard.platform.RuntimeBbServiceException;
import blackboard.platform.soap.ClientRequest;
import blackboard.platform.soap.ServerResponse;
import blackboard.platform.soap.service.BbSoapClientService;
import blackboard.platform.soap.service.BbSoapClientServiceFactory;

public abstract class AdminLoader
implements Loader {
    protected static final String DOES_NOT_EXIST = "does not exist";
    protected BbPersistenceManager _pm = null;
    protected AppVersion _appVersion = null;

    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        block2: {
            this._pm = pm;
            this._appVersion = appVersion;
            try {
                this.checkApiLicensing();
            }
            catch (RuntimeBbServiceException e) {
                if (!LicenseManagerFactory.getInstance().isLicensed(LicenseComponent.INTEGRATION_APIS)) break block2;
                throw e;
            }
        }
    }

    public AppVersion getAppVersion() {
        return this._appVersion;
    }

    protected void checkApiLicensing() {
        LicenseManagerFactory.getInstance().runtimeAssertIsLicensed(LicenseComponent.INTEGRATION_APIS);
    }

    protected ServerResponse executeSoapCall(IClientUtility request) throws PersistenceException {
        BbSoapClientService service = BbSoapClientServiceFactory.getInstance();
        try {
            return service.processRequest(null, (ClientRequest)request);
        }
        catch (NestedException e) {
            String message = e.getFullMessageTrace();
            if (message.indexOf(DOES_NOT_EXIST) > -1) {
                throw new KeyNotFoundException(message);
            }
            throw new PersistenceException((Throwable)e);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

