/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.role.impl;

import blackboard.admin.persist.impl.AdminSelectQuery;
import blackboard.db.DbUtil;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.SimpleSelectQuery;
import blackboard.persist.impl.mapping.ClobMapping;
import blackboard.persist.impl.mapping.DbObjectMap;
import blackboard.persist.impl.mapping.IDbLobMapping;
import blackboard.persist.impl.mapping.Mapping;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;

public class AdminUserRoleSelectQuery
extends AdminSelectQuery {
    public AdminUserRoleSelectQuery(DbObjectMap map, String tableName) {
        super(map, tableName);
    }

    @Override
    protected Statement prepareStatement(Connection con) throws SQLException, PersistenceException {
        StringBuilder sql = new StringBuilder();
        SimpleSelectQuery.Where where = null;
        SimpleSelectQuery.OrderBy orderBy = null;
        Mapping mapping = null;
        sql.append("SELECT " + this._tableName + ".*, data_source.batch_uid as data_src_batch_uid " + " FROM " + this._tableName + ", data_source ");
        if (this._whereList.size() > 0) {
            sql.append(" WHERE ");
            int actualCount = 0;
            for (int i = 0; i < this._whereList.size(); ++i) {
                where = (SimpleSelectQuery.Where)this._whereList.get(i);
                mapping = this._map.getMapping(where._strName);
                if (mapping == null) continue;
                if (actualCount > 0) {
                    sql.append(" AND ");
                }
                ++actualCount;
                String[] aColumns = mapping.getColumns();
                boolean bPersonBatchUid = false;
                boolean bRoleBatchUid = false;
                for (int j = 0; j < aColumns.length; ++j) {
                    String queryPrefix = aColumns[j];
                    if (queryPrefix.equals("data_src_batch_uid")) {
                        queryPrefix = "data_source.batch_uid";
                    } else if (queryPrefix.equals("p_person_batch_uid")) {
                        bPersonBatchUid = true;
                        queryPrefix = " user_roles.users_pk1 in ( select pk1 from users where batch_uid ";
                    } else if (queryPrefix.equals("p_portal_role_batch_uid")) {
                        bRoleBatchUid = true;
                        queryPrefix = " user_roles.institution_roles_pk1 in ( select pk1 from institution_roles where batch_uid ";
                    } else {
                        queryPrefix = this._tableName + "." + queryPrefix;
                    }
                    if (j > 0) {
                        sql.append(" AND ");
                    }
                    if (queryPrefix.indexOf("date") > -1 && where._type != 3) {
                        sql.append(queryPrefix + " >=  ? ");
                    } else if (where._type == 2) {
                        sql.append(queryPrefix + " LIKE ?");
                    } else if (where._type == 4) {
                        sql.append(queryPrefix + " IS NOT NULL");
                    } else if (where._type == 3) {
                        sql.append(queryPrefix + " IS NULL");
                    } else if (where._type == 5) {
                        sql.append(queryPrefix + " <=  ? ");
                    } else if (where._type == 6) {
                        sql.append(queryPrefix + " >=  ? ");
                    } else {
                        sql.append(queryPrefix + " = ?");
                    }
                    if (!bPersonBatchUid && !bRoleBatchUid) continue;
                    sql.append(" ) ");
                }
            }
        }
        if (this._whereList.size() > 0) {
            sql.append(" AND data_source.pk1 = " + this._tableName + ".data_src_pk1 ");
        } else {
            sql.append(" WHERE data_source.pk1 = " + this._tableName + ".data_src_pk1 ");
        }
        if (this._orderByList.size() > 0) {
            sql.append(" ORDER BY ");
            for (int i = 0; i < this._orderByList.size(); ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                orderBy = (SimpleSelectQuery.OrderBy)this._orderByList.get(i);
                mapping = this._map.getMapping(orderBy._strName);
                String[] aColumns = mapping.getColumns();
                for (int j = 0; j < aColumns.length; ++j) {
                    if (j > 0) {
                        sql.append(", ");
                    }
                    sql.append(aColumns[j] + " " + (orderBy._bAscending ? "ASC" : "DESC"));
                }
            }
        }
        PreparedStatement stmt = con.prepareStatement(sql.toString());
        if (this._whereList.size() > 0) {
            int nStartPos = 1;
            for (int i = 0; i < this._whereList.size(); ++i) {
                where = (SimpleSelectQuery.Where)this._whereList.get(i);
                mapping = this._map.getMapping(where._strName);
                if (mapping == null) continue;
                if (where._type == 1 || where._type == 2) {
                    nStartPos = mapping instanceof IDbLobMapping ? (nStartPos += ((ClobMapping)mapping).marshallAsString(this.getContainer(), stmt, nStartPos, where._obj)) : (nStartPos += mapping.marshall(this.getContainer(), stmt, nStartPos, where._obj));
                }
                if (where._type != 5 && where._type != 6) continue;
                DbUtil.setCalendar((PreparedStatement)stmt, (int)nStartPos, (Calendar)((Calendar)where._obj));
                ++nStartPos;
            }
        }
        return stmt;
    }
}

