/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.role.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.persist.role.PortalRoleMembershipLoader;
import blackboard.admin.persist.role.PortalRoleMembershipPersister;
import blackboard.admin.persist.role.impl.PortalRoleMembershipDbLoader;
import blackboard.admin.persist.role.impl.mapping.PortalRoleMembershipDeleteDbMap;
import blackboard.admin.persist.role.impl.mapping.PortalRoleMembershipPersisterDbMap;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.data.BbObject;
import blackboard.data.Identifiable;
import blackboard.data.ValidationException;
import blackboard.data.user.UserRoleUID;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;
import blackboard.persist.user.impl.UserRoleUIDDAO;
import blackboard.util.StringUtil;
import blackboard.util.UuidFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PortalRoleMembershipDbPersister
extends SnapshotDbPersister<PortalRoleMembership>
implements PortalRoleMembershipPersister {
    String[] CONSTRAINTS = new String[]{"USER_ROLES_PK", "USERS_INST_ROLES_UK1"};

    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "userrole");
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "userrole", sessionId);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "userrole");
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        String batchUID = this.resolvePortalRoleBatchUid((PortalRoleMembership)obj);
        this.save((PortalRoleMembership)obj, strSessionId);
        this.savePortalRoleBatchUID((PortalRoleMembership)obj, batchUID);
    }

    @Override
    public Results save(List<PortalRoleMembership> objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        HashMap<PortalRoleMembership, String> batchUIDs = new HashMap<PortalRoleMembership, String>();
        String batchUID = null;
        for (PortalRoleMembership prm : objList) {
            try {
                batchUID = this.resolvePortalRoleBatchUid(prm);
                batchUIDs.put(prm, batchUID);
            }
            catch (PersistenceException e) {}
        }
        Results results = super.save(PortalRoleMembershipPersisterDbMap.MAP, objList, strSessionId);
        for (Map.Entry entry : batchUIDs.entrySet()) {
            if (this.isEntryInErrors((PortalRoleMembership)entry.getKey(), results)) continue;
            this.savePortalRoleBatchUID((PortalRoleMembership)entry.getKey(), (String)entry.getValue(), results);
        }
        return results;
    }

    private boolean isEntryInErrors(PortalRoleMembership prm, Results results) {
        String personBatchUid = prm.getPersonBatchUid();
        String portalRoleBatchUid = prm.getPortalRoleBatchUid();
        PortalRoleMembership errPrm = null;
        String errPortalRoleBatchUid = null;
        for (Results.Error err : results.getList()) {
            errPrm = (PortalRoleMembership)err.getObject();
            String errPersonBatchUid = errPrm.getPersonBatchUid();
            errPortalRoleBatchUid = errPrm.getPortalRoleBatchUid();
            if (!personBatchUid.equals(errPersonBatchUid) || !portalRoleBatchUid.equals(errPortalRoleBatchUid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Results remove(List<PortalRoleMembership> objList) throws PersistenceException {
        return super.remove(PortalRoleMembershipDeleteDbMap.MAP, objList);
    }

    @Override
    public void save(PortalRoleMembership objToSave) throws PersistenceException {
        this.resolveBatchUid(objToSave);
        this.handleAttributeTokens(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(PortalRoleMembershipPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    @Override
    public void save(PortalRoleMembership objToSave, String strSessionId) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        super.save(PortalRoleMembershipPersisterDbMap.MAP, objToSave, strSessionId);
    }

    @Override
    public void insert(PortalRoleMembership objToSave) throws PersistenceException, ConstraintViolationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(PortalRoleMembershipPersisterDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void update(PortalRoleMembership objToSave) throws PersistenceException, KeyNotFoundException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(PortalRoleMembershipPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    @Override
    public void remove(PortalRoleMembership objToRemove) throws KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(PortalRoleMembershipDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    private void resolveBatchUid(PortalRoleMembership objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("PersonBatchUid").getIsDirty() && objInput.getBbAttributes().getBbAttribute("PortalRoleBatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        PortalRoleMembershipDbLoader loader = (PortalRoleMembershipDbLoader)this._pm.getLoader("PortalRoleMembershipLoader");
        PortalRoleMembership obj = new PortalRoleMembership();
        obj.setId(objInput.getId());
        List<PortalRoleMembership> list = loader.load(obj);
        PortalRoleMembership personRole = this.getSingleItem(list, obj);
        objInput.setPersonBatchUid(personRole.getPersonBatchUid());
        objInput.setPortalRoleBatchUid(personRole.getPortalRoleBatchUid());
    }

    private void resolveBatchUid(List<PortalRoleMembership> list) throws PersistenceException {
        for (PortalRoleMembership obj : list) {
            this.resolveBatchUid(obj);
        }
    }

    private String resolvePortalRoleBatchUid(PortalRoleMembership obj) throws PersistenceException {
        PortalRoleMembership prm = null;
        try {
            prm = ((PortalRoleMembershipLoader)PortalRoleMembershipDbLoader.Default.getInstance()).load(obj.getPersonBatchUid(), obj.getPortalRoleBatchUid());
        }
        catch (KeyNotFoundException e) {
        }
        catch (PersistenceException e) {
            throw e;
        }
        if (null != prm && Id.isValidPkId((Id)prm.getId())) {
            try {
                new UserRoleUIDDAO().loadByUserRolesId(prm.getId());
                return null;
            }
            catch (Exception e) {
                return UuidFactory.createUuid();
            }
        }
        return UuidFactory.createUuid();
    }

    private void savePortalRoleBatchUID(PortalRoleMembership obj, String batchUID, Results results) {
        block2: {
            try {
                this.savePortalRoleBatchUID(obj, batchUID);
            }
            catch (Exception e) {
                if (results == null) break block2;
                results.addError((BbObject)obj, e);
            }
        }
    }

    private void savePortalRoleBatchUID(PortalRoleMembership obj, String batchUID) {
        if (null != obj && Id.isValid((Id)obj.getId()) && StringUtil.notEmpty((String)batchUID)) {
            UserRoleUIDDAO uidDAO = new UserRoleUIDDAO();
            uidDAO.deleteByUserRolesId(obj.getId());
            UserRoleUID membershipUID = new UserRoleUID();
            membershipUID.setBatchUID(batchUID);
            membershipUID.setUserRolesId(obj.getId());
            uidDAO.persist((Identifiable)membershipUID);
        }
    }
}

