/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.role.impl.soap.portalrolemembership;

import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.persist.impl.soap.IServerUtility;
import blackboard.admin.persist.role.PortalRoleMembershipLoader;
import blackboard.admin.persist.role.PortalRoleMembershipPersister;
import blackboard.admin.persist.role.impl.soap.portalrolemembership.ClientUtility;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.authority.RuntimeAuthority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.Loader;
import blackboard.persist.PersistenceException;
import blackboard.persist.Persister;
import blackboard.util.ObjectSerializer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ServerUtility
implements IServerUtility {
    public static final String ID_LIST = "portalrolemembership.id.list";

    public static String insert(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        PortalRoleMembershipPersister p = (PortalRoleMembershipPersister)ServerUtility.getPersister();
        List<PortalRoleMembership> list = ServerUtility.unMarshallObjects(obj);
        Iterator<PortalRoleMembership> iter = list.iterator();
        ArrayList<String> aList = new ArrayList<String>(list.size());
        while (iter.hasNext()) {
            PortalRoleMembership tmp = iter.next();
            p.insert(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String update(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        PortalRoleMembershipPersister p = (PortalRoleMembershipPersister)ServerUtility.getPersister();
        List<PortalRoleMembership> list = ServerUtility.unMarshallObjects(obj);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        for (PortalRoleMembership tmp : list) {
            p.update(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        PortalRoleMembershipPersister p = (PortalRoleMembershipPersister)ServerUtility.getPersister();
        List<PortalRoleMembership> list = ServerUtility.unMarshallObjects(obj);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        for (PortalRoleMembership tmp : list) {
            p.save(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj, String session, String strProps) throws PersistenceException {
        PortalRoleMembershipPersister p = (PortalRoleMembershipPersister)ServerUtility.getPersister();
        Properties props = (Properties)ObjectSerializer.deSerializeObject((String)strProps);
        List<PortalRoleMembership> list = ServerUtility.unMarshallObjects(props, obj);
        Results results = p.save(list, session);
        Iterator<PortalRoleMembership> iter = list.iterator();
        ArrayList<String> aList = new ArrayList<String>(list.size());
        while (iter.hasNext()) {
            PortalRoleMembership tmp = iter.next();
            if (Id.isValidPkId((Id)tmp.getId())) {
                aList.add(tmp.getId().toExternalString());
                continue;
            }
            aList.add("");
        }
        ((RemoteResults)results).setAttribute(ID_LIST, aList);
        return ObjectSerializer.serializeObject((Object)results);
    }

    public static void remove(String obj) throws PersistenceException, ValidationException {
        PortalRoleMembershipPersister p = (PortalRoleMembershipPersister)ServerUtility.getPersister();
        List<PortalRoleMembership> list = ServerUtility.unMarshallObjects(obj);
        PortalRoleMembership person = list.get(0);
        p.remove(person);
    }

    public static String removeList(String obj) throws PersistenceException {
        PortalRoleMembershipPersister p = (PortalRoleMembershipPersister)ServerUtility.getPersister();
        List<PortalRoleMembership> list = ServerUtility.unMarshallObjects(obj);
        return ObjectSerializer.serializeObject((Object)p.remove(list));
    }

    public static String createSession(String dataSourceBatchUid) throws PersistenceException {
        PortalRoleMembershipPersister p = (PortalRoleMembershipPersister)ServerUtility.getPersister();
        return p.createSession(dataSourceBatchUid);
    }

    public static void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        PortalRoleMembershipPersister p = (PortalRoleMembershipPersister)ServerUtility.getPersister();
        p.createSession(dataSourceBatchUid, sessionId);
    }

    public static void closeSession(String strSessionId) throws PersistenceException {
        PortalRoleMembershipPersister p = (PortalRoleMembershipPersister)ServerUtility.getPersister();
        p.closeSession(strSessionId);
    }

    public static String load(String personBatchUid, String roleBatchUid) throws PersistenceException, KeyNotFoundException {
        PortalRoleMembershipLoader l = (PortalRoleMembershipLoader)ServerUtility.getLoader();
        PortalRoleMembership personrole = l.load(personBatchUid, roleBatchUid);
        return ClientUtility.convertToString(personrole);
    }

    public static String loadByTemplate(String template) throws PersistenceException {
        PortalRoleMembershipLoader l = (PortalRoleMembershipLoader)ServerUtility.getLoader();
        List<PortalRoleMembership> list = ServerUtility.unMarshallObjects(template);
        if (list.size() == 0) {
            return "";
        }
        list = l.load(list.get(0));
        return ClientUtility.convertToString(list);
    }

    private static Persister getPersister() throws PersistenceException {
        return PortalRoleMembershipPersister.Default.getInstance();
    }

    private static Loader getLoader() throws PersistenceException {
        return PortalRoleMembershipLoader.Default.getInstance();
    }

    public static List<PortalRoleMembership> unMarshallObjects(Properties props, String src) throws PersistenceException {
        try {
            RuntimeAuthority ra = new RuntimeAuthority(props, new StringReader(src), Authority.Operation.MANUAL);
            ra.execute();
            return ra.getObjectList();
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }

    public static List<PortalRoleMembership> unMarshallObjects(String src) throws PersistenceException {
        return ServerUtility.unMarshallObjects(null, src);
    }
}

