/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.user.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.persist.user.ObserverAssociationLoader;
import blackboard.admin.persist.user.ObserverAssociationPersister;
import blackboard.admin.persist.user.impl.ObserverAssociationDbLoader;
import blackboard.admin.persist.user.impl.mapping.ObserverAssociationDbMap;
import blackboard.admin.persist.user.impl.mapping.ObserverAssociationDeleteDbMap;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.Identifiable;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;
import blackboard.persist.user.UserDbLoader;
import blackboard.persist.user.impl.ObserverAssociationUID;
import blackboard.persist.user.impl.ObserverAssociationUIDDAO;
import blackboard.util.StringUtil;
import blackboard.util.UuidFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObserverAssociationDbPersister
extends SnapshotDbPersister<ObserverAssociation>
implements ObserverAssociationPersister {
    private static final String[] CONSTRAINTS = new String[]{"OBSERVER_USER_PK", "OBSERVER_USER_FK1", "OBSERVER_USER_FK2", "OBSERVER_USER_FK3"};

    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return this._createSession(dataSourceBatchUid, "obs_user");
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        this._createSession(dataSourceBatchUid, "obs_user", sessionId);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        this.closeSession(strSessionId, "obs_user");
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid((ObserverAssociation)obj);
        String batchUID = this.resolveObserverAssociationBatchUid((ObserverAssociation)obj);
        this.save(ObserverAssociationDbMap.MAP, obj, strSessionId);
        this.saveObserverAssociationBatchUID((ObserverAssociation)obj, batchUID);
    }

    @Override
    public Results save(List<ObserverAssociation> objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        HashMap<ObserverAssociation, String> batchUIDs = new HashMap<ObserverAssociation, String>();
        String batchUID = null;
        for (ObserverAssociation obsAssoc : objList) {
            try {
                batchUID = this.resolveObserverAssociationBatchUid(obsAssoc);
                batchUIDs.put(obsAssoc, batchUID);
            }
            catch (PersistenceException e) {}
        }
        Results results = this.save(ObserverAssociationDbMap.MAP, objList, strSessionId);
        for (Map.Entry entry : batchUIDs.entrySet()) {
            if (this.isEntryInErrors((ObserverAssociation)entry.getKey(), results)) continue;
            this.saveObserverAssociationBatchUID((ObserverAssociation)entry.getKey(), (String)entry.getValue(), results);
        }
        return results;
    }

    public boolean isEntryInErrors(ObserverAssociation oa, Results results) {
        String observerBatchUid = oa.getObserverBatchUid();
        String observeeBatchUid = oa.getUsersBatchUid();
        ObserverAssociation errPrm = null;
        String errObserveeBatchUid = null;
        for (Results.Error err : results.getList()) {
            errPrm = (ObserverAssociation)err.getObject();
            String errObserverBatchUid = errPrm.getObserverBatchUid();
            errObserveeBatchUid = errPrm.getUsersBatchUid();
            if (!observerBatchUid.equals(errObserverBatchUid) || !observeeBatchUid.equals(errObserveeBatchUid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Results remove(List<ObserverAssociation> objList) throws PersistenceException {
        return this.remove(ObserverAssociationDeleteDbMap.MAP, objList);
    }

    @Override
    public void save(ObserverAssociation objToSave) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        this.handleAttributeTokens(objToSave);
        objToSave.validate();
        String batchUID = this.resolveObserverAssociationBatchUid(objToSave);
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(ObserverAssociationDbMap.MAP, (BbObject)objToSave);
        this.runQuery((Query)query, null);
        this.saveObserverAssociationBatchUID(objToSave, batchUID);
    }

    @Override
    public void save(ObserverAssociation objToSave, String strSessionId) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        String batchUID = this.resolveObserverAssociationBatchUid(objToSave);
        this.save(ObserverAssociationDbMap.MAP, objToSave, strSessionId);
        this.saveObserverAssociationBatchUID(objToSave, batchUID);
    }

    @Override
    public void insert(ObserverAssociation objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        try {
            String batchUID = this.resolveObserverAssociationBatchUid(objToSave);
            AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(ObserverAssociationDbMap.MAP, (BbObject)objToSave);
            this.runQuery((Query)query, null);
            this.saveObserverAssociationBatchUID(objToSave, batchUID);
        }
        catch (PersistenceException e) {
            this._checkForConstraintViolation(e, CONSTRAINTS);
        }
    }

    @Override
    public void update(ObserverAssociation objToSave) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(ObserverAssociationDbMap.MAP, (BbObject)objToSave);
        this.runQuery((Query)query, null);
    }

    @Override
    public void remove(ObserverAssociation objToRemove) throws KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(ObserverAssociationDeleteDbMap.MAP, (BbObject)objToRemove);
        this.runQuery((Query)query, null);
    }

    private void resolveBatchUid(ObserverAssociation objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("ObserverBatchUid").getIsDirty() && objInput.getBbAttributes().getBbAttribute("UserBatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        ObserverAssociationDbLoader loader = (ObserverAssociationDbLoader)this._pm.getLoader("ObserverAssociationLoader");
        ObserverAssociation obj = new ObserverAssociation();
        obj.setId(objInput.getId());
        BbList<ObserverAssociation> list = loader.load(obj);
        ObserverAssociation oa = this.getSingleItem(list, obj);
        objInput.setObserverBatchUid(oa.getObserverBatchUid());
        objInput.setUsersBatchUid(oa.getUsersBatchUid());
    }

    private void resolveBatchUid(List<ObserverAssociation> list) throws PersistenceException {
        for (ObserverAssociation obj : list) {
            this.resolveBatchUid(obj);
        }
    }

    private String resolveObserverAssociationBatchUid(ObserverAssociation obj) throws PersistenceException {
        ObserverAssociation obsAssoc = null;
        try {
            obsAssoc = ObserverAssociationLoader.Default.getInstance().load(obj.getObserverBatchUid(), obj.getUsersBatchUid());
        }
        catch (KeyNotFoundException e) {
            // empty catch block
        }
        if (null != obsAssoc && Id.isValidPkId((Id)obsAssoc.getId())) {
            try {
                new ObserverAssociationUIDDAO().loadByAssociationIds(obj.getUsersId(), obj.getObserverId());
                return null;
            }
            catch (Exception e) {
                return UuidFactory.createUuid();
            }
        }
        return UuidFactory.createUuid();
    }

    private void saveObserverAssociationBatchUID(ObserverAssociation obj, String batchUID, Results results) {
        block2: {
            try {
                this.saveObserverAssociationBatchUID(obj, batchUID);
            }
            catch (Exception e) {
                if (results == null) break block2;
                results.addError((BbObject)obj, e);
            }
        }
    }

    private void saveObserverAssociationBatchUID(ObserverAssociation obj, String batchUID) throws KeyNotFoundException, PersistenceException {
        if (null != obj && StringUtil.notEmpty((String)obj.getObserverBatchUid()) && StringUtil.notEmpty((String)obj.getUsersBatchUid()) && StringUtil.notEmpty((String)batchUID)) {
            Id observerId = UserDbLoader.Default.getInstance().loadByBatchUid(obj.getObserverBatchUid()).getId();
            Id observeeId = UserDbLoader.Default.getInstance().loadByBatchUid(obj.getUsersBatchUid()).getId();
            ObserverAssociationUIDDAO uidDAO = new ObserverAssociationUIDDAO();
            uidDAO.deleteByAssociationIds(observeeId, observerId);
            ObserverAssociationUID membershipUID = new ObserverAssociationUID();
            membershipUID.setBatchUID(batchUID);
            membershipUID.setOuObserverId(observerId);
            membershipUID.setOuUserId(observeeId);
            uidDAO.persist((Identifiable)membershipUID);
        }
    }
}

