/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.user.impl;

import blackboard.admin.data.user.Person;
import blackboard.admin.persist.impl.AdminNewBaseDbLoader;
import blackboard.admin.persist.user.PersonLoader;
import blackboard.admin.persist.user.impl.AdminUserSelectQuery;
import blackboard.admin.persist.user.impl.mapping.PersonLoaderDbMap;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.user.User;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.JdbcQueryHelper;
import blackboard.persist.impl.SelectQuery;
import java.util.ArrayList;
import java.util.List;

public class PersonDbLoader
extends AdminNewBaseDbLoader<Person>
implements PersonLoader {
    private static final String TABLE_NAME = "users";

    @Override
    public Person load(String batchUid) throws KeyNotFoundException, PersistenceException {
        AdminUserSelectQuery query = new AdminUserSelectQuery(PersonLoaderDbMap.MAP, TABLE_NAME);
        query.addWhere("BatchUid", batchUid);
        return (Person)super.loadObject((SelectQuery)query, null);
    }

    @Override
    public BbList<Person> load(Person template) throws PersistenceException {
        AdminUserSelectQuery query = new AdminUserSelectQuery(PersonLoaderDbMap.MAP, TABLE_NAME);
        this.initQuery((SelectQuery)query);
        this.generateWhereClause((BbObject)template, query);
        return super.loadList((SelectQuery)query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Id> loadBySessionId(String sessionId) throws KeyNotFoundException, PersistenceException {
        assert (sessionId != null);
        String getBySessionIdSql = "select u.pk1 from users u, tmp_user_keys tuk where tuk.session_id = ? and u.row_status = 0 and u.pk1 = tuk.pk1";
        ArrayList<Id> userIds = new ArrayList<Id>();
        try (JdbcQueryHelper getBySessionIdQuery = null;){
            getBySessionIdQuery = new JdbcQueryHelper(getBySessionIdSql);
            getBySessionIdQuery.setString(1, sessionId);
            getBySessionIdQuery.executeQuery();
            while (getBySessionIdQuery.next()) {
                userIds.add(getBySessionIdQuery.getId(1, User.DATA_TYPE));
            }
        }
        return userIds;
    }
}

