/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.user.impl;

import blackboard.admin.data.user.Person;
import blackboard.admin.data.user.PersonXmlDef;
import blackboard.admin.persist.impl.AdminPersister;
import blackboard.admin.persist.user.PersonXmlPersister;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.admin.snapshot.util.TimeFormat;
import blackboard.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PersonXmlPersisterImpl
extends AdminPersister
implements PersonXmlDef,
PersonXmlPersister {
    @Override
    public Element persist(Person obj, Document doc) {
        Element rootElement = doc.createElement("person");
        this.persistSourceIdNode(obj, rootElement, doc);
        this.persistUserIdNode(obj, rootElement, doc);
        this.persistNameNode(obj, rootElement, doc);
        this.persistDemographicsNode(obj, rootElement, doc);
        this.persistEmailNode(obj, rootElement, doc);
        this.persistTelephoneNodes(obj, rootElement, doc);
        this.persistAddressNode(obj, rootElement, doc);
        this.persistSystemRoleNode(obj, rootElement, doc);
        this.persistInstitutionRoleNode(obj, rootElement, doc);
        this.persistExtensionNode(obj, rootElement, doc);
        return rootElement;
    }

    protected void persistSourceIdNode(Person obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("sourcedid");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"source", (String)"Bb Platform");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"id", (String)obj.getBatchUid());
        rootElement.appendChild(childElement);
    }

    protected void persistUserIdNode(Person obj, Element rootElement, Document doc) {
        if (obj.getBbAttributes().getBbAttribute("UserName").getValue() != null || obj.getBbAttributes().getBbAttribute("Password").getValue() != null) {
            String strValue = obj.getUserName();
            if (strValue == null) {
                strValue = "";
            }
            Element element = XmlUtil.buildChildElement((Document)doc, (Element)rootElement, (String)"userid", (String)strValue);
            strValue = obj.getPassword();
            if (strValue == null) {
                strValue = "";
            }
            if (obj.getBbAttributes().getBbAttribute("Password").getValue() != null) {
                element.setAttribute("password", strValue);
                element.setAttribute("pwencryptiontype", "md5");
            }
        }
    }

    protected void persistNameNode(Person obj, Element rootElement, Document doc) {
        Element childElement = null;
        Element depElement = null;
        childElement = doc.createElement("name");
        depElement = doc.createElement("n");
        if (obj.getBbAttributes().getBbAttribute("FamilyName").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)depElement, (String)"family", (String)obj.getFamilyName());
        }
        if (obj.getBbAttributes().getBbAttribute("GivenName").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)depElement, (String)"given", (String)obj.getGivenName());
        }
        if (obj.getBbAttributes().getBbAttribute("MiddleName").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)depElement, (String)"other", (String)obj.getMiddleName());
        }
        if (obj.getBbAttributes().getBbAttribute("Title").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)depElement, (String)"prefix", (String)obj.getTitle());
        }
        if (obj.getBbAttributes().getBbAttribute("OtherName").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)depElement, (String)"other", (String)obj.getOtherName());
        }
        if (obj.getBbAttributes().getBbAttribute("Suffix").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)depElement, (String)"suffix", (String)obj.getSuffix());
        }
        childElement.appendChild(depElement);
        rootElement.appendChild(childElement);
    }

    protected void persistDemographicsNode(Person obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("demographics");
        if (obj.getBbAttributes().getBbAttribute("Gender").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"gender", (String)String.valueOf(ConversionUtility.genderToInt(obj.getGender())));
        }
        if (obj.getBbAttributes().getBbAttribute("BirthDate").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"bday", (String)TimeFormat.calendarToString(obj.getBirthDate()));
        }
        rootElement.appendChild(childElement);
    }

    protected void persistEmailNode(Person obj, Element rootElement, Document doc) {
        if (obj.getBbAttributes().getBbAttribute("Email").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)rootElement, (String)"email", (String)obj.getEmailAddress());
        }
    }

    protected void persistSystemRoleNode(Person obj, Element rootElement, Document doc) {
        if (obj.getBbAttributes().getBbAttribute("SystemRole").getIsDirty()) {
            Element element = doc.createElement("systemrole");
            element.setAttribute("systemroletype", this._cvUtility.systemRoleToString(obj.getSystemRole()));
            rootElement.appendChild(element);
        }
    }

    protected void persistInstitutionRoleNode(Person obj, Element rootElement, Document doc) {
        if (obj.getBbAttributes().getBbAttribute("PortalRoleId").getIsDirty()) {
            Element element = doc.createElement("institutionrole");
            element.setAttribute("primaryrole", "yes");
            element.setAttribute("institutionroletype", this._cvUtility.institutionRoleToString(obj.getPortalRoleId()));
            rootElement.appendChild(element);
        }
    }

    protected void persistTelephoneNodes(Person obj, Element rootElement, Document doc) {
        if (obj.getBbAttributes().getBbAttribute("HomePhone1").getValue() != null) {
            this.persistTelephoneNode(doc, rootElement, obj.getHomePhone1(), 0);
        }
        if (obj.getBbAttributes().getBbAttribute("HomeFax").getValue() != null) {
            this.persistTelephoneNode(doc, rootElement, obj.getHomeFax(), 1);
        }
        if (obj.getBbAttributes().getBbAttribute("BusinessPhone1").getValue() != null) {
            this.persistTelephoneNode(doc, rootElement, obj.getBusinessPhone1(), 2);
        }
        if (obj.getBbAttributes().getBbAttribute("BusinessFax").getValue() != null) {
            this.persistTelephoneNode(doc, rootElement, obj.getBusinessFax(), 3);
        }
        if (obj.getBbAttributes().getBbAttribute("MobilePhone").getValue() != null) {
            this.persistTelephoneNode(doc, rootElement, obj.getMobilePhone(), 4);
        }
        if (obj.getBbAttributes().getBbAttribute("HomePhone2").getValue() != null) {
            this.persistTelephoneNode(doc, rootElement, obj.getHomePhone2(), 5);
        }
        if (obj.getBbAttributes().getBbAttribute("BusinessPhone2").getValue() != null) {
            this.persistTelephoneNode(doc, rootElement, obj.getBusinessPhone2(), 6);
        }
    }

    private void persistTelephoneNode(Document doc, Element rootElement, String value, int att) {
        if (value == null) {
            return;
        }
        Element elem = XmlUtil.buildChildElement((Document)doc, (Element)rootElement, (String)"tel", (String)value);
        elem.setAttribute("teltype", String.valueOf(att));
    }

    protected void persistAddressNode(Person obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("adr");
        if (obj.getBbAttributes().getBbAttribute("Street1").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"street", (String)obj.getStreet1());
        }
        if (obj.getBbAttributes().getBbAttribute("Street2").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"street", (String)obj.getStreet2());
        }
        if (obj.getBbAttributes().getBbAttribute("City").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"locality", (String)obj.getCity());
        }
        if (obj.getBbAttributes().getBbAttribute("State").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"region", (String)obj.getState());
        }
        if (obj.getBbAttributes().getBbAttribute("ZipCode").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"pcode", (String)obj.getZipCode());
        }
        if (obj.getBbAttributes().getBbAttribute("Country").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"country", (String)obj.getCountry());
        }
        rootElement.appendChild(childElement);
    }

    protected void persistExtensionNode(Person obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("extension");
        if (obj.getBbAttributes().getBbAttribute("ShowAddressInfo").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_address_indicator", (String)ConversionUtility.booleanToYN(obj.getShowAddressInfo()));
        }
        if (obj.getBbAttributes().getBbAttribute("IsAvailable").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_available", (String)ConversionUtility.booleanToYN(obj.getIsAvailable()));
        }
        if (obj.getBbAttributes().getBbAttribute("Company").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_company", (String)obj.getCompany());
        }
        if (obj.getBbAttributes().getBbAttribute("ShowAddContactInfo").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_contact_indicator", (String)ConversionUtility.booleanToYN(obj.getShowAddContactInfo()));
        }
        if (obj.getBbAttributes().getBbAttribute("Department").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_company_department", (String)obj.getDepartment());
        }
        if (obj.getBbAttributes().getBbAttribute("DataSourceBatchUid").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_datasource_key", (String)obj.getDataSourceBatchUid());
        }
        if (obj.getBbAttributes().getBbAttribute("EducationLevel").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_education_level", (String)this._cvUtility.educationLevelToString(obj.getEducationLevel()));
        }
        if (obj.getBbAttributes().getBbAttribute("ShowEmailInfo").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_email_indicator", (String)ConversionUtility.booleanToYN(obj.getShowEmailInfo()));
        }
        if (obj.getBbAttributes().getBbAttribute("JobTitle").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_job_title", (String)obj.getJobTitle());
        }
        if (obj.getBbAttributes().getBbAttribute("IsInfoPublic").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_public_indicator", (String)ConversionUtility.booleanToYN(obj.getIsInfoPublic()));
        }
        if (obj.getBbAttributes().getBbAttribute("ReplacementBatchUid").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_replacementkey", (String)obj.getReplacementBatchUid());
        }
        if (obj.getBbAttributes().getBbAttribute("RowStatus").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_row_status", (String)String.valueOf(ConversionUtility.rowStatusToInt(obj.getRowStatus())));
        }
        if (obj.getBbAttributes().getBbAttribute("Settings").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_settings", (String)obj.getSettings());
        }
        if (obj.getBbAttributes().getBbAttribute("StudentId").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_studentid", (String)obj.getStudentId());
        }
        if (obj.getBbAttributes().getBbAttribute("WebPage").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_webpage", (String)obj.getWebPage());
        }
        if (obj.getBbAttributes().getBbAttribute("ShowWorkInfo").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_work_indicator", (String)ConversionUtility.booleanToYN(obj.getShowWorkInfo()));
        }
        if (obj.getDataSourceId().isSet()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_data_source_id", (String)obj.getDataSourceId().toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("id").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_internal_id", (String)obj.getId().toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("Locale").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_locale", (String)obj.getLocale());
        }
        if (obj.getBbAttributes().getBbAttribute("StringPortalRole") != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_portalrole", (String)obj.getBbAttributes().getSafeString("StringPortalRole"));
        }
        if (obj.getBbAttributes().getBbAttribute("embed") != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_embedded_source", (String)obj.getBbAttributes().getSafeString("embed"));
        }
        rootElement.appendChild(childElement);
    }
}

