/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.user.impl.soap.observer;

import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.persist.impl.soap.IServerUtility;
import blackboard.admin.persist.user.ObserverAssociationLoader;
import blackboard.admin.persist.user.ObserverAssociationPersister;
import blackboard.admin.persist.user.impl.soap.observer.ClientUtility;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.authority.RuntimeAuthority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.data.BbObject;
import blackboard.data.Identifiable;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.util.ObjectSerializer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ServerUtility
implements IServerUtility {
    public static final String ID_LIST = "observerassociation.id.list";

    public static String insert(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        List<ObserverAssociation> list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> aList = new ArrayList<String>(list.size());
        ObserverAssociationPersister p = ObserverAssociationPersister.Default.getInstance();
        for (ObserverAssociation tmp : list) {
            p.insert(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String update(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        List<ObserverAssociation> list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> aList = new ArrayList<String>(list.size());
        ObserverAssociationPersister p = ObserverAssociationPersister.Default.getInstance();
        for (ObserverAssociation tmp : list) {
            p.update(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        List<ObserverAssociation> list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> aList = new ArrayList<String>(list.size());
        ObserverAssociationPersister p = ObserverAssociationPersister.Default.getInstance();
        for (ObserverAssociation tmp : list) {
            p.save(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj, String session, String strProps) throws PersistenceException {
        Properties props = (Properties)ObjectSerializer.deSerializeObject((String)strProps);
        List<ObserverAssociation> list = ServerUtility.unMarshallObjects(props, obj);
        Results results = null;
        ObserverAssociationPersister p = ObserverAssociationPersister.Default.getInstance();
        results = p.save(list, session);
        Iterator<ObserverAssociation> iter = list.iterator();
        ArrayList<String> aList = new ArrayList<String>(list.size());
        while (iter.hasNext()) {
            Identifiable tmp = (Identifiable)iter.next();
            aList.add(tmp.getId().toExternalString());
        }
        ((RemoteResults)results).setAttribute(ID_LIST, aList);
        return ObjectSerializer.serializeObject((Object)results);
    }

    public static void remove(String obj) throws PersistenceException, ValidationException {
        List<ObserverAssociation> list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return;
        }
        ObserverAssociation pObj = list.get(0);
        ObserverAssociationPersister p = ObserverAssociationPersister.Default.getInstance();
        p.remove(pObj);
    }

    public static String removeList(String obj) throws PersistenceException {
        List<ObserverAssociation> list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return null;
        }
        ObserverAssociationPersister p = ObserverAssociationPersister.Default.getInstance();
        return ObjectSerializer.serializeObject((Object)p.remove(list));
    }

    public static String createSession(String dataSourceBatchUid) throws PersistenceException {
        return ObserverAssociationPersister.Default.getInstance().createSession(dataSourceBatchUid);
    }

    public static void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        ObserverAssociationPersister.Default.getInstance().createSession(dataSourceBatchUid, sessionId);
    }

    public static void closeSession(String strSessionId) throws PersistenceException {
        ObserverAssociationPersister.Default.getInstance().closeSession(strSessionId);
    }

    public static String load(String obsBatchUid, String usrBatchUid) throws PersistenceException, KeyNotFoundException {
        ObserverAssociation obj = null;
        ObserverAssociationLoader l = ObserverAssociationLoader.Default.getInstance();
        obj = l.load(obsBatchUid, usrBatchUid);
        return ClientUtility.convertToString((BbObject)obj);
    }

    public static String loadByTemplate(String template) throws PersistenceException {
        List<ObserverAssociation> list = ServerUtility.unMarshallObjects(template);
        if (list.isEmpty()) {
            return "";
        }
        ObserverAssociation pObj = list.get(0);
        ObserverAssociationLoader cLoader = ObserverAssociationLoader.Default.getInstance();
        list = cLoader.load(pObj);
        return ClientUtility.convertToString(list);
    }

    public static List<ObserverAssociation> unMarshallObjects(String src) throws PersistenceException {
        return ServerUtility.unMarshallObjects(null, src);
    }

    public static List<ObserverAssociation> unMarshallObjects(Properties props, String src) throws PersistenceException {
        try {
            RuntimeAuthority ra = new RuntimeAuthority(props, new StringReader(src), Authority.Operation.MANUAL);
            ra.execute();
            return ra.getObjectList();
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }
}

