/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.persist.impl;

import blackboard.admin.data.course.CourseSite;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbAttribute;
import blackboard.data.BbAttributes;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.BbDatabase;
import blackboard.db.ConnectionManager;
import blackboard.db.DatabaseTransaction;
import blackboard.db.DbTypeFunctions;
import blackboard.db.DbUtil;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.StoredProcedureQuery;
import blackboard.persist.impl.mapping.BbEnumMapping;
import blackboard.persist.impl.mapping.DbObjectMap;
import blackboard.persist.impl.mapping.IDbLobMapping;
import blackboard.persist.impl.mapping.Mapping;
import blackboard.platform.intl.BundleManagerFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;

public class SnapshotProcedureQuery
extends StoredProcedureQuery {
    private static final String BATCH_UID = "BatchUid";
    private static final String REPLACEMENT_BATCH_UID = "ReplacementBatchUid";
    private DbObjectMap _dbBbObjMap = null;
    private BbObject _bbObj = null;
    private static final String SESSION = "p_session_id";
    private final String _strSessionId;

    public SnapshotProcedureQuery(DbObjectMap map, BbObject obj, String sessionId) {
        super("process_" + map.getAliasTableName() + "_integration");
        this._strSessionId = sessionId;
        List list = map.getMappingList();
        Mapping mapping2 = null;
        Mapping.Use use = null;
        String[] aColumns = null;
        for (Mapping mapping2 : list) {
            use = mapping2.getInsertUse();
            if (use == Mapping.Use.NONE) continue;
            for (String mapName : aColumns = mapping2.getColumns()) {
                if (use == Mapping.Use.INPUT) {
                    if (mapName.equals("data_src_pk1")) {
                        mapName = "p_data_src_pk1";
                    }
                    if (mapName.startsWith("p_")) {
                        this.addInputParameter(mapName);
                        continue;
                    }
                    this.addInputParameter("p_" + mapName);
                    this.addInputParameter("f_" + mapName);
                    continue;
                }
                if (use == Mapping.Use.OUTPUT) {
                    if (this.getUseResultSet()) {
                        this.addOutputParameter(mapName);
                        continue;
                    }
                    if (mapName.startsWith("p_")) {
                        this.addOutputParameter(mapName);
                        continue;
                    }
                    this.addOutputParameter("p_" + mapName);
                    continue;
                }
                throw new RuntimeException(BundleManagerFactory.getInstance().getBundle("snapshot").getString("db.mapping.invalid") + use.toString());
            }
        }
        this.addInputParameter(SESSION);
        this._dbBbObjMap = map;
        this._bbObj = obj;
    }

    public boolean getUseResultSet() {
        if (this._bUseResultSet == null) {
            DbTypeFunctions dbTypeFunctions = BbDatabase.getDefaultInstance().getType().getFunctions();
            this._bUseResultSet = dbTypeFunctions.requiresResultSetForProcedureOutput();
        }
        return this._bUseResultSet;
    }

    protected void marshallParams(CallableStatement stmt) throws SQLException, SQLException, PersistenceException {
        BbAttributes attribs = this._bbObj.getBbAttributes();
        List list = this._dbBbObjMap.getMappingList();
        Mapping mapping2 = null;
        Mapping.Use use = null;
        int nStartPos = 0;
        for (Mapping mapping2 : list) {
            use = mapping2.getInsertUse();
            boolean bClob = mapping2 instanceof IDbLobMapping;
            String mapName = mapping2.getColumns()[0];
            if (mapName.equals("data_src_pk1")) {
                mapName = "p_data_src_pk1";
            }
            nStartPos = this.getColumnPosition(mapName);
            if (use == Mapping.Use.INPUT) {
                if (mapName.startsWith("p_")) {
                    mapping2.marshall(this.getContainer(), (PreparedStatement)stmt, nStartPos, attribs.getBbAttribute(mapping2.getName()).getValue());
                    continue;
                }
                if (mapName.equals("row_status")) {
                    boolean bDirty = attribs.getBbAttribute(mapping2.getName()).getIsDirty();
                    if (bDirty) {
                        mapping2.marshall(this.getContainer(), (PreparedStatement)stmt, this.getColumnPosition("p_" + mapName), attribs.getBbAttribute(mapping2.getName()).getValue());
                    } else {
                        stmt.setNull(this.getColumnPosition("p_" + mapName), 4);
                    }
                    DbUtil.setInteger((PreparedStatement)stmt, (int)this.getColumnPosition("f_" + mapName), (int)ConversionUtility.booleanToInt(attribs.getBbAttribute(mapping2.getName()).getIsDirty()));
                    continue;
                }
                if (bClob) {
                    DbUtil.setNString((BbDatabase)this._bbDatabase, (PreparedStatement)stmt, (int)this.getColumnPosition("p_" + mapName), (String)attribs.getString(mapping2.getName()));
                } else {
                    if (mapping2 instanceof BbEnumMapping && this._bbObj instanceof CourseSite && this._strProcedureName.equals("process_course_integration")) {
                        ((BbEnumMapping)mapping2).setDefault(null);
                    }
                    mapping2.marshall(this.getContainer(), (PreparedStatement)stmt, this.getColumnPosition("p_" + mapName), attribs.getBbAttribute(mapping2.getName()).getValue());
                }
                DbUtil.setInteger((PreparedStatement)stmt, (int)this.getColumnPosition("f_" + mapName), (int)ConversionUtility.booleanToInt(attribs.getBbAttribute(mapping2.getName()).getIsDirty()));
                continue;
            }
            if (use != Mapping.Use.OUTPUT || this.getUseResultSet()) continue;
            if (mapName.startsWith("p_")) {
                mapping2.registerOutParameter(stmt, nStartPos);
                continue;
            }
            mapping2.registerOutParameter(stmt, this.getColumnPosition("p_" + mapName));
        }
        nStartPos = this.getColumnPosition(SESSION);
        DbUtil.setString((PreparedStatement)stmt, (int)nStartPos, (String)this._strSessionId);
    }

    public void processResults(CallableStatement stmt) throws SQLException, PersistenceException {
        List list = this._dbBbObjMap.getMappingList();
        Mapping mapping2 = null;
        Object obj = null;
        for (Mapping mapping2 : list) {
            String mapName = mapping2.getColumns()[0];
            if (mapping2.getInsertUse() != Mapping.Use.OUTPUT) continue;
            if (!mapName.startsWith("p_")) {
                mapName = "p_" + mapName;
            }
            obj = mapping2.unmarshall(this.getContainer(), stmt, this.getColumnPosition(mapName));
            this._dbBbObjMap.setTargetValue((Object)this._bbObj, mapping2.getName(), obj);
        }
    }

    public void processResults(ResultSet rst) throws SQLException, PersistenceException {
        List list = this._dbBbObjMap.getMappingList();
        Mapping mapping2 = null;
        Object obj = null;
        for (Mapping mapping2 : list) {
            if (mapping2.getInsertUse() != Mapping.Use.OUTPUT) continue;
            obj = mapping2.unmarshall(this.getContainer(), rst, null);
            this._dbBbObjMap.setTargetValue((Object)this._bbObj, mapping2.getName(), obj);
        }
    }

    public Results executeBatchQuery(final List<?> list) throws PersistenceException {
        final RemoteResults myResults = new RemoteResults(list.size());
        try {
            ConnectionManager connMgr = ConnectionManager.getDefaultInstance();
            connMgr.performTransaction(new DatabaseTransaction("SnapshotProcedureQuery.executeBatchQuery"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(final Connection con) throws PersistenceException, ValidationException {
                    try {
                        try {
                            SnapshotProcedureQuery.this._stmt = SnapshotProcedureQuery.this.prepareStatement(con);
                        }
                        catch (SQLException e) {
                            throw new PersistenceException((Throwable)e);
                        }
                        Iterator iter = list.iterator();
                        while (iter.hasNext()) {
                            SnapshotProcedureQuery.this._bbObj = (BbObject)iter.next();
                            try {
                                SnapshotProcedureQuery.this._bbObj.validate();
                                DbUtil.callWithSavepointRollback((Callable)new Callable<Void>(){

                                    @Override
                                    public Void call() throws Exception {
                                        SnapshotProcedureQuery.this.doExecute(con);
                                        return null;
                                    }
                                }, (Connection)con);
                                SnapshotProcedureQuery.this.resolveReplacementBatchUid(SnapshotProcedureQuery.this._bbObj);
                            }
                            catch (Exception exc) {
                                myResults.addError(SnapshotProcedureQuery.this._bbObj, (Exception)((Object)new PersistenceException((Throwable)exc)));
                            }
                        }
                    }
                    finally {
                        SnapshotProcedureQuery.this.close();
                    }
                }
            });
        }
        catch (ValidationException e) {
            throw new PersistenceException((Throwable)e);
        }
        return myResults;
    }

    private void resolveReplacementBatchUid(BbObject obj) {
        BbAttribute att = obj.getBbAttributes().getBbAttribute(REPLACEMENT_BATCH_UID);
        if (att == null) {
            return;
        }
        if (!att.getIsDirty()) {
            return;
        }
        obj.getBbAttributes().setString(BATCH_UID, (String)att.getValue());
    }
}

