/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.snapshot.SnapshotException;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.config.MsgConstants;
import blackboard.admin.snapshot.serialize.IParser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.platform.LicenseComponent;
import blackboard.platform.LicenseManagerFactory;
import blackboard.platform.StatusCode;
import blackboard.util.TextFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class Parser
implements IParser {
    public static final String PARSER_CLEAR_VALUE = "{CLEAR_VALUE}";
    protected final Map<String, String> _fieldMapping = new HashMap<String, String>();
    protected Authority _authority;
    protected LinkedList<String> _posMapping;
    protected LinkedList<String> _legacyPosMapping;
    protected BitSet _overrides;
    protected ConversionUtility _conversionUtil;
    protected Reader _reader;
    private int _batchSize = 0;

    protected Parser() {
    }

    @Override
    public Authority getAuthority() {
        return this._authority;
    }

    @Override
    public void init(Authority authority, Reader reader) {
        this._authority = authority;
        this._reader = new BufferedReader(reader);
        this._conversionUtil = new ConversionUtility(this._authority.getConfigurationManager());
    }

    @Override
    public void checkApiLicensing() {
        if (!this._authority.checkLicense()) {
            return;
        }
        if (this._authority.getOperation() == Authority.Operation.CLONE) {
            return;
        }
        LicenseManagerFactory.getInstance().runtimeAssertIsLicensed(LicenseComponent.INTEGRATION_APIS);
    }

    @Override
    public void execute() throws SnapshotException {
        this.checkApiLicensing();
        try {
            this.parameterMappingInitialization();
            this.controlMaskInitialization();
        }
        catch (Exception e) {
            throw new SnapshotException(this._authority.getConfigurationManager().getMessage("parser.init.failure", new String[0]), e);
        }
        try {
            String line;
            int maxBatchSize = this._authority.getConfigurationManager().getNumericSetting("snapshot.batch.size");
            int waitLength = this._authority.getConfigurationManager().getNumericSetting("wait.length");
            LineNumberReader reader = new LineNumberReader(this._reader);
            boolean foundHeader = false;
            while (null != (line = reader.readLine()) && this._authority.getStatus() != StatusCode.ABORTING) {
                if (line.length() == 0) continue;
                if (LineType.Footer == LineType.determineLineType(line)) {
                    break;
                }
                try {
                    if (!foundHeader) {
                        this._authority.getLogger().writeToErrorStream(line + MsgConstants.MSG_CRLF);
                        if (!this.validateHeaderForRequiredFields(line.toLowerCase())) {
                            String msg = this._authority.getConfigurationManager().getMessage("parser.header.required", new String[0]);
                            throw new SnapshotException(msg);
                        }
                        this.reviewDynamicHeader(line);
                        foundHeader = true;
                        continue;
                    }
                    this._authority.getLogger().stdOutLogCount(false);
                    IAdminObject obj = this.unmarshallObject(line);
                    ((BbObject)obj).getBbAttributes().setString("embed", line);
                    this.queue(obj);
                    ++this._batchSize;
                    if (this._batchSize > maxBatchSize) {
                        this._authority.commit();
                        this._batchSize = 0;
                    }
                }
                catch (ValidationException e) {
                    this._authority.getLogger().logError(line, (Exception)((Object)e));
                }
                catch (IllegalArgumentException e) {
                    this._authority.getLogger().logError(line, e);
                }
                if (waitLength <= 0) continue;
                Thread.yield();
                try {
                    Thread.sleep(waitLength * 1000);
                }
                catch (InterruptedException ie) {}
            }
        }
        catch (IOException e) {
            throw new SnapshotException(this._authority.getConfigurationManager().getMessage("stream.err.io", new String[0]), e);
        }
        finally {
            try {
                this._authority.commit();
            }
            catch (SnapshotException e) {
                String msg = this._authority.getConfigurationManager().getMessage("db.general.failure", new String[0]);
                this._authority.getLogger().logError(msg, (Exception)((Object)e));
            }
            this._authority.getLogger().stdOutLogCount(true);
        }
    }

    public LinkedList<String> getLegacyPositionMapping() {
        return this._legacyPosMapping;
    }

    public LinkedList<String> getPositionMapping() {
        return this._posMapping;
    }

    public IAdminObject unmarshallObject(String line) throws ValidationException {
        IAdminObject obj = this.getObjectInstance();
        if (null != this._authority.getDataSource()) {
            obj.getBbAttributes().setId("DataSourceId", this._authority.getDataSource().getId());
        }
        String delimiter = String.valueOf(this._authority.getConfigurationManager().getDelimiter());
        String escape = this._authority.getConfigurationManager().getEscapeSequence();
        String errorDelimiter = this._authority.getConfigurationManager().getSetting("error.delimeter");
        int relativePos = 0;
        boolean attributeToggle = false;
        boolean escapeToggle = false;
        String tmp = "";
        StringTokenizer tkn = new StringTokenizer(line, delimiter, true);
        while (tkn.hasMoreElements()) {
            int absolutePos;
            String buffer = (String)tkn.nextElement();
            if (escapeToggle) {
                escapeToggle = false;
                tmp = tmp + buffer;
            } else {
                tmp = buffer;
            }
            if (tmp.endsWith(escape)) {
                tmp = tmp.substring(0, tmp.length() - 1) + delimiter;
                escapeToggle = true;
                if (tkn.hasMoreElements()) {
                    tkn.nextElement();
                    continue;
                }
            } else if (tmp.equals(delimiter)) {
                if (!attributeToggle) {
                    ++relativePos;
                }
                attributeToggle = false;
                continue;
            }
            if (tmp.indexOf(errorDelimiter) == 0) continue;
            HashMap<String, String> nonBlankPositions = new HashMap<String, String>();
            attributeToggle = true;
            String mapKey = "";
            try {
                absolutePos = this._legacyPosMapping.indexOf(this._fieldMapping.get(String.valueOf(relativePos)));
                mapKey = this._legacyPosMapping.get(absolutePos);
                nonBlankPositions.put(mapKey, String.valueOf(absolutePos));
            }
            catch (Exception e) {
                absolutePos = -1;
            }
            if (absolutePos == -1) {
                try {
                    absolutePos = this._posMapping.indexOf(this._fieldMapping.get(String.valueOf(relativePos)));
                    mapKey = this._posMapping.get(absolutePos);
                    nonBlankPositions.put(mapKey, String.valueOf(absolutePos));
                }
                catch (Exception e) {
                    absolutePos = -1;
                }
            }
            if (tmp.length() > 0) {
                boolean isNotDirty = !(absolutePos >= 0 && !this.getOverrideMask().get(absolutePos) || this._authority.getOperation() == Authority.Operation.CLONE && mapKey.indexOf("template") > -1);
                this.handleAttributeMapping(obj, absolutePos, tmp, !isNotDirty);
            }
            ++relativePos;
        }
        return obj;
    }

    public String getSetting(int pos) {
        String[] dataColumnList = this.getBbListing();
        if (pos < 0 || pos > dataColumnList.length) {
            return null;
        }
        return dataColumnList[pos];
    }

    @Override
    public BitSet getOverrideMask() {
        return this._overrides;
    }

    @Override
    public void queue(IAdminObject adminObject) {
        this._authority.queue(adminObject);
    }

    protected boolean isTagEmpty(String tag) {
        return null == tag || tag.length() == 0;
    }

    protected String formatString(boolean isDirty, String str, int len) {
        String ret = TextFormat.trimString((String)str, (int)len);
        if (isDirty && ret.length() < 1 && str.length() > 0) {
            return PARSER_CLEAR_VALUE;
        }
        return ret;
    }

    protected abstract IAdminObject getObjectInstance();

    protected abstract void handleAttributeMapping(IAdminObject var1, int var2, String var3, boolean var4) throws ValidationException;

    protected abstract boolean validateHeaderForRequiredFields(String var1);

    protected abstract String[] getBbListing();

    protected abstract boolean validateHeaderLabel(String var1);

    protected abstract void parameterMappingInitialization() throws SnapshotException;

    protected abstract void controlMaskInitialization() throws SnapshotException;

    private void reviewDynamicHeader(String line) {
        ValidationException ve = new ValidationException();
        String msg = this._authority.getConfigurationManager().getSetting("data.delimeter");
        StringTokenizer tkn = new StringTokenizer(line, String.valueOf(msg), false);
        int pos = 0;
        while (tkn.hasMoreElements()) {
            String field = ((String)tkn.nextElement()).toLowerCase().trim();
            this._fieldMapping.put(String.valueOf(pos), field);
            if (this._authority.getConfigurationManager().getSetting("header.validation").equalsIgnoreCase("y") && !this.validateHeaderLabel(field)) {
                ve.addWarning(field, this._authority.getConfigurationManager().getMessage("parser.header.label", new String[0]));
            }
            ++pos;
        }
        if (ve.getWarnings().size() > 0) {
            this._authority.getLogger().logWarning(ve.getLocalizedMessage(), (Exception)((Object)ve));
        }
    }

    private static enum LineType {
        Header,
        Footer,
        Normal;


        public static LineType determineLineType(String line) {
            if (line.contains("***FileHeader")) {
                return Header;
            }
            if (line.contains("***FileFooter")) {
                return Footer;
            }
            return Normal;
        }
    }
}

