/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.snapshot.SnapshotException;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.authority.XmlAuthority;
import blackboard.admin.snapshot.serialize.IParser;
import blackboard.admin.snapshot.serialize.IXmlHandler;
import blackboard.admin.snapshot.serialize.XmlHandler;
import blackboard.admin.snapshot.serialize.category.CategoryMembershipXmlHandler;
import blackboard.admin.snapshot.serialize.category.CategoryXmlHandler;
import blackboard.admin.snapshot.serialize.course.CourseXmlHandler;
import blackboard.admin.snapshot.serialize.course.MembershipXmlHandler;
import blackboard.admin.snapshot.serialize.properties.PropertiesXmlHandler;
import blackboard.admin.snapshot.serialize.role.PortalRoleMembershipXmlHandler;
import blackboard.admin.snapshot.serialize.user.ObserverAssociationXmlHandler;
import blackboard.admin.snapshot.serialize.user.PersonXmlHandler;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.platform.LicenseComponent;
import blackboard.platform.LicenseManagerFactory;
import blackboard.platform.StatusCode;
import com.sun.org.apache.xerces.internal.parsers.SAXParser;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
extends DefaultHandler
implements IParser {
    private Authority _authority;
    private Reader _reader;
    protected BitSet _overrideMask;
    protected Map<String, IXmlHandler> _handlers;
    protected IXmlHandler _activeHandler;
    private int _batchSize = 0;
    private int _maxBatchSize = -1;
    private int _waitLength = -1;
    private StringBuffer _buf = new StringBuffer();
    private StringBuffer _activeMembershipXml = new StringBuffer();
    private String _activeMembershipType;
    protected ConversionUtility _conversionUtil;

    public XmlParser() {
        this._handlers = new Hashtable<String, IXmlHandler>();
    }

    @Override
    public Authority getAuthority() {
        return this._authority;
    }

    private final void setDefaultHandlers(Map<String, IXmlHandler> handlers, Authority authority) {
        XmlHandler handler = null;
        handler = new PropertiesXmlHandler();
        handler.init(authority);
        handlers.put("properties", handler);
        handler = new PersonXmlHandler();
        handler.init(authority);
        handlers.put("person", handler);
        handler = new CourseXmlHandler(this);
        handler.init(authority);
        handlers.put("group", handler);
        handler = new MembershipXmlHandler();
        handler.init(authority);
        handlers.put("membership", handler);
        handler = new CategoryXmlHandler();
        handler.init(authority);
        handlers.put("category", handler);
        handler = new CategoryMembershipXmlHandler();
        handler.init(authority);
        handlers.put("category_membership", handler);
        handlers.put("category_member", handler);
        handler = new PortalRoleMembershipXmlHandler();
        handler.init(authority);
        handlers.put("portal_role_membership", handler);
        handler = new ObserverAssociationXmlHandler();
        handler.init(authority);
        handlers.put("observer_membership", handler);
        handlers.put("observer_user", handler);
    }

    public IXmlHandler getActiveHandler(String handlerName) {
        if (handlerName != null && this._handlers.containsKey(handlerName)) {
            try {
                this._activeHandler = this._handlers.get(handlerName);
            }
            catch (ClassCastException e) {
                this._activeHandler = null;
            }
        }
        return this._activeHandler;
    }

    @Override
    public void init(Authority authority, Reader reader) {
        this._authority = authority;
        this._reader = new BufferedReader(reader);
        this._conversionUtil = new ConversionUtility(this._authority.getConfigurationManager());
        this.setDefaultHandlers(this._handlers, authority);
        try {
            if (this._authority instanceof XmlAuthority) {
                ((XmlAuthority)((Object)this._authority)).setCustomHandlers(this._handlers);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not update custom handlers.", e);
        }
        this._maxBatchSize = this._authority.getConfigurationManager().getNumericSetting("snapshot.batch.size");
        this._waitLength = this._authority.getConfigurationManager().getNumericSetting("wait.length");
    }

    @Override
    public void checkApiLicensing() {
        LicenseManagerFactory.getInstance().runtimeAssertIsLicensed(LicenseComponent.INTEGRATION_APIS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"XFB_XML_FACTORY_BYPASS"}, justification="There is not Factory class on this one")
    public void execute() throws SnapshotException {
        this.checkApiLicensing();
        InputSource input = new InputSource(this._reader);
        this._authority.getLogger().writeToErrorStream("<enterprise>");
        SAXParser parser = new SAXParser();
        try {
            parser.setContentHandler(this);
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.parse(input);
        }
        catch (SAXException e) {
            this._buf.append("</enterprise>");
            String msg = this._authority.getConfigurationManager().getMessage("parser.general.failure", new String[0]);
            throw new SnapshotException(msg, e);
        }
        catch (IOException e) {
            this._buf.append("</enterprise>");
            String msg = this._authority.getConfigurationManager().getMessage("stream.err.io", new String[0]);
            throw new SnapshotException(msg, e);
        }
        catch (Exception e) {
            this._buf.append("</enterprise>");
            if (this._authority.getStatus() != StatusCode.ABORTING) {
                throw new SnapshotException(e.getLocalizedMessage(), e);
            }
        }
        finally {
            try {
                this._authority.commit();
            }
            catch (SnapshotException e) {
                String msg = this._authority.getConfigurationManager().getMessage("db.general.failure", new String[0]);
                this._authority.getLogger().logError(msg, (Exception)((Object)e));
            }
            this._authority.getLogger().stdOutLogCount(true);
            this._authority.getLogger().writeToErrorStream(this._buf.toString());
        }
    }

    @Override
    public BitSet getOverrideMask() {
        return this._overrideMask;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this._authority.getLogger().logWarning(e.getMessage(), e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        try {
            this._authority.getLogger().logError(e.getMessage(), e);
        }
        catch (SnapshotException snapshotException) {
            // empty catch block
        }
    }

    private void checkForCommit(String name) {
        if (this._handlers.containsKey(name) && this._handlers.get(name) != this.getActiveHandler(null)) {
            this.delegateCommit();
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) {
        name = name.toLowerCase();
        this.checkForCommit(name);
        IXmlHandler handler = this.getActiveHandler(name);
        if (handler == null) {
            return;
        }
        if (name.equals("membership") || name.equals("category_membership")) {
            this._activeMembershipXml = new StringBuffer();
            this._activeMembershipType = name;
            this._startElementBuffer(name, atts, this._activeMembershipXml);
        } else if (name.equals("member") || name.equals("category_member")) {
            this._activeMembershipXml.append(this._buf.toString().trim());
            this._buf = new StringBuffer();
            this._buf.append(this._activeMembershipXml.toString());
            this._startElement(name, atts);
        } else {
            this._startElement(name, atts);
        }
        handler.startElement(uri, localName, name, atts);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (length == 0 || new String(ch, start, length).trim().length() == 0) {
            return;
        }
        IXmlHandler handler = this.getActiveHandler(null);
        if (handler == null) {
            return;
        }
        this._characters(ch, start, length);
        handler.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String local, String name) {
        IXmlHandler handler = this.getActiveHandler(name = name.toLowerCase());
        if (handler == null) {
            return;
        }
        if (name.equals("member") || name.equals("category_member")) {
            this._endElement(name);
            this._endElement(this._activeMembershipType);
        } else if (name.equals("membership") || name.equals("category_membership")) {
            this.delegateCommit();
        } else {
            this._endElement(name);
        }
        this.queue(handler.endElement(uri, local, name));
    }

    @Override
    public void queue(IAdminObject object) {
        if (this._authority.getStatus() == StatusCode.ABORTING) {
            throw new RuntimeException("Parser is already aborting");
        }
        if (object == null) {
            return;
        }
        this.getActiveHandler(null).release();
        if (this._authority.getDataSource() != null) {
            object.getBbAttributes().setId("DataSourceId", this._authority.getDataSource().getId());
        }
        if (object.getBbAttributes().getBbAttribute("embed") == null) {
            object.getBbAttributes().setString("embed", this._buf.toString());
        }
        this._buf = new StringBuffer();
        this._authority.getLogger().stdOutLogCount(false);
        this._authority.queue(object);
        ++this._batchSize;
        if (this._batchSize > this._maxBatchSize) {
            this.delegateCommit();
        }
        if (this._waitLength > 0) {
            Thread.yield();
            try {
                Thread.sleep(this._waitLength * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void delegateCommit() {
        try {
            this._authority.commit();
        }
        catch (SnapshotException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        this._batchSize = 0;
    }

    private void _startElement(String name, Attributes attrs) {
        this._startElementBuffer(name, attrs, this._buf);
    }

    private void _startElementBuffer(String name, Attributes attrs, StringBuffer sb) {
        sb.append("<");
        sb.append(name);
        if (attrs != null) {
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                sb.append(" ");
                sb.append(attrs.getLocalName(i));
                sb.append("=\"");
                sb.append(this._normalize(attrs.getValue(i)));
                sb.append("\"");
            }
        }
        sb.append(">");
    }

    private void _endElement(String name) {
        this._endElementBuffer(name, this._buf);
    }

    private void _endElementBuffer(String name, StringBuffer sb) {
        sb.append("</");
        sb.append(name);
        sb.append(">");
    }

    private void _characters(char[] ch, int start, int length) {
        this._buf.append(this._normalize(new String(ch, start, length)));
    }

    private String _normalize(String text) {
        StringBuilder str = new StringBuilder();
        int len = text != null ? text.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    str.append("&#");
                    str.append(Integer.toString(ch));
                    str.append(";");
                    continue block7;
                }
                default: {
                    str.append(String.valueOf(ch));
                }
            }
        }
        return str.toString();
    }
}

