/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.category;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CategoryMembershipXmlDef;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.data.category.CourseCategoryMembership;
import blackboard.admin.data.category.OrganizationCategory;
import blackboard.admin.data.category.OrganizationCategoryMembership;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.Organization;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.serialize.XmlHandler;
import blackboard.admin.snapshot.serialize.category.CategoryMembershipDelimitedParser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.base.BbEnum;
import blackboard.data.BbAttributes;
import blackboard.data.BbObject;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import blackboard.xml.XmlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class CategoryMembershipXmlHandler
extends XmlHandler
implements CategoryMembershipXmlDef {
    public static final String XML_REGISTRY_1 = "category_membership";
    public static final String XML_REGISTRY_2 = "category_member";
    static final String CONTROLLED_SETTINGS = "categorymembership.bb.controlled.fields";
    private BbObject _obj;
    private final Map<String, String> _ovrMap = new HashMap<String, String>();
    private String _activeElement;
    private String _activeEntityElement;
    private BbAttributes _bbAttribs;
    private String _groupBatchUid;
    private int _type = 0;

    @Override
    public void init(Authority authority) {
        super.init(authority);
        String tmp = authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (StringUtil.isEmpty((String)tmp)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            this._ovrMap.put(txt.toLowerCase(), "ignore");
        }
        this.initDelimitedXmlMapping();
    }

    private void initDelimitedXmlMapping() {
        this.handleDelimitedArrayXmlMapping(CategoryMembershipDelimitedParser._bbCrsDataColumnList);
        this.handleDelimitedArrayXmlMapping(CategoryMembershipDelimitedParser._bbOrgDataColumnList);
        this.handleDelimitedArrayXmlMapping(CategoryMembershipDelimitedParser._crsRequiredFieldList);
        this.handleDelimitedArrayXmlMapping(CategoryMembershipDelimitedParser._orgRequiredFieldList);
    }

    private void handleDelimitedArrayXmlMapping(String[] elementList) {
        block6: for (int cnt = 0; cnt < elementList.length; ++cnt) {
            String value = elementList[cnt];
            if (value == null || value.length() == 0 || !this._ovrMap.containsKey(value.toLowerCase())) continue;
            switch (cnt) {
                case 1: {
                    this._ovrMap.put("id", "ignore");
                    continue block6;
                }
                case 2: {
                    this._ovrMap.put("x_bb_row_status", "ignore");
                    continue block6;
                }
                case 3: {
                    this._ovrMap.put("x_bb_available_indicator", "ignore");
                    continue block6;
                }
                case 4: {
                    this._ovrMap.put("x_bb_datasource_key", "ignore");
                }
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) {
        if (name.equalsIgnoreCase(XML_REGISTRY_1)) {
            this._activeEntityElement = name;
            this._type = XmlUtil.parseInteger((String)atts.getValue(0));
            return;
        }
        if (name.equalsIgnoreCase(XML_REGISTRY_2)) {
            this._obj = this._type == 1 ? new OrganizationCategoryMembership() : new CourseCategoryMembership();
            this._bbAttribs = this._obj.getBbAttributes();
            this._activeEntityElement = name;
            this._bbAttribs.setString("GroupBatchUid", this._groupBatchUid);
            if (this._groupBatchUid != null) {
                this._bbAttribs.getBbAttribute("GroupBatchUid").setIsDirty(true);
            }
            String recStatus = XmlUtil.getAttributeValue((Attributes)atts, (String)"recstatus", (String)"4");
            this._obj.getBbAttributes().setBbEnum("RecStatus", IAdminObject.RecStatus.fromFieldName((String)recStatus, IAdminObject.RecStatus.class));
            return;
        }
        this._activeElement = name.toLowerCase();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        boolean bDirtyFlag;
        if (this._activeElement == null) {
            return;
        }
        String value = super.updateCharacterBuffer(ch, start, length).trim();
        boolean bl = bDirtyFlag = !this._ovrMap.containsKey(this._activeElement);
        if (this._activeEntityElement.equalsIgnoreCase(XML_REGISTRY_1)) {
            this.unMarshallMembershipSourceIdNode(value, bDirtyFlag);
            return;
        }
        if (this.unMarshallMemberSourceIdNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallExtensionNode(value, bDirtyFlag)) {
            return;
        }
    }

    @Override
    public IAdminObject endElement(String uri, String local, String name) {
        super.endElement(uri, local, name);
        if (name.equalsIgnoreCase(XML_REGISTRY_2)) {
            return (IAdminObject)this._obj;
        }
        return null;
    }

    @Override
    public void release() {
        this._obj = null;
    }

    protected boolean unMarshallMembershipSourceIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("id")) {
            this._groupBatchUid = value;
            return true;
        }
        return false;
    }

    protected boolean unMarshallMemberSourceIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("id")) {
            this._obj.getBbAttributes().setString("CategoryBatchUid", value);
            this._bbAttribs.getBbAttribute("CategoryBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    protected boolean unMarshallExtensionNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("x_bb_row_status")) {
            this._obj.getBbAttributes().setBbEnum("RowStatus", (BbEnum)this._cvUtility.intToRowStatus(XmlUtil.parseInteger((String)value)));
            this._bbAttribs.getBbAttribute("RowStatus").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_available_indicator")) {
            this._obj.getBbAttributes().setBoolean("IsAvailable", ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("IsAvailable").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_datasource_key")) {
            this._obj.getBbAttributes().setString("DataSourceBatchUid", value);
            this._bbAttribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_embedded_source")) {
            this._obj.getBbAttributes().setString("embed", value);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_data_source_id")) {
            try {
                this._bbAttribs.setId("DataSourceId", Id.generateId((DataType)DataSource.DATA_TYPE, (String)value));
            }
            catch (Exception exc) {
                this._bbAttribs.setId("DataSourceId", Id.UNSET_ID);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_internal_id")) {
            try {
                this._obj.setId(Id.generateId((DataType)DataSource.DATA_TYPE, (String)value));
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Unable to generate DataSource id. value is " + value, (Throwable)exc);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_group_id")) {
            DataType dType = null;
            dType = this._obj instanceof OrganizationCategoryMembership ? Organization.DATA_TYPE : CourseSite.DATA_TYPE;
            try {
                this._obj.getBbAttributes().setId("CourseId", Id.generateId((DataType)dType, (String)value));
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Unable to generate Category Membership course id. value is " + value, (Throwable)exc);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_category_id")) {
            DataType dType = null;
            dType = this._obj instanceof OrganizationCategoryMembership ? OrganizationCategory.DATA_TYPE : CourseCategory.DATA_TYPE;
            try {
                this._obj.getBbAttributes().setId("CategoryId", Id.generateId((DataType)dType, (String)value));
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Unable to generate Category Membership category id. value is " + value, (Throwable)exc);
            }
            return true;
        }
        return false;
    }
}

