/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.category;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.AdminCategory;
import blackboard.admin.data.category.CategoryXmlDef;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.data.category.OrganizationCategory;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.serialize.XmlHandler;
import blackboard.admin.snapshot.serialize.category.CategoryDelimitedParser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbAttributes;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import blackboard.xml.XmlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class CategoryXmlHandler
extends XmlHandler
implements CategoryXmlDef {
    public static final String XML_REGISTRY = "category";
    static final String CONTROLLED_SETTINGS = "category.bb.controlled.fields";
    private AdminCategory _obj;
    private final Map<String, String> _ovrMap = new HashMap<String, String>();
    private String _activeElement;
    private BbAttributes _bbAttribs;
    private int _type = 0;

    @Override
    public void init(Authority authority) {
        super.init(authority);
        String tmp = authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (StringUtil.isEmpty((String)tmp)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            this._ovrMap.put(txt.toLowerCase(), "ignore");
        }
        this.initDelimitedXmlMapping();
    }

    private void initDelimitedXmlMapping() {
        this.handleDelimitedArrayXmlMapping(CategoryDelimitedParser._dataColumnList);
    }

    private void handleDelimitedArrayXmlMapping(String[] elementList) {
        block10: for (int cnt = 0; cnt < elementList.length; ++cnt) {
            String value = elementList[cnt];
            if (value == null || value.length() == 0 || !this._ovrMap.containsKey(value.toLowerCase())) continue;
            switch (cnt) {
                case 0: {
                    this._ovrMap.put("id", "ignore");
                    continue block10;
                }
                case 1: {
                    this._ovrMap.put("x_bb_row_status", "ignore");
                    continue block10;
                }
                case 2: {
                    this._ovrMap.put("x_bb_available_indicator", "ignore");
                    continue block10;
                }
                case 3: {
                    this._ovrMap.put("x_bb_title", "ignore");
                    continue block10;
                }
                case 4: {
                    this._ovrMap.put("x_bb_frontpage_indicator", "ignore");
                    continue block10;
                }
                case 7: {
                    this._ovrMap.put("x_bb_replacementkey", "ignore");
                    continue block10;
                }
                case 6: {
                    this._ovrMap.put("x_bb_parent_key", "ignore");
                    continue block10;
                }
                case 5: {
                    this._ovrMap.put("x_bb_datasource_key", "ignore");
                }
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) {
        if (name.equalsIgnoreCase(XML_REGISTRY)) {
            this._type = XmlUtil.parseInteger((String)atts.getValue(0));
            this._obj = this._type == 1 ? new OrganizationCategory() : new CourseCategory();
            this._bbAttribs = this._obj.getBbAttributes();
            String recStatus = XmlUtil.getAttributeValue((Attributes)atts, (String)"recstatus", (String)"4");
            this._obj.setRecStatus((IAdminObject.RecStatus)IAdminObject.RecStatus.fromFieldName((String)recStatus, IAdminObject.RecStatus.class));
            return;
        }
        this._activeElement = name.toLowerCase();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        boolean bDirtyFlag;
        if (this._activeElement == null) {
            return;
        }
        String value = super.updateCharacterBuffer(ch, start, length).trim();
        boolean bl = bDirtyFlag = !this._ovrMap.containsKey(this._activeElement);
        if (this.unMarshallSourceIdNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallExtensionNode(value, bDirtyFlag)) {
            return;
        }
    }

    @Override
    public IAdminObject endElement(String uri, String local, String name) {
        super.endElement(uri, local, name);
        if (name.equalsIgnoreCase(XML_REGISTRY)) {
            return this._obj;
        }
        return null;
    }

    @Override
    public void release() {
        this._obj = null;
    }

    protected boolean unMarshallSourceIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("id")) {
            this._obj.setBatchUid(value);
            this._bbAttribs.getBbAttribute("BatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    protected boolean unMarshallExtensionNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("x_bb_row_status")) {
            this._obj.setRowStatus(this._cvUtility.intToRowStatus(XmlUtil.parseInteger((String)value)));
            this._bbAttribs.getBbAttribute("RowStatus").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_frontpage_indicator")) {
            this._obj.setFrontPageInd(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("FrontPageInd").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_available_indicator")) {
            this._obj.setIsAvailable(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("IsAvailable").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_restrict_indicator")) {
            this._obj.setIsRestricted(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("IsRestricted").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_parent_key")) {
            this._obj.setParentBatchUid(value);
            this._bbAttribs.getBbAttribute("ParentBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_replacementkey")) {
            this._obj.setReplacementBatchUid(value);
            this._bbAttribs.getBbAttribute("ReplacementBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_title")) {
            this._obj.setTitle(value);
            this._bbAttribs.getBbAttribute("Title").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_description")) {
            this._obj.setDescription(value);
            this._bbAttribs.getBbAttribute("Description").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_datasource_key")) {
            this._obj.setDataSourceBatchUid(value);
            this._bbAttribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_embedded_source")) {
            this._obj.getBbAttributes().setString("embed", value);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_data_source_id")) {
            try {
                this._bbAttribs.setId("DataSourceId", Id.generateId((DataType)DataSource.DATA_TYPE, (String)value));
            }
            catch (Exception exc) {
                this._bbAttribs.setId("DataSourceId", Id.UNSET_ID);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_internal_id")) {
            try {
                this._obj.setId(Id.generateId((DataType)this._obj.getDataType(), (String)value));
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Unable to generate id for specified data type. value is " + value, (Throwable)exc);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_internal_parent_id")) {
            try {
                this._obj.setParentId(Id.generateId((DataType)this._obj.getDataType(), (String)value));
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Unable to generate parent id for specified data type. value is " + value, (Throwable)exc);
            }
            return true;
        }
        return false;
    }
}

