/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.course;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.snapshot.config.OverriddenSetting;
import blackboard.admin.snapshot.config.OverriddenSnapshotSettingsHelper;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.data.course.Course;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import blackboard.util.TextFormat;
import blackboard.xml.XmlUtil;
import java.util.BitSet;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class CourseDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "group.bb.controlled.fields";
    static String[] _eeDataColumnList = new String[]{"abbreviated_title", "course_section_key", "title", "course_description", "start_date", "end_date", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "new_course_section_key", "template_key", "", "", "", "excludediscussionstarterposts"};
    static String[] _bbCrsDataColumnList = new String[]{"course_id", "external_course_key", "course_name", "description", "start_date", "end_date", "classification_key", "new_data_source_key", "row_status", "enroll_option", "available_ind", "catalog_ind", "desc_page", "duration", "lockout_ind", "pace", "service_level", "abs_limit", "soft_limit", "upload_limit", "enroll_start", "enroll_end", "days_of_use", "institution_name", "fee", "allow_guest_ind", "enroll_access_code", "new_external_course_key", "template_course_key", "allow_observer_ind", "locale", "locale_enforced", "discussion.board.topics.exclude"};
    static String[] _bbOrgDataColumnList = new String[]{"organization_id", "external_organization_key", "organization_name", "description", "start_date", "end_date", "classification_key", "new_data_source_key", "row_status", "enroll_option", "available_ind", "catalog_ind", "desc_page", "duration", "lockout_ind", "pace", "service_level", "abs_limit", "soft_limit", "upload_limit", "enroll_start", "enroll_end", "days_of_use", "institution_name", "fee", "allow_guest_ind", "enroll_access_code", "new_external_organization_key", "template_organization_key", "allow_observer_ind", "locale", "locale_enforced", "discussion.board.topics.exclude", "discussion.board.topics.exclude"};
    static String[] _crsRequiredFieldList = new String[]{"external_course_key", "course_section_key"};
    static String[] _orgRequiredFieldList = new String[]{"external_organization_key", "course_section_key"};

    @Override
    protected boolean validateHeaderLabel(String line) {
        String[] list;
        boolean bStatus = false;
        for (String element : _eeDataColumnList) {
            if (!element.equals(line)) continue;
            bStatus = true;
            break;
        }
        if (bStatus) {
            return bStatus;
        }
        for (String element : list = this.getBbListing()) {
            if (!element.equals(line)) continue;
            bStatus = true;
            break;
        }
        return bStatus;
    }

    @Override
    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) throws ValidationException {
        AdminCourse objToReturn = (AdminCourse)obj;
        BbAttributes attribs = objToReturn.getBbAttributes();
        switch (absolutePos) {
            case 0: {
                objToReturn.setCourseId(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("CourseId").setIsDirty(bFlagNotDirty);
                break;
            }
            case 1: {
                objToReturn.setBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                break;
            }
            case 2: {
                objToReturn.setTitle(this.formatString(bFlagNotDirty, tmp, 255));
                attribs.getBbAttribute("Title").setIsDirty(bFlagNotDirty);
                break;
            }
            case 3: {
                objToReturn.setDescription(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("Description").setIsDirty(bFlagNotDirty);
                break;
            }
            case 4: {
                objToReturn.setStartDate(this._conversionUtil.stringToCalendar(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("StartDate").setIsDirty(bFlagNotDirty);
                objToReturn.setDurationType(Course.Duration.DATE_RANGE);
                attribs.getBbAttribute("DurationType").setIsDirty(bFlagNotDirty);
                break;
            }
            case 5: {
                Calendar endDate = this._conversionUtil.stringToCalendar(TextFormat.trimString((String)tmp, (int)-1));
                endDate.set(11, 23);
                endDate.set(12, 59);
                endDate.set(13, 59);
                objToReturn.setEndDate(endDate);
                attribs.getBbAttribute("EndDate").setIsDirty(bFlagNotDirty);
                objToReturn.setDurationType(Course.Duration.DATE_RANGE);
                attribs.getBbAttribute("DurationType").setIsDirty(bFlagNotDirty);
                break;
            }
            case 6: {
                objToReturn.setClassificationBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("ClassificationBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 7: {
                objToReturn.setDataSourceBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 8: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRowStatus(this._conversionUtil.stringToRowStatus(tmp));
                attribs.getBbAttribute("RowStatus").setIsDirty(bFlagNotDirty);
                break;
            }
            case 9: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setEnrollmentType(this._conversionUtil.stringToEnrollment(tmp));
                attribs.getBbAttribute("EnrollmentType").setIsDirty(bFlagNotDirty);
                break;
            }
            case 10: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsAvailable(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IsAvailable").setIsDirty(bFlagNotDirty);
                break;
            }
            case 11: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setShowInCatalog(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("ShowInCatalog").setIsDirty(bFlagNotDirty);
                break;
            }
            case 12: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setHasDescriptionPage(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("HasDescriptionPage").setIsDirty(bFlagNotDirty);
                break;
            }
            case 13: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setDurationType(this._conversionUtil.stringToDuration(tmp));
                attribs.getBbAttribute("DurationType").setIsDirty(bFlagNotDirty);
                break;
            }
            case 14: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsLockedOut(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IsLockedOut").setIsDirty(bFlagNotDirty);
                break;
            }
            case 15: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setPaceType(this._conversionUtil.stringToPace(tmp));
                attribs.getBbAttribute("PaceType").setIsDirty(bFlagNotDirty);
                break;
            }
            case 16: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setServiceLevelType(this._conversionUtil.stringToServiceLevel(tmp));
                attribs.getBbAttribute("ServiceLevelType").setIsDirty(bFlagNotDirty);
                break;
            }
            case 17: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setAbsoluteLimit(XmlUtil.parseLong((String)this.formatString(bFlagNotDirty, tmp, -1)));
                attribs.getBbAttribute("AbsoluteLimit").setIsDirty(bFlagNotDirty);
                break;
            }
            case 18: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setSoftLimit(XmlUtil.parseLong((String)this.formatString(bFlagNotDirty, tmp, -1)));
                attribs.getBbAttribute("SoftLimit").setIsDirty(bFlagNotDirty);
                break;
            }
            case 19: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setUploadLimit(XmlUtil.parseLong((String)this.formatString(bFlagNotDirty, tmp, -1)));
                attribs.getBbAttribute("UploadLimit").setIsDirty(bFlagNotDirty);
                break;
            }
            case 20: {
                objToReturn.setEnrollmentStartDate(this._conversionUtil.stringToCalendar(this.formatString(bFlagNotDirty, tmp, -1)));
                attribs.getBbAttribute("EnrollmentStartDate").setIsDirty(bFlagNotDirty);
                break;
            }
            case 21: {
                objToReturn.setEnrollmentEndDate(this._conversionUtil.stringToCalendar(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("EnrollmentEndDate").setIsDirty(bFlagNotDirty);
                break;
            }
            case 22: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setNumDaysOfUse(XmlUtil.parseInteger((String)TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("NumDaysOfUse").setIsDirty(bFlagNotDirty);
                objToReturn.setDurationType(Course.Duration.FIXED_NUM_DAYS);
                attribs.getBbAttribute("DurationType").setIsDirty(bFlagNotDirty);
                break;
            }
            case 23: {
                objToReturn.setInstitutionName(this.formatString(bFlagNotDirty, tmp, 255));
                attribs.getBbAttribute("InstitutionName").setIsDirty(bFlagNotDirty);
                break;
            }
            case 24: {
                objToReturn.setFee(XmlUtil.parseFloat((String)this.formatString(bFlagNotDirty, tmp, -1)));
                attribs.getBbAttribute("Fee").setIsDirty(bFlagNotDirty);
                break;
            }
            case 25: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setAllowGuests(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("AllowGuests").setIsDirty(bFlagNotDirty);
                break;
            }
            case 26: {
                objToReturn.setEnrollmentAccessCode(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("EnrollmentAccessCode").setIsDirty(bFlagNotDirty);
                break;
            }
            case 27: {
                objToReturn.setReplacementBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("ReplacementBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 28: {
                objToReturn.setTemplateBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("TemplateBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 29: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setAllowObservers(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("AllowObservers").setIsDirty(bFlagNotDirty);
                break;
            }
            case 30: {
                objToReturn.setLocale(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("Locale").setIsDirty(bFlagNotDirty);
                break;
            }
            case 31: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsLocaleEnforced(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IsLocaleEnforced").setIsDirty(bFlagNotDirty);
                break;
            }
            case 32: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                OverriddenSnapshotSettingsHelper.saveOverriddenBooleanSetting(attribs, OverriddenSetting.excludeDiscussionStarterPosts, Boolean.valueOf(tmp));
            }
        }
    }

    @Override
    protected void controlMaskInitialization() {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (StringUtil.isEmpty((String)tmp)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._overrides.set(this.getLegacyPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io1) {
                try {
                    this._overrides.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
                }
                catch (IndexOutOfBoundsException io2) {
                    LogServiceFactory.getInstance().logDebug("In controlMaskInitialization, IndexOutOfBoundsException occurred. txt is " + txt, (Throwable)io2);
                }
            }
        }
    }

    @Override
    protected void parameterMappingInitialization() {
        String[] dataList;
        this._legacyPosMapping = new LinkedList();
        for (String element : _eeDataColumnList) {
            this._legacyPosMapping.addLast(element);
        }
        this._posMapping = new LinkedList();
        for (String element : dataList = this.getBbListing()) {
            this._posMapping.addLast(element);
        }
        this._overrides = new BitSet(dataList.length);
    }
}

