/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.course;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.CourseStandardSubDocument;
import blackboard.admin.snapshot.SnapshotException;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.data.ValidationException;
import blackboard.util.StringUtil;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class CourseStandardSubDocumentDelimitedParser
extends Parser {
    private static final String COURSE_KEY = "course_key";
    private static final String STD_SUB_DOC_KEY = "std_sub_doc_key";

    @Override
    protected String[] getBbListing() {
        return new String[]{COURSE_KEY, STD_SUB_DOC_KEY};
    }

    @Override
    protected IAdminObject getObjectInstance() {
        return new CourseStandardSubDocument();
    }

    @Override
    protected void handleAttributeMapping(IAdminObject obj, int pos, String value, boolean flagNotDirty) throws ValidationException {
        CourseStandardSubDocument o = (CourseStandardSubDocument)obj;
        switch (pos) {
            case 0: {
                o.setCourseBatchUid(this.formatString(flagNotDirty, value, -1));
                break;
            }
            case 1: {
                o.setSubDocBatchUid(this.formatString(flagNotDirty, value, -1));
            }
        }
    }

    @Override
    protected void parameterMappingInitialization() throws SnapshotException {
        this._posMapping = new LinkedList();
        this._posMapping.add(COURSE_KEY);
        this._posMapping.add(STD_SUB_DOC_KEY);
    }

    @Override
    protected void controlMaskInitialization() throws SnapshotException {
        this._overrides = new BitSet(2);
        this._overrides.set(0, 1);
    }

    @Override
    protected boolean validateHeaderForRequiredFields(String label) {
        if (StringUtil.isEmpty((String)label)) {
            return false;
        }
        char delimiter = this._authority.getConfigurationManager().getDelimiter();
        String[] fields = label.split(Pattern.quote(String.valueOf(delimiter)));
        return fields.length == 2 && this.validateHeaderLabel(fields[0]) && this.validateHeaderLabel(fields[1]);
    }

    @Override
    protected boolean validateHeaderLabel(String label) {
        return COURSE_KEY.equals(label) || STD_SUB_DOC_KEY.equals(label);
    }
}

