/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.course;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class IntegrationCourseSiteDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "group.bb.controlled.fields";
    static String[] _bbDataColumnList = new String[]{"course_id", "batch_uid"};
    static String[] _requiredFieldList = new String[]{"course_id", "batch_uid"};

    @Override
    public void checkApiLicensing() {
    }

    @Override
    protected String[] getBbListing() {
        return _bbDataColumnList;
    }

    @Override
    protected boolean validateHeaderForRequiredFields(String header) {
        for (String element : _requiredFieldList) {
            int pos = header.indexOf(element);
            int mrk = pos + element.length();
            if (pos <= -1 || mrk != header.length() && header.charAt(mrk) != this._authority.getConfigurationManager().getDelimiter()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean validateHeaderLabel(String line) {
        boolean bStatus = false;
        for (String element : _bbDataColumnList) {
            if (!element.equals(line)) continue;
            bStatus = true;
            break;
        }
        return bStatus;
    }

    @Override
    protected IAdminObject getObjectInstance() {
        return new CourseSite();
    }

    @Override
    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) {
        CourseSite objToReturn = (CourseSite)obj;
        switch (absolutePos) {
            case 0: {
                objToReturn.setCourseSiteId(this.formatString(bFlagNotDirty, tmp, -1));
                break;
            }
            case 1: {
                objToReturn.setBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
            }
        }
    }

    @Override
    protected void controlMaskInitialization() {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (StringUtil.isEmpty((String)tmp)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._overrides.set(this.getLegacyPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException ioe) {
                LogServiceFactory.getInstance().logWarning("IndexOutOfBoundsException. txt is " + txt, (Throwable)ioe);
            }
            try {
                this._overrides.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io2) {
                LogServiceFactory.getInstance().logWarning("IndexOutOfBoundsException. the txt is " + txt, (Throwable)io2);
            }
        }
    }

    @Override
    protected void parameterMappingInitialization() {
        this._legacyPosMapping = new LinkedList();
        this._posMapping = new LinkedList();
        for (String element : _bbDataColumnList) {
            this._posMapping.addLast(element);
        }
        this._overrides = new BitSet(_bbDataColumnList.length);
    }
}

