/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.course;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.Membership;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbAttributes;
import blackboard.data.BbLink;
import blackboard.data.ValidationException;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import blackboard.util.TextFormat;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class MembershipDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "membership.bb.controlled.fields";
    static String[] _eeDataColumnList = new String[]{"course_section_key", "campus_user_key", "course_role"};
    static String[] _bbCrsDataColumnList = new String[]{"external_course_key", "external_person_key", "role", "row_status", "available_ind", "link_name_1", "link_url_1", "link_desc_1", "link_name_2", "link_url_2", "link_desc_2", "link_name_3", "link_url_3", "link_desc_3", "intro", "pinfo", "new_data_source_key", "note", "cartridge_ind", "last_access_date", "receive_email_ind", "roster_ind"};
    static String[] _bbOrgDataColumnList = new String[]{"external_organization_key", "external_person_key", "role", "row_status", "available_ind", "link_name_1", "link_url_1", "link_desc_1", "link_name_2", "link_url_2", "link_desc_2", "link_name_3", "link_url_3", "link_desc_3", "intro", "pinfo", "new_data_source_key", "note", "cartridge_ind", "last_access_date", "receive_email_ind", "roster_ind"};
    static String[] _legacyRequiredFieldList = new String[]{"course_section_key", "campus_user_key"};
    static String[] _crsRequiredFieldList = new String[]{"external_course_key", "external_person_key"};
    static String[] _orgRequiredFieldList = new String[]{"external_organization_key", "external_person_key"};

    @Override
    protected boolean validateHeaderLabel(String line) {
        String[] dataList;
        boolean bStatus = false;
        for (String element : _eeDataColumnList) {
            if (!element.equals(line)) continue;
            bStatus = true;
            break;
        }
        if (bStatus) {
            return bStatus;
        }
        for (String element : dataList = this.getBbListing()) {
            if (!element.equals(line)) continue;
            bStatus = true;
            break;
        }
        return bStatus;
    }

    @Override
    protected void controlMaskInitialization() {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (StringUtil.isEmpty((String)tmp)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._overrides.set(this.getLegacyPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io1) {
                try {
                    this._overrides.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
                }
                catch (IndexOutOfBoundsException io2) {
                    LogServiceFactory.getInstance().logDebug("IndexOutOfBoundsException occurred. txt is " + txt, (Throwable)io2);
                }
            }
        }
    }

    @Override
    protected void parameterMappingInitialization() {
        String[] dataList;
        this._legacyPosMapping = new LinkedList();
        for (String element : _eeDataColumnList) {
            this._legacyPosMapping.addLast(element);
        }
        this._posMapping = new LinkedList();
        for (String element : dataList = this.getBbListing()) {
            this._posMapping.addLast(element);
        }
        this._overrides = new BitSet(dataList.length);
    }

    @Override
    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) throws ValidationException {
        Membership objToReturn = (Membership)obj;
        BbAttributes attribs = objToReturn.getBbAttributes();
        switch (absolutePos) {
            case 1: {
                objToReturn.setPersonBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                break;
            }
            case 0: {
                objToReturn.getBbAttributes().setString("GroupBatchUid", this.formatString(bFlagNotDirty, tmp, -1));
                break;
            }
            case 2: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRole(this._conversionUtil.stringToCourseRole(tmp));
                attribs.getBbAttribute("Role").setIsDirty(bFlagNotDirty);
                break;
            }
            case 3: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRowStatus(this._conversionUtil.stringToRowStatus(tmp));
                attribs.getBbAttribute("RowStatus").setIsDirty(bFlagNotDirty);
                break;
            }
            case 4: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsAvailable(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IsAvailable").setIsDirty(bFlagNotDirty);
                break;
            }
            case 5: {
                objToReturn.setLinkName1(this.formatString(bFlagNotDirty, tmp, 100));
                this.resetLinkAttribute(objToReturn, "Name", 1, bFlagNotDirty);
                break;
            }
            case 6: {
                objToReturn.setLinkUrl1(this.formatString(bFlagNotDirty, tmp, 100));
                this.resetLinkAttribute(objToReturn, "Url", 1, bFlagNotDirty);
                break;
            }
            case 7: {
                objToReturn.setLinkDescription1(this.formatString(bFlagNotDirty, tmp, 255));
                this.resetLinkAttribute(objToReturn, "Description", 1, bFlagNotDirty);
                break;
            }
            case 8: {
                objToReturn.setLinkName2(this.formatString(bFlagNotDirty, tmp, 100));
                this.resetLinkAttribute(objToReturn, "Name", 2, bFlagNotDirty);
                break;
            }
            case 9: {
                objToReturn.setLinkUrl2(this.formatString(bFlagNotDirty, tmp, 100));
                this.resetLinkAttribute(objToReturn, "Url", 2, bFlagNotDirty);
                break;
            }
            case 10: {
                objToReturn.setLinkDescription2(this.formatString(bFlagNotDirty, tmp, 255));
                this.resetLinkAttribute(objToReturn, "Description", 2, bFlagNotDirty);
                break;
            }
            case 11: {
                objToReturn.setLinkName3(this.formatString(bFlagNotDirty, tmp, 100));
                this.resetLinkAttribute(objToReturn, "Name", 3, bFlagNotDirty);
                break;
            }
            case 12: {
                objToReturn.setLinkUrl3(this.formatString(bFlagNotDirty, tmp, 100));
                this.resetLinkAttribute(objToReturn, "Url", 3, bFlagNotDirty);
                break;
            }
            case 13: {
                objToReturn.setLinkDescription3(this.formatString(bFlagNotDirty, tmp, 255));
                this.resetLinkAttribute(objToReturn, "Description", 3, bFlagNotDirty);
                break;
            }
            case 14: {
                objToReturn.setIntroduction(this.formatString(bFlagNotDirty, tmp, 4000));
                attribs.getBbAttribute("Introduction").setIsDirty(bFlagNotDirty);
                break;
            }
            case 15: {
                objToReturn.setPersonalInfo(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("PersonalInfo").setIsDirty(bFlagNotDirty);
                break;
            }
            case 16: {
                objToReturn.setDataSourceBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 17: {
                objToReturn.setNotes(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("Notes").setIsDirty(bFlagNotDirty);
                break;
            }
            case 18: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setHasCartridgeAccess(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("HasCartridgeAccess").setIsDirty(bFlagNotDirty);
                break;
            }
            case 19: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setLastAccessDate(this._conversionUtil.stringToCalendar(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("LastAccessDate").setIsDirty(bFlagNotDirty);
                break;
            }
            case 20: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setReceiveEmail(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("ReceiveEmail").setIsDirty(bFlagNotDirty);
                break;
            }
            case 21: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIncludedInRoster(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IncludedInRoster").setIsDirty(bFlagNotDirty);
            }
        }
    }

    private void resetLinkAttribute(Membership objToReturn, String name, int pos, boolean bFlagNotDirty) {
        BbLink link = objToReturn.getBbLinkAtPos(pos);
        BbAttributes attribs = link.getBbAttributes();
        attribs.getBbAttribute(name).setIsDirty(bFlagNotDirty);
    }
}

