/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.course;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.AdminCourseCourse;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.IMembership;
import blackboard.admin.data.course.Membership;
import blackboard.admin.data.course.MembershipXmlDef;
import blackboard.admin.data.course.Organization;
import blackboard.admin.data.course.OrganizationMembership;
import blackboard.admin.data.course.StaffAssignment;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.user.Person;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.serialize.XmlHandler;
import blackboard.admin.snapshot.serialize.course.MembershipDelimitedParser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.admin.snapshot.util.TimeFormat;
import blackboard.data.BbAttributes;
import blackboard.data.BbLink;
import blackboard.data.course.CourseMembership;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import blackboard.xml.XmlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class MembershipXmlHandler
extends XmlHandler
implements MembershipXmlDef {
    public static final String XML_REGISTRY_1 = "membership";
    static final String CONTROLLED_SETTINGS = "membership.bb.controlled.fields";
    private IMembership _obj;
    private final Map<String, String> _ovrMap = new HashMap<String, String>();
    private String _activeElement;
    private String _activeEntityElement;
    private Attributes _activeAttributes;
    private BbAttributes _bbAttribs;
    private String _groupBatchUid;
    private DataType _dataType;
    private boolean _isInherited = false;
    private String _inheritedFromGroupBatchUid;
    private boolean _validRole = false;

    @Override
    public void init(Authority authority) {
        super.init(authority);
        try {
            this._dataType = new DataType(Class.forName(authority.getConfigurationManager().getSetting("DATA_TYPE_TOGGLE")));
        }
        catch (Exception exc) {
            this._dataType = StaffAssignment.DATA_TYPE;
        }
        String tmp = authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (StringUtil.isEmpty((String)tmp)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            this._ovrMap.put(txt.toLowerCase(), "ignore");
        }
        this.initDelimitedXmlMapping();
    }

    private void initDelimitedXmlMapping() {
        this.handleDelimitedArrayXmlMapping(MembershipDelimitedParser._eeDataColumnList);
        this.handleDelimitedArrayXmlMapping(MembershipDelimitedParser._bbCrsDataColumnList);
        this.handleDelimitedArrayXmlMapping(MembershipDelimitedParser._bbOrgDataColumnList);
    }

    protected Attributes getActiveAttributes() {
        return this._activeAttributes;
    }

    protected String getActiveElement() {
        return this._activeElement;
    }

    protected IMembership getObject() {
        return this._obj;
    }

    private void handleDelimitedArrayXmlMapping(String[] elementList) {
        block19: for (int cnt = 0; cnt < elementList.length; ++cnt) {
            String value = elementList[cnt];
            if (value == null || value.length() == 0 || !this._ovrMap.containsKey(value.toLowerCase())) continue;
            switch (cnt) {
                case 2: {
                    this._ovrMap.put("role", "ignore");
                    continue block19;
                }
                case 3: {
                    this._ovrMap.put("x_bb_row_status", "ignore");
                    continue block19;
                }
                case 4: {
                    this._ovrMap.put("status", "ignore");
                    continue block19;
                }
                case 5: {
                    this._ovrMap.put("x_bb_link_name_1", "ignore");
                    continue block19;
                }
                case 6: {
                    this._ovrMap.put("x_bb_link_url_1", "ignore");
                    continue block19;
                }
                case 7: {
                    this._ovrMap.put("x_bb_link_desc_1", "ignore");
                    continue block19;
                }
                case 8: {
                    this._ovrMap.put("x_bb_link_name_2", "ignore");
                    continue block19;
                }
                case 9: {
                    this._ovrMap.put("x_bb_link_url_2", "ignore");
                    continue block19;
                }
                case 10: {
                    this._ovrMap.put("x_bb_link_desc_2", "ignore");
                    continue block19;
                }
                case 11: {
                    this._ovrMap.put("x_bb_link_name_3", "ignore");
                    continue block19;
                }
                case 12: {
                    this._ovrMap.put("x_bb_link_url_3", "ignore");
                    continue block19;
                }
                case 13: {
                    this._ovrMap.put("x_bb_link_desc_3", "ignore");
                    continue block19;
                }
                case 14: {
                    this._ovrMap.put("x_bb_introduction", "ignore");
                    continue block19;
                }
                case 15: {
                    this._ovrMap.put("x_bb_private_information", "ignore");
                    continue block19;
                }
                case 16: {
                    this._ovrMap.put("x_bb_datasource_key", "ignore");
                    continue block19;
                }
                case 17: {
                    this._ovrMap.put("x_bb_notes", "ignore");
                    continue block19;
                }
                case 18: {
                    this._ovrMap.put("x_bb_has_cartridge_access", "ignore");
                }
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) {
        if (name.equalsIgnoreCase(XML_REGISTRY_1)) {
            this._activeEntityElement = name;
            this._isInherited = false;
            return;
        }
        if (name.equalsIgnoreCase("x_bb_inheritedmembership")) {
            this._activeEntityElement = name;
            this._isInherited = true;
            return;
        }
        if (name.equalsIgnoreCase("member")) {
            this._obj = this._dataType.equals((Object)StaffAssignment.DATA_TYPE) ? new StaffAssignment() : (this._dataType.equals((Object)AdminCourseCourse.DATA_TYPE) ? new AdminCourseCourse() : new StaffAssignment());
            this._bbAttribs = this._obj.getBbAttributes();
            this._activeEntityElement = name;
            this._bbAttribs.setString("GroupBatchUid", this._groupBatchUid);
            if (this._groupBatchUid != null) {
                this._bbAttribs.getBbAttribute("GroupBatchUid").setIsDirty(true);
            }
            return;
        }
        this._activeElement = name.toLowerCase();
        this._activeAttributes = atts;
        if (this._activeElement.equalsIgnoreCase("role")) {
            this.unMarshallRoleNode(!this._ovrMap.containsKey(this._activeElement));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        boolean bDirtyFlag;
        if (this._activeElement == null) {
            return;
        }
        String value = super.updateCharacterBuffer(ch, start, length).trim();
        boolean bl = bDirtyFlag = !this._ovrMap.containsKey(this._activeElement);
        if (this._activeEntityElement.equalsIgnoreCase(XML_REGISTRY_1)) {
            this.unMarshallMembershipSourceIdNode(value, bDirtyFlag);
            return;
        }
        if (this._activeEntityElement.equalsIgnoreCase("x_bb_inheritedmembership")) {
            this.unMarshallInheritedMembershipSourceIdNode(value, bDirtyFlag);
            return;
        }
        if (this.unMarshallMemberSourceIdNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallMemberIdTypeNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallStatusNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallExtensionNode(value, bDirtyFlag)) {
            return;
        }
    }

    @Override
    public IAdminObject endElement(String uri, String local, String name) {
        super.endElement(uri, local, name);
        if (name.equalsIgnoreCase("member") && !(this._obj instanceof AdminCourseCourse)) {
            IMembership.IdType idType = this._obj.getIdType();
            if (idType == IMembership.IdType.CourseCourse) {
                AdminCourseCourse obj = new AdminCourseCourse();
                obj.setParentGroupBatchUid(this._obj.getParentBatchUid());
                obj.setChildGroupBatchUid(this._obj.getChildBatchUid());
                obj.setRecStatus(this._obj.getRecStatus());
                obj.setRowStatus(this._obj.getRowStatus());
                return obj;
            }
            if (this._isInherited) {
                ((Membership)this._obj).setInheritedFromGroupBatchUid(this._inheritedFromGroupBatchUid);
            }
            return this._obj;
        }
        return null;
    }

    @Override
    public void release() {
        this._obj = null;
    }

    protected boolean unMarshallMembershipSourceIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("id")) {
            this._groupBatchUid = value;
            return true;
        }
        return this._activeElement.equalsIgnoreCase("source");
    }

    private boolean unMarshallInheritedMembershipSourceIdNode(String value, boolean dirtyFlag) {
        if (this._activeElement.equalsIgnoreCase("id")) {
            this._inheritedFromGroupBatchUid = value;
            return true;
        }
        return this._activeElement.equalsIgnoreCase("source");
    }

    protected boolean unMarshallMemberSourceIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("id")) {
            this._obj.setChildBatchUid(value);
            this._obj.setChildBatchUidDirty(bFlagDirty);
            return true;
        }
        return this._activeElement.equalsIgnoreCase("source");
    }

    protected boolean unMarshallMemberIdTypeNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("idtype")) {
            this._obj.setIdType(Integer.valueOf(value));
            this._bbAttribs.getBbAttribute("idtype").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    protected boolean unMarshallRoleNode(boolean bFlagDirty) {
        if (this.getActiveElement().equalsIgnoreCase("role")) {
            String sRole = this.getActiveAttributes().getValue("roletype");
            int iRole = 0;
            String roleId = null;
            try {
                iRole = Integer.parseInt(sRole);
            }
            catch (Exception e) {
                iRole = 10;
                roleId = sRole;
            }
            this._validRole = false;
            String recStatusStr = XmlUtil.getAttributeValue((Attributes)this._activeAttributes, (String)"recstatus", (String)IAdminObject.RecStatus.DEFAULT.toFieldName());
            IAdminObject.RecStatus recStatus = (IAdminObject.RecStatus)IAdminObject.RecStatus.fromFieldName((String)recStatusStr, IAdminObject.RecStatus.class);
            if (this._obj instanceof Membership) {
                Membership mem = (Membership)this._obj;
                CourseMembership.Role role = null;
                boolean explicitMap = false;
                if (role == null) {
                    roleId = StringUtil.notEmpty((String)roleId) ? roleId : this.getActiveAttributes().getValue("x_bb_roleidentifier");
                    role = this._cvUtility.intToCourseMembershipRole(iRole, roleId);
                }
                if (role != null && (!mem.getBbAttributes().getBbAttribute("Role").getIsSet() || explicitMap || role.comparePrecedence(mem.getRole()) < 0 && !recStatus.equals((Object)IAdminObject.RecStatus.DELETE) || !recStatus.equals((Object)IAdminObject.RecStatus.DELETE) && mem.getRecStatus().equals((Object)IAdminObject.RecStatus.DELETE))) {
                    mem.setRole(role);
                    mem.getBbAttributes().getBbAttribute("Role").setIsDirty(iRole == -1 ? false : bFlagDirty);
                    mem.setRecStatus(recStatus);
                    this._validRole = true;
                }
            } else {
                this._obj.setRecStatus(recStatus);
            }
            return true;
        }
        return false;
    }

    private boolean unMarshallStatusNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("status") && this._validRole) {
            ((Membership)this._obj).setIsAvailable(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("IsAvailable").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    protected boolean unMarshallExtensionNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("x_bb_row_status")) {
            this._obj.setRowStatus(this._cvUtility.intToRowStatus(XmlUtil.parseInteger((String)value)));
            this._bbAttribs.getBbAttribute("RowStatus").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_introduction")) {
            ((Membership)this._obj).setIntroduction(value);
            this._bbAttribs.getBbAttribute("Introduction").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_private_information")) {
            ((Membership)this._obj).setPersonalInfo(value);
            this._bbAttribs.getBbAttribute("PersonalInfo").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_datasource_key")) {
            this._obj.setDataSourceBatchUid(value);
            this._bbAttribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_notes")) {
            ((Membership)this._obj).setNotes(value);
            this._bbAttribs.getBbAttribute("Notes").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_has_cartridge_access")) {
            ((Membership)this._obj).setHasCartridgeAccess(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("HasCartridgeAccess").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_link_name_1")) {
            ((Membership)this._obj).setLinkName1(value);
            this.resetLinkAttribute("Name", 1, bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_link_desc_1")) {
            ((Membership)this._obj).setLinkDescription1(value);
            this.resetLinkAttribute("Description", 1, bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_link_url_1")) {
            ((Membership)this._obj).setLinkUrl1(value);
            this.resetLinkAttribute("Url", 1, bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_link_name_2")) {
            ((Membership)this._obj).setLinkName2(value);
            this.resetLinkAttribute("Name", 2, bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_link_desc_2")) {
            ((Membership)this._obj).setLinkDescription2(value);
            this.resetLinkAttribute("Description", 2, bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_link_url_2")) {
            ((Membership)this._obj).setLinkUrl2(value);
            this.resetLinkAttribute("Url", 2, bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_link_name_3")) {
            ((Membership)this._obj).setLinkName3(value);
            this.resetLinkAttribute("Name", 3, bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_link_desc_3")) {
            ((Membership)this._obj).setLinkDescription3(value);
            this.resetLinkAttribute("Description", 3, bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_link_url_3")) {
            ((Membership)this._obj).setLinkUrl3(value);
            this.resetLinkAttribute("Url", 3, bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_enrollment_date")) {
            ((Membership)this._obj).setEnrollmentDate(TimeFormat.stringToCalendar(value));
            this._bbAttribs.getBbAttribute("EnrollmentDate").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_last_access_date")) {
            ((Membership)this._obj).setEnrollmentDate(TimeFormat.stringToCalendar(value));
            this._bbAttribs.getBbAttribute("LastAccessDate").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_embedded_source")) {
            this._obj.getBbAttributes().setString("embed", value);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_data_source_id")) {
            try {
                this._bbAttribs.setId("DataSourceId", Id.generateId((DataType)DataSource.DATA_TYPE, (String)value));
            }
            catch (Exception exc) {
                this._bbAttribs.setId("DataSourceId", Id.UNSET_ID);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_internal_id")) {
            try {
                this._obj.setId(Id.generateId((DataType)this._obj.getDataType(), (String)value));
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Unable to generate id. value is " + value, (Throwable)exc);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_internal_group_id")) {
            DataType dType = null;
            dType = this._obj instanceof OrganizationMembership ? Organization.DATA_TYPE : CourseSite.DATA_TYPE;
            try {
                this._obj.getBbAttributes().setId("CourseId", Id.generateId((DataType)dType, (String)value));
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Unable to generate course id. value is " + value, (Throwable)exc);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_internal_person_id")) {
            try {
                ((Membership)this._obj).setUserId(Id.generateId((DataType)Person.DATA_TYPE, (String)value));
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Unable to generate person id. value is " + value, (Throwable)exc);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_receive_email")) {
            try {
                ((Membership)this._obj).setReceiveEmail(ConversionUtility.getBoolean(value));
                this._bbAttribs.getBbAttribute("ReceiveEmail").setIsDirty(bFlagDirty);
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Unable to setReceiveEmail. value is " + value, (Throwable)exc);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_included_in_roster")) {
            try {
                ((Membership)this._obj).setIncludedInRoster(ConversionUtility.getBoolean(value));
                this._bbAttribs.getBbAttribute("IncludedInRoster").setIsDirty(bFlagDirty);
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Unable to setIncludedInRoster. value is " + value, (Throwable)exc);
            }
            return true;
        }
        return false;
    }

    private void resetLinkAttribute(String name, int pos, boolean bFlagNotDirty) {
        BbLink link = ((Membership)this._obj).getBbLinkAtPos(pos);
        BbAttributes attribs = link.getBbAttributes();
        attribs.getBbAttribute(name).setIsDirty(bFlagNotDirty);
    }
}

