/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.role;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class PortalRoleMembershipDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "portalrolemembership.bb.controlled.fields";
    static String[] _bbDataColumnList = new String[]{"role_id", "external_person_key", "row_status", "new_data_source_key"};
    static String[] _requiredFieldList = new String[]{"role_id", "external_person_key"};

    @Override
    protected String[] getBbListing() {
        return _bbDataColumnList;
    }

    @Override
    protected boolean validateHeaderForRequiredFields(String header) {
        for (String element : _requiredFieldList) {
            int pos = header.indexOf(element);
            int mrk = pos + element.length();
            if (pos <= -1 || mrk != header.length() && header.charAt(mrk) != this._authority.getConfigurationManager().getDelimiter()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean validateHeaderLabel(String line) {
        boolean bStatus = false;
        for (String element : _bbDataColumnList) {
            if (!element.equals(line)) continue;
            bStatus = true;
            break;
        }
        return bStatus;
    }

    @Override
    protected IAdminObject getObjectInstance() {
        return new PortalRoleMembership();
    }

    @Override
    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) throws ValidationException {
        PortalRoleMembership objToReturn = (PortalRoleMembership)obj;
        BbAttributes _attribs = objToReturn.getBbAttributes();
        switch (absolutePos) {
            case 1: {
                objToReturn.setPersonBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                _attribs.getBbAttribute("PersonBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 0: {
                objToReturn.setPortalRoleBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                _attribs.getBbAttribute("PortalRoleBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 2: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRowStatus(this._conversionUtil.stringToRowStatus(tmp));
                _attribs.getBbAttribute("RowStatus").setIsDirty(bFlagNotDirty);
                break;
            }
            case 3: {
                objToReturn.setDataSourceBatchUid(tmp);
                _attribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagNotDirty);
            }
        }
    }

    @Override
    protected void controlMaskInitialization() {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (StringUtil.isEmpty((String)tmp)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._overrides.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io2) {
                LogServiceFactory.getInstance().logDebug("IndexOutOfBounds Exception occurred. txt is " + txt, (Throwable)io2);
            }
        }
    }

    @Override
    protected void parameterMappingInitialization() {
        this._posMapping = new LinkedList();
        for (String element : _bbDataColumnList) {
            this._posMapping.addLast(element);
        }
        this._overrides = new BitSet(_bbDataColumnList.length);
    }
}

