/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.user;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.util.StringUtil;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class ObserverAssociationDelimitedParser
extends Parser {
    protected static final String CONTROLLED_SETTINGS = "observerassociation.bb.controlled.fields";
    protected static final String[] REQUIRED_FIELD_LIST = new String[]{"external_observer_key", "external_user_key"};
    private static final String[] DATA_COLUMN_LIST = new String[]{"external_observer_key", "external_user_key", "row_status", "new_data_source_key"};

    @Override
    protected String[] getBbListing() {
        return DATA_COLUMN_LIST;
    }

    @Override
    protected IAdminObject getObjectInstance() {
        return new ObserverAssociation();
    }

    @Override
    protected boolean validateHeaderForRequiredFields(String header) {
        char delim = this._authority.getConfigurationManager().getDelimiter();
        for (String element : REQUIRED_FIELD_LIST) {
            int pos = header.indexOf(element);
            int mrk = pos + element.length();
            if (pos <= -1 || mrk != header.length() && header.charAt(mrk) != delim) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean validateHeaderLabel(String line) {
        for (String element : this.getBbListing()) {
            if (!element.equals(line)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void controlMaskInitialization() {
        String fields = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (StringUtil.isEmpty((String)fields)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(fields, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._overrides.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException e) {}
        }
    }

    @Override
    protected void parameterMappingInitialization() {
        String[] dataList;
        this._posMapping = new LinkedList();
        for (String element : dataList = this.getBbListing()) {
            this._posMapping.addLast(element);
        }
        this._overrides = new BitSet(dataList.length);
    }

    @Override
    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) throws ValidationException {
        IAdminObject objToReturn = obj;
        BbAttributes attribs = objToReturn.getBbAttributes();
        switch (absolutePos) {
            case 0: {
                attribs.setString("ObserverBatchUid", this.formatString(bFlagNotDirty, tmp, -1));
                break;
            }
            case 1: {
                objToReturn.getBbAttributes().setString("UserBatchUid", this.formatString(bFlagNotDirty, tmp, -1));
                break;
            }
            case 2: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRowStatus(this._conversionUtil.stringToRowStatus(tmp));
                attribs.getBbAttribute("RowStatus").setIsDirty(bFlagNotDirty);
                break;
            }
            case 3: {
                objToReturn.setDataSourceBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagNotDirty);
            }
        }
    }
}

