/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.user;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.user.Person;
import blackboard.admin.data.user.PersonXmlDef;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.serialize.XmlHandler;
import blackboard.admin.snapshot.serialize.user.PersonDelimitedParser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.admin.snapshot.util.TimeFormat;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.data.role.PortalRole;
import blackboard.data.user.User;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.role.PortalRoleDbLoader;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import blackboard.xml.XmlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class PersonXmlHandler
extends XmlHandler
implements PersonXmlDef {
    public static final String XML_REGISTRY = "person";
    private static final String CONTROLLED_SETTINGS = "person.bb.controlled.fields";
    private final Map<String, String> _ovrMap = new HashMap<String, String>();
    private final Map<String, String> _encounteredElements = new HashMap<String, String>();
    private Person _obj;
    private String _activeElement;
    private Attributes _activeAttributes;
    private BbAttributes _bbAttribs;
    private boolean _bEncrypt;

    @Override
    public void init(Authority authority) {
        super.init(authority);
        this._bEncrypt = ConversionUtility.getBoolean(authority.getConfigurationManager().getSetting("encrypt.password"));
        String tmp = authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (StringUtil.isEmpty((String)tmp)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            this._ovrMap.put(txt.toLowerCase(), "ignore");
        }
        this.initDelimitedXmlMapping();
    }

    private void initDelimitedXmlMapping() {
        this.handleDelimitedArrayXmlMapping(PersonDelimitedParser.BB_DATA_COLUMN_LIST);
        this.handleDelimitedArrayXmlMapping(PersonDelimitedParser.EE_DATA_COLUMN_LIST);
    }

    private void handleDelimitedArrayXmlMapping(String[] elementList) {
        block45: for (int cnt = 0; cnt < elementList.length; ++cnt) {
            String value = elementList[cnt];
            if (null == value || value.length() == 0 || !this._ovrMap.containsKey(value.toLowerCase())) continue;
            switch (cnt) {
                case 0: {
                    this._ovrMap.put("systemrole", "ignore");
                    continue block45;
                }
                case 1: {
                    this._ovrMap.put("id", "ignore");
                    continue block45;
                }
                case 2: {
                    this._ovrMap.put("userid", "ignore");
                    continue block45;
                }
                case 3: {
                    this._ovrMap.put("password", "ignore");
                    continue block45;
                }
                case 4: {
                    this._ovrMap.put("prefix", "ignore");
                    continue block45;
                }
                case 5: {
                    this._ovrMap.put("given", "ignore");
                    continue block45;
                }
                case 6: {
                    this._ovrMap.put("other", "ignore");
                    continue block45;
                }
                case 7: {
                    this._ovrMap.put("family", "ignore");
                    continue block45;
                }
                case 43: {
                    this._ovrMap.put("other", "ignore");
                    continue block45;
                }
                case 44: {
                    this._ovrMap.put("suffix", "ignore");
                    continue block45;
                }
                case 8: {
                    this._ovrMap.put("tel", "ignore");
                    continue block45;
                }
                case 9: {
                    this._ovrMap.put("tel", "ignore");
                    continue block45;
                }
                case 10: {
                    this._ovrMap.put("tel", "ignore");
                    continue block45;
                }
                case 11: {
                    this._ovrMap.put("x_bb_contact_indicator", "ignore");
                    continue block45;
                }
                case 12: {
                    this._ovrMap.put("email", "ignore");
                    continue block45;
                }
                case 13: {
                    this._ovrMap.put("x_bb_email_indicator", "ignore");
                    continue block45;
                }
                case 14: {
                    this._ovrMap.put("bday", "ignore");
                    continue block45;
                }
                case 15: {
                    this._ovrMap.put("street", "ignore");
                    continue block45;
                }
                case 16: {
                    this._ovrMap.put("street", "ignore");
                    continue block45;
                }
                case 17: {
                    this._ovrMap.put("locality", "ignore");
                    continue block45;
                }
                case 18: {
                    this._ovrMap.put("region", "ignore");
                    continue block45;
                }
                case 19: {
                    this._ovrMap.put("pcode", "ignore");
                    continue block45;
                }
                case 20: {
                    this._ovrMap.put("country", "ignore");
                    continue block45;
                }
                case 21: {
                    this._ovrMap.put("x_bb_address_indicator", "ignore");
                    continue block45;
                }
                case 22: {
                    this._ovrMap.put("x_bb_company", "ignore");
                    continue block45;
                }
                case 23: {
                    this._ovrMap.put("x_bb_company_department", "ignore");
                    continue block45;
                }
                case 24: {
                    this._ovrMap.put("x_bb_job_title", "ignore");
                    continue block45;
                }
                case 25: {
                    this._ovrMap.put("tel", "ignore");
                    continue block45;
                }
                case 26: {
                    this._ovrMap.put("tel", "ignore");
                    continue block45;
                }
                case 27: {
                    this._ovrMap.put("x_bb_work_indicator", "ignore");
                    continue block45;
                }
                case 28: {
                    this._ovrMap.put("x_bb_public_indicator", "ignore");
                    continue block45;
                }
                case 29: {
                    this._ovrMap.put("x_bb_studentid", "ignore");
                    continue block45;
                }
                case 30: {
                    this._ovrMap.put("institutionrole", "ignore");
                    continue block45;
                }
                case 31: {
                    this._ovrMap.put("x_bb_row_status", "ignore");
                    continue block45;
                }
                case 32: {
                    this._ovrMap.put("gender", "ignore");
                    continue block45;
                }
                case 33: {
                    this._ovrMap.put("tel", "ignore");
                    continue block45;
                }
                case 34: {
                    this._ovrMap.put("tel", "ignore");
                    continue block45;
                }
                case 35: {
                    this._ovrMap.put("x_bb_webpage", "ignore");
                    continue block45;
                }
                case 36: {
                    this._ovrMap.put("x_bb_education_level", "ignore");
                    continue block45;
                }
                case 37: {
                    this._ovrMap.put("x_bb_available", "ignore");
                    continue block45;
                }
                case 38: {
                    this._ovrMap.put("x_bb_datasource_key", "ignore");
                    continue block45;
                }
                case 39: {
                    this._ovrMap.put("x_bb_settings", "ignore");
                    continue block45;
                }
                case 40: {
                    this._ovrMap.put("x_bb_replacementkey", "ignore");
                }
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) {
        boolean passwordDirtyFlag;
        boolean roleDirtyFlag;
        if (name.equalsIgnoreCase(XML_REGISTRY)) {
            this._obj = new Person();
            this._bbAttribs = this._obj.getBbAttributes();
            String recStatus = XmlUtil.getAttributeValue((Attributes)atts, (String)"recstatus", (String)"4");
            this._obj.setRecStatus((IAdminObject.RecStatus)IAdminObject.RecStatus.fromFieldName((String)recStatus, IAdminObject.RecStatus.class));
            return;
        }
        this._activeElement = name.toLowerCase();
        this._activeAttributes = atts;
        boolean bl = roleDirtyFlag = !this._ovrMap.containsKey("systemrole");
        if (this.unMarshallSystemRoleNode(roleDirtyFlag)) {
            return;
        }
        if (this.unMarshallInstitutionRoleNode(roleDirtyFlag)) {
            return;
        }
        boolean bl2 = passwordDirtyFlag = !this._ovrMap.containsKey("password");
        if (this.unMarshallUserIdAttributes(passwordDirtyFlag)) {
            return;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        boolean bDirtyFlag;
        if (null == this._activeElement) {
            return;
        }
        String value = this.updateCharacterBuffer(ch, start, length).trim();
        boolean bl = bDirtyFlag = !this._ovrMap.containsKey(this._activeElement);
        if (this.unMarshallSourceIdNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallUserIdNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallNameNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallDemographicsNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallEmailNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallTelephoneNodes(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallAddressNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallExtensionNode(value, bDirtyFlag)) {
            return;
        }
    }

    @Override
    public IAdminObject endElement(String uri, String local, String name) {
        super.endElement(uri, local, name);
        if (name.equalsIgnoreCase("adr")) {
            this._encounteredElements.put(name, "1");
        }
        if (name.equalsIgnoreCase(XML_REGISTRY)) {
            return this._obj;
        }
        return null;
    }

    @Override
    public void release() {
        this._obj = null;
        this._encounteredElements.clear();
    }

    protected boolean unMarshallSourceIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("id")) {
            this._obj.setBatchUid(value);
            this._bbAttribs.getBbAttribute("BatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        return this._activeElement.equalsIgnoreCase("source");
    }

    protected boolean unMarshallUserIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("userid")) {
            if (null != value && value.length() > 0) {
                this._obj.setUserName(value);
                this._bbAttribs.getBbAttribute("UserName").setIsDirty(bFlagDirty);
            }
            return true;
        }
        return false;
    }

    protected boolean unMarshallUserIdAttributes(boolean bDirtyFlag) {
        if (this._activeElement.equalsIgnoreCase("userid")) {
            String password = XmlUtil.getAttributeValue((Attributes)this._activeAttributes, (String)"password", (String)"");
            if (password.length() > 0) {
                String encrypt = XmlUtil.getAttributeValue((Attributes)this._activeAttributes, (String)"pwencryptiontype", (String)"");
                if (encrypt.equalsIgnoreCase("clear")) {
                    this._obj.setPassword(ConversionUtility.getHashValue(password));
                } else {
                    this._obj.setPassword(password);
                }
                this._bbAttribs.getBbAttribute("Password").setIsDirty(bDirtyFlag);
            }
            return true;
        }
        return false;
    }

    protected boolean unMarshallNameNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("family")) {
            this._obj.setFamilyName(value);
            this._bbAttribs.getBbAttribute("FamilyName").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("given")) {
            this._obj.setGivenName(value);
            this._bbAttribs.getBbAttribute("GivenName").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("other")) {
            this._obj.setMiddleName(value);
            this._bbAttribs.getBbAttribute("MiddleName").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("prefix")) {
            this._obj.setTitle(value);
            this._bbAttribs.getBbAttribute("Title").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("other")) {
            this._obj.setOtherName(value);
            this._bbAttribs.getBbAttribute("OtherName").setIsDirty(bFlagDirty);
        } else if (this._activeElement.equalsIgnoreCase("suffix")) {
            this._obj.setSuffix(value);
            this._bbAttribs.getBbAttribute("Suffix").setIsDirty(bFlagDirty);
        }
        return false;
    }

    protected boolean unMarshallDemographicsNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("gender")) {
            this._obj.setGender(this._cvUtility.intToGender(XmlUtil.parseInteger((String)value)));
            this._bbAttribs.getBbAttribute("Gender").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("bday")) {
            this._obj.setBirthDate(TimeFormat.stringToCalendar(value));
            this._bbAttribs.getBbAttribute("BirthDate").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    protected boolean unMarshallEmailNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("email")) {
            this._obj.setEmailAddress(value);
            this._bbAttribs.getBbAttribute("Email").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    protected boolean unMarshallTelephoneNodes(String value, boolean bFlagDirty) {
        if (!this._activeElement.equalsIgnoreCase("tel")) {
            return false;
        }
        if (null == this._activeAttributes || this._activeAttributes.getLength() == 0) {
            return true;
        }
        this.unMarshallTelephoneNode(value, XmlUtil.parseInteger((String)this._activeAttributes.getValue(0)), bFlagDirty);
        return true;
    }

    protected boolean unMarshallSystemRoleNode(boolean bFlagDirty) {
        if (null == this._obj) {
            return false;
        }
        if (this._activeElement.equalsIgnoreCase("systemrole")) {
            String value = XmlUtil.getAttributeValue((Attributes)this._activeAttributes, (String)"systemroletype", (String)"");
            if (value.length() > 0) {
                User.SystemRole role = this._cvUtility.stringToSystemRole(value);
                if (null != role) {
                    this._obj.setSystemRole(role);
                } else {
                    this._obj.setSystemRoleIdentifier(value);
                }
                this._bbAttribs.getBbAttribute("SystemRole").setIsDirty(bFlagDirty);
            }
            return true;
        }
        return false;
    }

    protected boolean unMarshallInstitutionRoleNode(boolean bFlagDirty) {
        if (null == this._obj) {
            return false;
        }
        if (this._activeElement.equalsIgnoreCase("institutionrole")) {
            String roleType = XmlUtil.getAttributeValue((Attributes)this._activeAttributes, (String)"institutionroletype", (String)"");
            this.updateInstitutionRole(roleType);
            this._bbAttribs.getBbAttribute("PortalRoleId").setIsDirty(bFlagDirty);
            this._bbAttribs.getBbAttribute("PortalRole").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    private void updateInstitutionRole(String szRole) {
        if (null == this._obj || StringUtil.isEmpty((String)szRole)) {
            return;
        }
        if (this._authority.getConfigurationManager().isSOAPEnabled()) {
            this._obj.getBbAttributes().setString("StringPortalRole", szRole);
            return;
        }
        PortalRole role = null;
        try {
            role = this._cvUtility.stringToInstitutionRole(szRole);
        }
        catch (ValidationException ve) {
            try {
                role = PortalRoleDbLoader.Default.getInstance().loadDefault();
            }
            catch (Exception e) {
                this._authority.getLogger().logWarning("", e);
            }
        }
        this._obj.setPortalRole(role);
    }

    private void unMarshallTelephoneNode(String value, int att, boolean bFlagDirty) {
        switch (att) {
            case 0: {
                this._obj.setHomePhone1(value);
                this._bbAttribs.getBbAttribute("HomePhone1").setIsDirty(bFlagDirty);
                break;
            }
            case 1: {
                this._obj.setHomeFax(value);
                this._bbAttribs.getBbAttribute("HomeFax").setIsDirty(bFlagDirty);
                break;
            }
            case 2: {
                this._obj.setBusinessPhone1(value);
                this._bbAttribs.getBbAttribute("BusinessPhone1").setIsDirty(bFlagDirty);
                break;
            }
            case 3: {
                this._obj.setBusinessFax(value);
                this._bbAttribs.getBbAttribute("BusinessFax").setIsDirty(bFlagDirty);
                break;
            }
            case 4: {
                this._obj.setMobilePhone(value);
                this._bbAttribs.getBbAttribute("MobilePhone").setIsDirty(bFlagDirty);
                break;
            }
            case 5: {
                this._obj.setHomePhone2(value);
                this._bbAttribs.getBbAttribute("HomePhone2").setIsDirty(bFlagDirty);
                break;
            }
            case 6: {
                this._obj.setBusinessPhone2(value);
                this._bbAttribs.getBbAttribute("BusinessPhone2").setIsDirty(bFlagDirty);
            }
        }
    }

    protected boolean unMarshallAddressNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("street")) {
            int numStreets;
            String streets = this._encounteredElements.get("street");
            int n = numStreets = null == streets ? 1 : Integer.parseInt(streets);
            if (numStreets == 1) {
                this._obj.setStreet1(value);
                this._bbAttribs.getBbAttribute("Street1").setIsDirty(bFlagDirty);
            } else if (numStreets == 2) {
                this._obj.setStreet2(value);
                this._bbAttribs.getBbAttribute("Street2").setIsDirty(bFlagDirty);
            }
            this._encounteredElements.put("street", String.valueOf(numStreets + 1));
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("locality")) {
            if (!this._encounteredElements.containsKey("adr")) {
                this._obj.setCity(value);
                this._bbAttribs.getBbAttribute("City").setIsDirty(bFlagDirty);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("region")) {
            if (!this._encounteredElements.containsKey("adr")) {
                this._obj.setState(value);
                this._bbAttribs.getBbAttribute("State").setIsDirty(bFlagDirty);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("pcode")) {
            if (!this._encounteredElements.containsKey("adr")) {
                this._obj.setZipCode(value);
                this._bbAttribs.getBbAttribute("ZipCode").setIsDirty(bFlagDirty);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("country")) {
            if (!this._encounteredElements.containsKey("adr")) {
                this._obj.setCountry(value);
                this._bbAttribs.getBbAttribute("Country").setIsDirty(bFlagDirty);
            }
            return true;
        }
        return false;
    }

    protected boolean unMarshallExtensionNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("x_bb_address_indicator")) {
            this._obj.setShowAddressInfo(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("ShowAddressInfo").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_available")) {
            this._obj.setIsAvailable(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("IsAvailable").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_company")) {
            this._obj.setCompany(value);
            this._bbAttribs.getBbAttribute("Company").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_contact_indicator")) {
            this._obj.setShowAddContactInfo(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("ShowAddContactInfo").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_company_department")) {
            this._obj.setDepartment(value);
            this._bbAttribs.getBbAttribute("Department").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_datasource_key")) {
            this._obj.setDataSourceBatchUid(value);
            this._bbAttribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_education_level")) {
            try {
                this._obj.setEducationLevel(this._cvUtility.stringToEducationLevel(value));
            }
            catch (ValidationException ve) {
                this._obj.setEducationLevel(User.EducationLevel.DEFAULT);
            }
            this._bbAttribs.getBbAttribute("EducationLevel").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_email_indicator")) {
            this._obj.setShowEmailInfo(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("ShowEmailInfo").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_institution_role")) {
            String szRole = this._cvUtility.intToInstitutionRoleSz(XmlUtil.parseInteger((String)value, (int)-1));
            this.updateInstitutionRole(szRole);
            this._bbAttribs.getBbAttribute("PortalRoleId").setIsDirty(bFlagDirty);
            this._bbAttribs.getBbAttribute("PortalRole").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_job_title")) {
            this._obj.setJobTitle(value);
            this._bbAttribs.getBbAttribute("JobTitle").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_password")) {
            String password = this.preparePasswordValue(value);
            this._obj.setPassword(password);
            this._bbAttribs.getBbAttribute("Password").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_public_indicator")) {
            this._obj.setIsInfoPublic(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("IsInfoPublic").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_replacementkey")) {
            this._obj.setReplacementBatchUid(value);
            this._bbAttribs.getBbAttribute("ReplacementBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_row_status")) {
            this._obj.setRowStatus(this._cvUtility.intToRowStatus(XmlUtil.parseInteger((String)value)));
            this._bbAttribs.getBbAttribute("RowStatus").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_settings")) {
            this._obj.setSettings(value);
            this._bbAttribs.getBbAttribute("Settings").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_systemrole")) {
            this._obj.setSystemRole(this._cvUtility.intToSystemRole(XmlUtil.parseInteger((String)value, (int)-1)));
            this._bbAttribs.getBbAttribute("SystemRole").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_studentid")) {
            this._obj.setStudentId(value);
            this._bbAttribs.getBbAttribute("StudentId").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_webpage")) {
            this._obj.setWebPage(value);
            this._bbAttribs.getBbAttribute("WebPage").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_embedded_source")) {
            this._obj.getBbAttributes().setString("embed", value);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_portalrole")) {
            if (this._authority.getConfigurationManager().isSOAPEnabled()) {
                this._obj.getBbAttributes().setString("StringPortalRole", value);
            } else {
                this.updateInstitutionRole(value);
                this._bbAttribs.getBbAttribute("PortalRoleId").setIsDirty(bFlagDirty);
                this._bbAttribs.getBbAttribute("PortalRole").setIsDirty(bFlagDirty);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_work_indicator")) {
            this._obj.setShowWorkInfo(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("ShowWorkInfo").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_locale")) {
            this._obj.setLocale(value);
            this._bbAttribs.getBbAttribute("Locale").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_card_number")) {
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_data_source_id")) {
            try {
                this._bbAttribs.setId("DataSourceId", Id.generateId((DataType)DataSource.DATA_TYPE, (String)value));
            }
            catch (Exception exc) {
                this._bbAttribs.setId("DataSourceId", Id.UNSET_ID);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_internal_id")) {
            try {
                this._obj.setId(Id.generateId((DataType)this._obj.getDataType(), (String)value));
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Unable to generate id for: " + value, (Throwable)exc);
            }
            return true;
        }
        return false;
    }

    private String preparePasswordValue(String password) {
        if (StringUtil.isEmpty((String)password)) {
            return password;
        }
        if (this._bEncrypt) {
            return ConversionUtility.getHashValue(password);
        }
        return password;
    }
}

