/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class TimeFormat {
    private static final String IMS_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String IMS_DATE_FORMAT = "yyyy-MM-dd";

    public static final Calendar stringToCalendar(String szDate) {
        Calendar result = TimeFormat.stringToCalendar(szDate, IMS_DATETIME_FORMAT);
        if (null == result) {
            result = TimeFormat.stringToCalendar(szDate, IMS_DATE_FORMAT);
        }
        return result;
    }

    public static final Calendar stringToCalendar(String strDate, String strFormat) {
        if (strDate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(strFormat);
        sdf.setLenient(false);
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(sdf.parse(strDate));
            return cal;
        }
        catch (Exception pe) {
            return null;
        }
    }

    public static final String calendarToString(Calendar cal) {
        return TimeFormat.calendarToString(cal, IMS_DATE_FORMAT);
    }

    public static final String calendarToString(Calendar cal, String strFormat) {
        Timestamp date = TimeFormat.calendarToTimestamp(cal);
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(strFormat);
        return sdf.format(date);
    }

    public static final Timestamp calendarToTimestamp(Calendar date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime().getTime());
    }
}

