/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.commons.io.FileUtils;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.Task;

public abstract class DBTask
implements Task {
    private String dbDriverClass;
    private String dbDriverUrl;
    private String dbUsername;
    private String dbPassword;

    @Override
    public abstract void execute() throws DeployException;

    public void setDbDriverClass(String dbDriverClass) {
        this.dbDriverClass = dbDriverClass;
    }

    public void setDbDriverUrl(String dbDriverUrl) {
        this.dbDriverUrl = dbDriverUrl;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    protected Connection getConnection() throws DeployException {
        try {
            Class.forName(this.dbDriverClass);
            return DriverManager.getConnection(this.dbDriverUrl, this.dbUsername, this.dbPassword);
        }
        catch (Exception ex) {
            throw new DeployException("Could not get connection", ex);
        }
    }

    protected String readFile(File file) throws DeployException {
        try {
            return FileUtils.readFileToString((File)file, (String)"UTF8");
        }
        catch (IOException ioex) {
            throw new DeployException("Could not read file", ioex);
        }
    }
}

