/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.util;

import com.allaire.util.IntegerParserException;
import java.text.CharacterIterator;

class IntegerParser {
    private CharacterIterator m_it;
    private int m_radix;

    private IntegerParser() {
    }

    public IntegerParser(CharacterIterator it, int radix) {
        this.m_it = it;
        this.m_radix = radix;
    }

    public int parseInt(int minLength, int maxLength) throws IntegerParserException {
        return this.parseInt(minLength, maxLength, false, '\u0000');
    }

    public int parseInt(int minLength, int maxLength, char chTerminator) throws IntegerParserException {
        return this.parseInt(minLength, maxLength, true, chTerminator);
    }

    public int parseInt(int minLength, int maxLength, boolean bCheckTerminator, char chTerminator) throws IntegerParserException {
        int nValue = 0;
        int nLen = 0;
        char c = this.m_it.current();
        while (c != '\uffff') {
            int nDigit = Character.digit(c, this.m_radix);
            if (nDigit == -1) break;
            nValue = this.m_radix * nValue + nDigit;
            this.m_it.next();
            c = this.m_it.current();
            ++nLen;
        }
        if (nLen < minLength || maxLength < nLen || bCheckTerminator && c != chTerminator) {
            throw new IntegerParserException();
        }
        return nValue;
    }
}

