/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.util;

import com.allaire.util.DuplicateColumnNameException;
import com.allaire.util.InvalidColumnIndexException;
import com.allaire.util.InvalidRowIndexException;
import com.allaire.util.NegativeRowNumberException;
import com.allaire.util.RecordSet;
import com.allaire.util.RowSizeMismatchException;
import java.util.Vector;

public class SimpleRecordSet
implements RecordSet {
    private static final int INITIAL_COLUMN_NUMBER = 8;
    private int m_colCount = 0;
    private int m_rowCount = 0;
    private String[] m_colNames = new String[8];
    private Vector[] m_colData = new Vector[8];

    public SimpleRecordSet() {
        this.m_colCount = 0;
        this.m_rowCount = 0;
        this.m_colNames = new String[8];
        this.m_colData = new Vector[8];
    }

    public SimpleRecordSet(int rows) throws NegativeRowNumberException {
        if (rows < 0) {
            throw new NegativeRowNumberException();
        }
        this.m_colCount = 0;
        this.m_rowCount = rows;
        this.m_colNames = new String[8];
        this.m_colData = new Vector[8];
    }

    public SimpleRecordSet(int rows, String[] columns) throws NegativeRowNumberException, DuplicateColumnNameException {
        if (rows < 0) {
            throw new NegativeRowNumberException();
        }
        this.m_rowCount = rows;
        this.m_colCount = 0;
        this.m_colNames = new String[columns.length];
        this.m_colData = new Vector[columns.length];
        int i = 0;
        while (i < columns.length) {
            this.addColumn(columns[i]);
            ++i;
        }
    }

    public int getRowCount() {
        return this.m_rowCount;
    }

    public int addRows(int rowsToAdd) throws NegativeRowNumberException {
        if (rowsToAdd < 0) {
            throw new NegativeRowNumberException();
        }
        int i = 0;
        while (i < this.m_colCount) {
            int j = 0;
            while (j < rowsToAdd) {
                this.m_colData[i].addElement(null);
                ++j;
            }
            ++i;
        }
        this.m_rowCount += rowsToAdd;
        return this.m_rowCount;
    }

    public int getColumnCount() {
        return this.m_colCount;
    }

    public int addColumn(String columnName) throws DuplicateColumnNameException {
        Vector columnData = new Vector(this.m_rowCount);
        columnData.setSize(this.m_rowCount);
        try {
            return this.addColumn(columnName, columnData);
        }
        catch (RowSizeMismatchException e) {
            throw new DuplicateColumnNameException();
        }
    }

    public int addColumn(String columnName, Vector columnData) throws DuplicateColumnNameException, RowSizeMismatchException {
        if (columnData.size() != this.m_rowCount) {
            throw new RowSizeMismatchException();
        }
        int colId = this.findColumn(columnName);
        if (colId != -1) {
            throw new DuplicateColumnNameException();
        }
        if (this.m_colNames.length <= this.m_colCount) {
            String[] tempColNames = new String[2 * this.m_colNames.length];
            Vector[] tempColData = new Vector[2 * this.m_colNames.length];
            int i = 0;
            while (i < this.m_colCount) {
                tempColNames[i] = this.m_colNames[i];
                tempColData[i] = this.m_colData[i];
                ++i;
            }
            this.m_colNames = tempColNames;
            this.m_colData = tempColData;
        }
        colId = this.m_colCount++;
        this.m_colNames[colId] = columnName;
        this.m_colData[colId] = columnData;
        return colId;
    }

    public int findColumn(String columnName) {
        int i = 0;
        while (i < this.m_colCount && !this.m_colNames[i].equals(columnName)) {
            ++i;
        }
        if (i != this.m_colCount) {
            return i;
        }
        return -1;
    }

    public String[] getColumnNames() {
        String[] colNames = new String[this.m_colCount];
        int i = 0;
        while (i < this.m_colCount) {
            colNames[i] = this.m_colNames[i];
            ++i;
        }
        return colNames;
    }

    public Object getField(int row, int column) throws InvalidRowIndexException, InvalidColumnIndexException {
        if (row < 0 || row >= this.m_rowCount) {
            throw new InvalidRowIndexException();
        }
        if (column < 0 || column >= this.m_colCount) {
            throw new InvalidColumnIndexException();
        }
        return this.m_colData[column].elementAt(row);
    }

    public void setField(int row, int column, Object value) throws InvalidRowIndexException, InvalidColumnIndexException {
        if (row < 0 || row >= this.m_rowCount) {
            throw new InvalidRowIndexException();
        }
        if (column < 0 || column >= this.m_colCount) {
            throw new InvalidColumnIndexException();
        }
        this.m_colData[column].setElementAt(value, row);
    }

    public String toString() {
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        String[] columnNames = this.getColumnNames();
        StringBuffer sb = new StringBuffer("[com.allaire.util.RecordSet (rows ");
        sb.append(rowCount);
        sb.append(" columns ");
        int column = 0;
        while (column < columnCount) {
            if (column > 0) {
                sb.append(", ");
            }
            sb.append(columnNames[column]);
            ++column;
        }
        sb.append("): ");
        column = 0;
        while (column < columnCount) {
            sb.append("[");
            sb.append(columnNames[column]);
            sb.append(": ");
            sb.append(this.m_colData[column].toString());
            sb.append("] ");
            ++column;
        }
        sb.append("]");
        return sb.toString();
    }
}

