/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.util.ISO8601;
import com.allaire.wddx.WddxDeserializationException;
import com.allaire.wddx.WddxElement;
import java.util.Date;

class DateTimeHandler
extends WddxElement {
    DateTimeHandler() {
    }

    public void onEndElement() throws WddxDeserializationException {
        if (this.getValue() == null) {
            this.throwException("No content for dateTime element");
        }
    }

    public void onCharacters(char[] ch, int start, int length) throws WddxDeserializationException {
        try {
            String dateString = new String(ch, start, length);
            Date dt = ISO8601.parseDate(dateString);
            if (dt == null) {
                this.throwException("invalid date string '" + dateString + "'");
            }
            this.setValue(dt);
        }
        catch (StringIndexOutOfBoundsException e) {
            this.throwException("Bad character data callback", e);
        }
    }
}

