/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.wddx.WddxObjectSerializer;
import com.allaire.wddx.WddxOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

class MapSerializer
implements WddxObjectSerializer {
    MapSerializer() {
    }

    public void writeObject(WddxOutputStream out, Object obj) throws IOException {
        try {
            if (obj != null) {
                Map m = (Map)obj;
                String type = (String)m.get("_wddx_structAttributes_type");
                if (type != null) {
                    out.writeStructBegin();
                } else {
                    out.writeStructBegin(type);
                }
                Iterator it = m.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value = m.get(key);
                    if (value == type) continue;
                    out.writeVarBegin(key.toString());
                    out.writeObject(value);
                    out.writeVarEnd();
                }
                out.writeStructEnd();
            } else {
                out.writeNull();
            }
        }
        catch (ClassCastException e) {
            throw new IOException("Invalid cast exception for map");
        }
    }
}

