/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.wddx.WddxObjectSerializerFactory;
import com.allaire.wddx.WddxOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class WddxSerializer {
    private static WddxObjectSerializerFactory m_staticSerializerFactory = new WddxObjectSerializerFactory();
    protected String m_version;
    protected WddxObjectSerializerFactory m_serializerFactory;

    public WddxSerializer() throws IllegalArgumentException {
        this.init("1.0", m_staticSerializerFactory);
    }

    public WddxSerializer(WddxObjectSerializerFactory serializerFactory) throws IllegalArgumentException {
        this.init("1.0", serializerFactory);
    }

    private void init(String version, WddxObjectSerializerFactory serializerFactory) throws IllegalArgumentException {
        if (version == null || version.compareTo("1.0") != 0) {
            throw new IllegalArgumentException("Invalid version number");
        }
        if (serializerFactory == null) {
            throw new IllegalArgumentException("Null serializer factory");
        }
        this.m_version = version;
        this.m_serializerFactory = serializerFactory;
    }

    public WddxObjectSerializerFactory getSerializerFactory() {
        return this.m_serializerFactory;
    }

    public static WddxObjectSerializerFactory getDefaultSerializerFactory() {
        return m_staticSerializerFactory;
    }

    public void serialize(Object obj, Writer out) throws NullPointerException, IOException {
        if (out == null) {
            throw new IllegalArgumentException("Null output writer");
        }
        PrintWriter pw = new PrintWriter(out);
        pw.print("<wddxPacket version='1.0'><header/><data>");
        WddxOutputStream os = new WddxOutputStream(this, pw);
        os.writeObject(obj);
        pw.print("</data></wddxPacket>");
    }
}

