/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.dao.hibernate;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class BaseDAO
extends HibernateDaoSupport
implements IBaseDAO {
    private static final String SELECT = "from ";
    private static final String UPDATE = "update ";
    private static final String DELETE = "delete ";
    private static final String WHERE = " where ";
    private static final String AND = " and ";
    private static final String SPACE = " ";
    private static final String SPOT = ".";
    private static final String EQUAL_TO_WHAT = "=?";
    private static final String LIKE_WHAT = " like ?";
    private static Logger log = Logger.getLogger(BaseDAO.class);

    @Override
    public void insert(Object object) {
        this.getHibernateTemplate().save(object);
    }

    @Override
    public void update(Object object) {
        this.getHibernateTemplate().update(object);
    }

    @Override
    public void insertOrUpdate(Object object) {
        this.getHibernateTemplate().saveOrUpdate(object);
    }

    @Override
    public void insertOrUpdateAll(Collection objects) {
        this.getHibernateTemplate().saveOrUpdateAll(objects);
    }

    @Override
    public void update(String queryString) {
        this.getHibernateTemplate().bulkUpdate(queryString);
    }

    @Override
    public void update(String queryString, Object value) {
        this.getHibernateTemplate().bulkUpdate(queryString, value);
    }

    @Override
    public void update(String queryString, Object[] values) {
        this.getHibernateTemplate().bulkUpdate(queryString, values);
    }

    @Override
    public void update(Class clazz, String propertyToChange, Object newValue, String conditionProperty, Object conditionValue) {
    }

    @Override
    public void update(Class clazz, String propertyToChange, Object newValue, Map<String, Object> conditions) {
    }

    @Override
    public void update(Class clazz, Map<String, Object> newValues, String conditionProperty, Object conditionValue) {
    }

    @Override
    public void update(Class clazz, Map<String, Object> newValues, Map<String, Object> conditions) {
    }

    @Override
    public void updateAnythingLike(Class clazz, Object newValues, Object conditions) {
    }

    @Override
    public void delete(Object object) {
        this.getHibernateTemplate().delete(object);
    }

    @Override
    public void deleteAll(Class clazz) {
        String queryString = this.buildQueryString(clazz, DELETE);
        this.getHibernateTemplate().bulkUpdate(queryString);
    }

    @Override
    public void deleteAll(Collection objects) {
        this.getHibernateTemplate().deleteAll(objects);
    }

    @Override
    public void deleteById(Class clazz, Serializable id) {
        this.delete(this.find(clazz, id));
    }

    @Override
    public void deleteByProperty(Class clazz, String name, Object value) {
        String queryString = this.buildQueryString(clazz, name, DELETE);
        this.getHibernateTemplate().bulkUpdate(queryString, value);
    }

    @Override
    public void deleteByProperties(Class clazz, Map<String, Object> properties) {
        Qv qv = this.buildQueryString(clazz, properties, DELETE, EQUAL_TO_WHAT);
        this.getHibernateTemplate().bulkUpdate(qv.queryString, qv.values);
    }

    @Override
    public void deleteAnythingLike(Object object) {
        try {
            Qv qv = this.buildQueryString(object, DELETE);
            this.getHibernateTemplate().bulkUpdate(qv.queryString, qv.values);
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    @Override
    public Object find(Class clazz, Serializable id) {
        return this.getHibernateTemplate().get(clazz, id);
    }

    @Override
    public List findAll(Class clazz) {
        return this.getHibernateTemplate().loadAll(clazz);
    }

    @Override
    public List findByProperty(Class clazz, String name, Object value) {
        String queryString = this.buildQueryString(clazz, name, SELECT);
        return this.getHibernateTemplate().find(queryString, value);
    }

    @Override
    public List findByProperties(Class clazz, Map<String, Object> properties) {
        Qv qv = this.buildQueryString(clazz, properties, SELECT, EQUAL_TO_WHAT);
        return this.getHibernateTemplate().find(qv.queryString, qv.values);
    }

    @Override
    public List findAnythingLike(Object object) {
        return this.getHibernateTemplate().findByExample(object);
    }

    private String buildQueryString(Class clazz, String operation) {
        StringBuffer queryString = new StringBuffer(operation).append(clazz.getSimpleName());
        return queryString.toString();
    }

    private String buildQueryString(Class clazz, String name, String operation) {
        String clazzName = clazz.getSimpleName();
        String objName = this.createObjectName(clazzName);
        StringBuffer queryString = new StringBuffer(operation).append(clazzName).append(SPACE).append(objName).append(WHERE).append(objName).append(SPOT).append(name).append(EQUAL_TO_WHAT);
        return queryString.toString();
    }

    @Override
    public List find(String queryString) {
        return this.getHibernateTemplate().find(queryString);
    }

    @Override
    public List find(String queryString, Object value) {
        return this.getHibernateTemplate().find(queryString, value);
    }

    @Override
    public List find(String queryString, Object[] values) {
        return this.getHibernateTemplate().find(queryString, values);
    }

    @Override
    public List findByNamedQuery(String queryName) {
        return this.getHibernateTemplate().findByNamedQuery(queryName);
    }

    @Override
    public List findByNamedQuery(String queryName, Object value) {
        return this.getHibernateTemplate().findByNamedQuery(queryName, value);
    }

    @Override
    public List findByNamedQuery(String queryName, Object[] values) {
        return this.getHibernateTemplate().findByNamedQuery(queryName, values);
    }

    @Override
    public List searchByStringProperty(Class clazz, String name, String pattern) {
        return null;
    }

    @Override
    public List searchByStringProperties(Class clazz, Map<String, String> properties) {
        HashMap<String, Object> p = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            p.put(entry.getKey(), entry.getValue());
        }
        Qv qv = this.buildQueryString(clazz, p, SELECT, LIKE_WHAT);
        return this.getHibernateTemplate().find(qv.queryString, qv.values);
    }

    @Override
    public List searchByNumberSpan(Class clazz, String name, Integer min, Boolean minIncluded, Integer max, Boolean maxIncluded) {
        return null;
    }

    private Qv buildQueryString(Class clazz, Map<String, Object> properties, String operation, String condition) {
        String clazzName = clazz.getSimpleName();
        String objName = this.createObjectName(clazzName);
        StringBuffer queryString = new StringBuffer(operation).append(clazzName).append(SPACE).append(objName).append(WHERE);
        Object[] values = new Object[properties.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            queryString.append(objName).append(SPOT).append(entry.getKey()).append(condition);
            if (i != properties.size() - 1) {
                queryString.append(AND);
            }
            values[i] = entry.getValue();
            ++i;
        }
        return new Qv(queryString.toString(), values);
    }

    private Qv buildQueryString(Object obj, String operation) throws Exception {
        String clazzName = obj.getClass().getSimpleName();
        String objName = this.createObjectName(clazzName);
        StringBuffer queryString = new StringBuffer(operation).append(clazzName).append(SPACE).append(objName).append(WHERE);
        Field[] fields = obj.getClass().getDeclaredFields();
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            Method readMethod = this.getReadMethod(fields[i], name, obj.getClass());
            Object value = readMethod.invoke(obj, new Object[0]);
            if (value == null) continue;
            queryString.append(objName).append(SPOT).append(name).append(EQUAL_TO_WHAT);
            if (i != fields.length - 1) {
                queryString.append(AND);
            }
            values.add(value);
        }
        return new Qv(queryString.toString(), values.toArray());
    }

    private Method getReadMethod(Field field, String fieldName, Class clazz) throws Exception {
        String convertedName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        if (field.getType().getSimpleName().equals("Boolean")) {
            return clazz.getDeclaredMethod("is" + convertedName, new Class[0]);
        }
        return clazz.getDeclaredMethod("get" + convertedName, new Class[0]);
    }

    private String createObjectName(String clazzName) {
        return clazzName.substring(0, 1).toLowerCase();
    }

    @Override
    public void initialize(Object proxy) {
        this.getHibernateTemplate().initialize(proxy);
    }

    @Override
    public long countAll(Class clazz) {
        String query = "select count(*) from " + clazz.getSimpleName();
        List list = this.getHibernateTemplate().find(query);
        if (list != null && list.size() > 0) {
            return (Long)list.get(0);
        }
        return 0L;
    }

    @Override
    public long countByProperties(Class clazz, Map<String, Object> properties) {
        Qv qv = this.buildQueryString(clazz, properties, SELECT, EQUAL_TO_WHAT);
        String query = "select count(*) " + qv.queryString;
        List list = this.getHibernateTemplate().find(query, qv.values);
        if (list != null && list.size() > 0) {
            return (Long)list.get(0);
        }
        return 0L;
    }

    private static class Qv {
        String queryString;
        Object[] values;

        Qv(String queryString, Object[] values) {
            this.queryString = queryString;
            this.values = values;
        }
    }
}

