/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.events.AbstractDeliveryMethod;
import org.lamsfoundation.lams.events.EventNotificationService;
import org.lamsfoundation.lams.events.Subscription;

public class Event {
    private Long uid;
    protected String name;
    protected String scope;
    protected Long eventSessionId;
    protected Boolean triggered = false;
    protected Set<Subscription> subscriptions = new HashSet<Subscription>();
    protected String defaultMessage;
    protected String defaultSubject;
    protected String message;
    protected String subject;
    protected boolean htmlFormat;
    protected Date failTime;
    protected String fullSignature;
    protected int referenceCounter;
    protected Thread notificationThread;
    protected boolean deleted;

    public Event() {
    }

    public Event(String scope, String name, Long sessionId, String defaultSubject, String defaultMessage, boolean isHtmlContentType) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Event scope can not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Event name can not be blank.");
        }
        this.scope = scope;
        this.name = name;
        this.eventSessionId = sessionId;
        this.defaultSubject = defaultSubject;
        this.defaultMessage = defaultMessage;
        this.htmlFormat = isHtmlContentType;
        this.fullSignature = Event.createFullSignature(scope, name, sessionId);
    }

    protected static String createFullSignature(String scope, String name, Long sessionId) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        return scope + '_' + name + (sessionId == null ? "" : "_" + sessionId);
    }

    public Object clone() {
        Event clone = new Event(this.scope, this.name, this.eventSessionId, this.defaultSubject, this.defaultMessage, this.htmlFormat);
        for (Subscription subscription : this.getSubscriptions()) {
            clone.getSubscriptions().add((Subscription)subscription.clone());
        }
        return clone;
    }

    public boolean equals(Object o) {
        return o instanceof Event && ((Event)o).getFullSignature().equalsIgnoreCase(this.getFullSignature()) || o instanceof CharSequence && ((Object)((CharSequence)o)).toString().equalsIgnoreCase(this.getFullSignature());
    }

    public int hashCode() {
        return this.getFullSignature().hashCode();
    }

    protected String getDefaultMessage() {
        return this.defaultMessage;
    }

    protected String getDefaultSubject() {
        return this.defaultSubject;
    }

    protected String getFullSignature() {
        if (this.fullSignature == null) {
            this.fullSignature = Event.createFullSignature(this.getScope(), this.getName(), this.getEventSessionId());
        }
        return this.fullSignature;
    }

    protected String getName() {
        return this.name;
    }

    protected String getScope() {
        return this.scope;
    }

    protected Long getEventSessionId() {
        return this.eventSessionId;
    }

    protected Set<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    protected Long getUid() {
        return this.uid;
    }

    protected boolean isTriggered() {
        return this.triggered;
    }

    protected boolean triggerForSingleUser(Long userId, String subject, String message) throws InvalidParameterException {
        if (userId == null) {
            throw new InvalidParameterException("User ID can not be null.");
        }
        ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>(this.getSubscriptions());
        for (int index = 0; index < subscriptionList.size(); ++index) {
            Subscription subscription = (Subscription)subscriptionList.get(index);
            if (!subscription.getUserId().equals(userId) || !subscription.isEligibleForNotification()) continue;
            subscription.notifyUser(subject, message, this.isHtmlFormat());
            return subscription.getLastOperationSuccessful();
        }
        return false;
    }

    protected void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    protected void setDefaultSubject(String defaultSubject) {
        this.defaultSubject = defaultSubject;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setScope(String scope) {
        this.scope = scope;
    }

    protected void setEventSessionId(Long sessionId) {
        this.eventSessionId = sessionId;
    }

    protected void setSubscriptions(Set<Subscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    protected void setTriggered(boolean triggered) {
        this.triggered = triggered;
    }

    protected void setUid(Long uid) {
        this.uid = uid;
    }

    protected boolean subscribe(Long userId, AbstractDeliveryMethod deliveryMethod, Long periodicity) throws InvalidParameterException {
        if (userId == null) {
            throw new InvalidParameterException("User ID can not be null.");
        }
        if (deliveryMethod == null) {
            throw new InvalidParameterException("Delivery method can not be null.");
        }
        boolean substriptionFound = false;
        Subscription toSubscribe = new Subscription(userId, deliveryMethod, periodicity);
        ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>(this.getSubscriptions());
        for (int index = 0; index < subscriptionList.size(); ++index) {
            Subscription subscription = (Subscription)subscriptionList.get(index);
            if (!subscription.equals(toSubscribe)) continue;
            substriptionFound = true;
            if (subscription.getPeriodicity().equals(periodicity)) continue;
            subscription.setPeriodicity(periodicity);
        }
        if (!substriptionFound) {
            this.getSubscriptions().add(new Subscription(userId, deliveryMethod, periodicity));
            return true;
        }
        return false;
    }

    protected void trigger(String subject, String message) {
        if (this.notificationThread == null || !this.notificationThread.isAlive()) {
            this.triggered = true;
            if (subject != null && subject.equals(this.getDefaultSubject())) {
                this.setSubject(null);
            } else {
                this.setSubject(subject);
            }
            if (message != null && message.equals(this.getDefaultMessage())) {
                this.setMessage(null);
            } else {
                this.setMessage(message);
            }
            final String subjectToSend = this.getSubject() == null ? this.getDefaultSubject() : this.getSubject();
            final String messageToSend = this.getMessage() == null ? this.getDefaultMessage() : this.getMessage();
            final boolean isHtmlContentType = this.isHtmlFormat();
            final Event finalRef = this;
            this.notificationThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>(Event.this.getSubscriptions());
                    Event eventFailCopy = null;
                    for (int index = 0; index < subscriptionList.size(); ++index) {
                        Subscription subscription = (Subscription)subscriptionList.get(index);
                        if (Event.this.getFailTime() == null && !subscription.isEligibleForNotification()) continue;
                        subscription.notifyUser(subjectToSend, messageToSend, isHtmlContentType);
                        if (subscription.getLastOperationSuccessful()) {
                            if (Event.this.getFailTime() == null) continue;
                            Event.this.getSubscriptions().remove(subscription);
                            continue;
                        }
                        if (Event.this.getFailTime() != null) continue;
                        if (eventFailCopy == null) {
                            eventFailCopy = (Event)finalRef.clone();
                            ++eventFailCopy.referenceCounter;
                            eventFailCopy.getSubscriptions().clear();
                        }
                        eventFailCopy.subscribe(subscription.getUserId(), subscription.getDeliveryMethod(), subscription.getPeriodicity());
                    }
                    EventNotificationService.getInstance().saveEvent(finalRef);
                    if (eventFailCopy != null && !eventFailCopy.getSubscriptions().isEmpty()) {
                        eventFailCopy.setFailTime(new Date());
                        eventFailCopy.setDefaultSubject(subjectToSend);
                        eventFailCopy.setDefaultMessage(messageToSend);
                        eventFailCopy.setTriggered(true);
                        EventNotificationService.getInstance().saveEvent(eventFailCopy);
                    }
                }
            }, "LAMS_" + this.getFullSignature() + "_notification_thread");
            this.notificationThread.start();
        }
    }

    protected boolean unsubscribe(Long userId) throws InvalidParameterException {
        if (userId == null) {
            throw new InvalidParameterException("User ID can not be null.");
        }
        ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>(this.getSubscriptions());
        boolean subscriptionFound = false;
        for (int index = 0; index < subscriptionList.size(); ++index) {
            Subscription subscription = (Subscription)subscriptionList.get(index);
            if (!subscription.getUserId().equals(userId)) continue;
            this.getSubscriptions().remove(subscription);
            subscriptionFound = true;
        }
        return subscriptionFound;
    }

    protected boolean unsubscribe(Long userId, AbstractDeliveryMethod deliveryMethod) throws InvalidParameterException {
        if (userId == null) {
            throw new InvalidParameterException("User ID can not be null.");
        }
        if (deliveryMethod == null) {
            throw new InvalidParameterException("Delivery method can not be null.");
        }
        ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>(this.getSubscriptions());
        for (int index = 0; index < subscriptionList.size(); ++index) {
            Subscription subscription = (Subscription)subscriptionList.get(index);
            if (!subscription.getUserId().equals(userId) || !subscription.getDeliveryMethod().equals(deliveryMethod)) continue;
            this.getSubscriptions().remove(subscription);
            return true;
        }
        return false;
    }

    protected Date getFailTime() {
        return this.failTime;
    }

    protected void setFailTime(Date failTime) {
        this.failTime = failTime;
    }

    protected String getMessage() {
        return this.message;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    protected String getSubject() {
        return this.subject;
    }

    protected void setSubject(String subject) {
        this.subject = subject;
    }

    protected boolean isHtmlFormat() {
        return this.htmlFormat;
    }

    protected void setHtmlFormat(boolean isHtmlContentType) {
        this.htmlFormat = isHtmlContentType;
    }
}

