/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events;

import java.util.List;
import org.lamsfoundation.lams.events.DeliveryMethodMail;
import org.lamsfoundation.lams.events.Event;
import org.lamsfoundation.lams.events.EventNotificationService;
import org.lamsfoundation.lams.events.IEventNotificationService;
import org.lamsfoundation.lams.events.Subscription;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.MessageService;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ResendMessagesJob
extends QuartzJobBean {
    private static final long RESEND_TIME_LIMIT = 172800000L;
    private static final EventNotificationService notificationService = EventNotificationService.getInstance();
    private static final MessageService messageService = notificationService.getMessageService();

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        try {
            EventNotificationService.log.debug((Object)"Event notification service is running a resend messages thread...");
            List<Event> events = notificationService.getEventDAO().getEventsToResend();
            for (Event event : events) {
                block7: {
                    block5: {
                        block6: {
                            ++event.referenceCounter;
                            if (event.getFailTime() == null) break block5;
                            event.trigger(event.getSubject(), event.getMessage());
                            event.notificationThread.join();
                            if (!event.getSubscriptions().isEmpty()) break block6;
                            event.deleted = true;
                            break block7;
                        }
                        if (System.currentTimeMillis() - event.getFailTime().getTime() < 172800000L) break block7;
                        event.deleted = true;
                        StringBuilder body = new StringBuilder(messageService.getMessage("mail.resend.abandon.body1")).append(event.getDefaultMessage()).append(messageService.getMessage("mail.resend.abandon.body2"));
                        for (Subscription subscription : event.getSubscriptions()) {
                            User user = (User)EventNotificationService.getInstance().getUserManagementService().findById(User.class, Integer.valueOf(subscription.getUserId().intValue()));
                            body.append(user.getLogin()).append('\n');
                        }
                        ((DeliveryMethodMail)IEventNotificationService.DELIVERY_METHOD_MAIL).notifyAdmin(messageService.getMessage("mail.resend.abandon.subject"), body.toString(), event.isHtmlFormat());
                        break block7;
                    }
                    for (Subscription subscription : event.getSubscriptions()) {
                        if (subscription.getLastOperationTime() == null || System.currentTimeMillis() - subscription.getLastOperationTime().getTime() <= subscription.getPeriodicity()) continue;
                        String subject = event.getSubject() == null ? event.getDefaultSubject() : event.getSubject();
                        String message = event.getMessage() == null ? event.getDefaultMessage() : event.getMessage();
                        boolean isHtmlFormat = event.isHtmlFormat();
                        subscription.notifyUser(subject, message, isHtmlFormat);
                    }
                }
                notificationService.saveEvent(event);
            }
        }
        catch (Exception e) {
            throw new JobExecutionException(e.getMessage());
        }
    }
}

