/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;

public class ImportExportUtil {
    protected static Logger log = Logger.getLogger(ImportExportUtil.class);
    private static final String ENC_CIPHER_ALGORITHM = "DES/CBC/PKCS5Padding";
    private static final String ENCODED_KEY_BASE64 = "emEjkQfjGZs=";
    private static final String KEY_IV_BASE64 = "AToFlf/Ue40=";
    private static Key secretKey = null;
    private static AlgorithmParameterSpec algorithmParameterSpec = null;

    public static String generateUniqueLDTitle(WorkspaceFolder folder, String titleFromFile, ILearningDesignDAO learningDesignDAO) {
        String newTitle = titleFromFile;
        if (newTitle == null || newTitle.length() == 0) {
            newTitle = "unknown";
        }
        if (folder != null) {
            List ldList = learningDesignDAO.getAllLearningDesignsInFolder(folder.getWorkspaceFolderId());
            int idx = 1;
            Calendar calendar = Calendar.getInstance();
            int mth = calendar.get(2) + 1;
            String mthStr = new Integer(mth).toString();
            if (mth < 10) {
                mthStr = "0" + mthStr;
            }
            int day = calendar.get(5);
            String dayStr = new Integer(day).toString();
            if (day < 10) {
                dayStr = "0" + dayStr;
            }
            String nameMid = dayStr + mthStr + calendar.get(1);
            while (true) {
                boolean dupName = false;
                for (LearningDesign eld : ldList) {
                    if (!StringUtils.equals((String)eld.getTitle(), (String)newTitle)) continue;
                    dupName = true;
                    break;
                }
                if (!dupName) break;
                newTitle = titleFromFile + "_" + nameMid + "_" + idx;
                ++idx;
            }
        }
        return newTitle;
    }

    private static synchronized void initialiseDecryption() throws GeneralSecurityException {
        if (secretKey == null) {
            byte[] encodedKey = Base64.decodeBase64((byte[])ENCODED_KEY_BASE64.getBytes());
            byte[] keyIv = Base64.decodeBase64((byte[])KEY_IV_BASE64.getBytes());
            DESKeySpec desKeySpec = new DESKeySpec(encodedKey);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("DES");
            secretKey = factory.generateSecret(desKeySpec);
            algorithmParameterSpec = new IvParameterSpec(keyIv);
        }
    }

    public static String decryptImport(String fileContent) throws GeneralSecurityException {
        ImportExportUtil.initialiseDecryption();
        int start = fileContent.indexOf("<CipherValue>") + 13;
        int end = fileContent.indexOf("</CipherValue>");
        String cipherValue = fileContent.substring(start, end);
        log.debug((Object)("  cipherValue= " + cipherValue));
        byte[] encryptedBytes = Base64.decodeBase64((byte[])cipherValue.getBytes());
        String decrypted = ImportExportUtil.getDecrypted(encryptedBytes);
        log.debug((Object)("  cipherValue= " + decrypted));
        return decrypted;
    }

    private static String getDecrypted(byte[] encryptedBytes) throws SecurityException {
        try {
            Cipher cipher = Cipher.getInstance(ENC_CIPHER_ALGORITHM);
            cipher.init(2, secretKey, algorithmParameterSpec);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            return new String(decryptedBytes);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new SecurityException(e.getMessage());
        }
    }
}

