/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningLibraryDTO;
import org.lamsfoundation.lams.learningdesign.dto.LibraryActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.learningdesign.service.LearningDesignValidator;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.ILoadedMessageSourceService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.svg.SVGGenerator;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class LearningDesignService
implements ILearningDesignService {
    protected Logger log = Logger.getLogger(LearningDesignService.class);
    protected MessageService messageService;
    protected LearningDesignDAO learningDesignDAO;
    protected ActivityDAO activityDAO;
    protected GroupingDAO groupingDAO;
    protected LearningLibraryDAO learningLibraryDAO;
    protected ILoadedMessageSourceService toolActMessageService;

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public ILoadedMessageSourceService getToolActMessageService() {
        return this.toolActMessageService;
    }

    public void setToolActMessageService(ILoadedMessageSourceService toolActMessageService) {
        this.toolActMessageService = toolActMessageService;
    }

    public void setLearningLibraryDAO(LearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public void setActivityDAO(ActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setLearningDesignDAO(LearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setGroupingDAO(GroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    @Override
    public LearningDesignDTO getLearningDesignDTO(Long learningDesignID, String languageCode) {
        LearningDesign design = learningDesignID != null ? this.learningDesignDAO.getLearningDesignById(learningDesignID) : null;
        return design != null ? new LearningDesignDTO(design, this.activityDAO, this.groupingDAO, languageCode) : null;
    }

    @Override
    public Vector<ValidationErrorDTO> validateLearningDesign(LearningDesign learningDesign) {
        LearningDesignValidator validator = new LearningDesignValidator(learningDesign, this.messageService);
        return validator.validate();
    }

    @Override
    public void setValid(Long learningLibraryId, boolean valid) {
        LearningLibrary library = this.learningLibraryDAO.getLearningLibraryById(learningLibraryId);
        library.setValidLibrary(valid);
        this.learningLibraryDAO.update(library);
    }

    @Override
    public ArrayList<LearningLibraryDTO> getAllLearningLibraryDetails(String languageCode) throws IOException {
        return this.getAllLearningLibraryDetails(true, languageCode);
    }

    @Override
    public ArrayList<LearningLibraryDTO> getAllLearningLibraryDetails(boolean valid, String languageCode) throws IOException {
        Iterator iterator = this.learningLibraryDAO.getAllLearningLibraries(valid).iterator();
        ArrayList<LearningLibraryDTO> libraries = new ArrayList<LearningLibraryDTO>();
        while (iterator.hasNext()) {
            LearningLibrary learningLibrary = (LearningLibrary)iterator.next();
            List templateActivities = this.activityDAO.getActivitiesByLibraryID(learningLibrary.getLearningLibraryId());
            if (templateActivities != null & templateActivities.size() == 0) {
                this.log.error((Object)("Learning Library with ID " + learningLibrary.getLearningLibraryId() + " does not have a template activity"));
            }
            LearningLibraryDTO libraryDTO = learningLibrary.getLearningLibraryDTO(templateActivities, languageCode);
            this.internationaliseActivities(libraryDTO.getTemplateActivities());
            libraries.add(libraryDTO);
        }
        return libraries;
    }

    @Override
    public String createBranchingSVG(Long branchingActivityId, int imageFormat) throws IOException {
        BranchingActivity branchingActivity = (BranchingActivity)this.activityDAO.getActivityByActivityId(branchingActivityId);
        Long learningDesignId = branchingActivity.getLearningDesign().getLearningDesignId();
        return this.createDesignSVG(learningDesignId, branchingActivityId, imageFormat);
    }

    @Override
    public String createLearningDesignSVG(Long learningDesignId, int imageFormat) throws IOException {
        return this.createDesignSVG(learningDesignId, null, imageFormat);
    }

    private void internationaliseActivities(Collection activities) {
        Iterator iter = activities.iterator();
        Locale locale = LocaleContextHolder.getLocale();
        if (this.log.isDebugEnabled()) {
            if (locale != null) {
                this.log.debug((Object)("internationaliseActivities: Locale has lang/country " + locale.getLanguage() + "," + locale.getCountry()));
            } else {
                this.log.debug((Object)"internationaliseActivities: Locale missing.");
            }
        }
        while (iter.hasNext()) {
            LibraryActivityDTO activity = (LibraryActivityDTO)iter.next();
            String languageFilename = activity.getLanguageFile();
            if (languageFilename != null) {
                MessageSource toolMessageSource = this.toolActMessageService.getMessageService(languageFilename);
                if (toolMessageSource != null) {
                    activity.setActivityTitle(toolMessageSource.getMessage("activity.title", null, activity.getActivityTitle(), locale));
                    activity.setDescription(toolMessageSource.getMessage("activity.description", null, activity.getDescription(), locale));
                    activity.setHelpText(toolMessageSource.getMessage("activity.helptext", null, activity.getHelpText(), locale));
                } else {
                    this.log.warn((Object)("Unable to internationalise the library activity " + activity.getActivityID() + " " + activity.getActivityTitle() + " message file " + activity.getLanguageFile() + ". Activity Message source not available"));
                }
                if (activity.getActivityTypeID() == null || 1 != activity.getActivityTypeID()) continue;
                languageFilename = activity.getToolLanguageFile();
                toolMessageSource = this.toolActMessageService.getMessageService(languageFilename);
                if (toolMessageSource != null) {
                    activity.setToolDisplayName(toolMessageSource.getMessage("tool.display.name", null, activity.getToolDisplayName(), locale));
                    continue;
                }
                this.log.warn((Object)("Unable to internationalise the library activity " + activity.getActivityID() + " " + activity.getActivityTitle() + " message file " + activity.getLanguageFile() + ". Tool Message source not available"));
                continue;
            }
            this.log.warn((Object)("Unable to internationalise the library activity " + activity.getActivityID() + " " + activity.getActivityTitle() + ". No message file supplied."));
        }
    }

    private String createDesignSVG(Long learningDesignId, Long branchingActivityId, int imageFormat) throws IOException, FileNotFoundException {
        String earFolder;
        String fileNameWithoutExtension = learningDesignId.toString();
        if (branchingActivityId != null) {
            fileNameWithoutExtension = fileNameWithoutExtension + "_branching" + branchingActivityId;
        }
        if (StringUtils.isBlank((String)(earFolder = Configuration.get(ConfigurationKeys.LAMS_EAR_DIR)))) {
            this.log.error((Object)"Unable to get path to the LAMS Server URL from the configuration table. SVG image creation failed");
            return null;
        }
        String directoryToStoreFile = FileUtil.getFullPath(earFolder, "lams-www.war\\secure\\learning-design-images");
        File svgPngDirectory = new File(directoryToStoreFile);
        if (!svgPngDirectory.exists()) {
            svgPngDirectory.mkdirs();
        }
        String fileExtension = imageFormat == 1 || imageFormat == 4 ? ".svg" : ".png";
        String absoluteFilePath = FileUtil.getFullPath(directoryToStoreFile, fileNameWithoutExtension + fileExtension);
        File file = new File(absoluteFilePath);
        LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignId);
        boolean isSvgOutdated = new Date(file.lastModified()).before(learningDesign.getLastModifiedDateTime());
        if (!file.exists() || isSvgOutdated) {
            SVGGenerator svgGenerator = new SVGGenerator();
            LearningDesignDTO ldDto = this.getLearningDesignDTO(learningDesignId, "");
            if (branchingActivityId == null) {
                svgGenerator.generateLearningDesignDOM(ldDto, imageFormat);
            } else {
                svgGenerator.generateBranchingDOM(ldDto, branchingActivityId, imageFormat);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            svgGenerator.streamOutDocument(fileOutputStream);
        }
        return absoluteFilePath;
    }
}

