/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.lamsfoundation.lams.util.ExcelCell;

public class ExcelUtil {
    private static CellStyle boldStyle;

    public static void createExcel(OutputStream out, LinkedHashMap<String, ExcelCell[][]> dataToExport, String dateHeader, boolean displaySheetTitle) throws IOException {
        SXSSFWorkbook workbook = new SXSSFWorkbook(100);
        boldStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setBoldweight((short)700);
        boldStyle.setFont(font);
        int i = 0;
        for (String sheetName : dataToExport.keySet()) {
            if (dataToExport.get(sheetName) == null) continue;
            String sheetTitle = displaySheetTitle ? sheetName : null;
            ExcelUtil.createSheet((Workbook)workbook, sheetName, sheetTitle, i, dateHeader, dataToExport.get(sheetName));
            ++i;
        }
        workbook.write(out);
        out.close();
    }

    public static void createSheet(Workbook workbook, String sheetName, String sheetTitle, int sheetIndex, String dateHeader, ExcelCell[][] data) throws IOException {
        Row row;
        Sheet sheet = workbook.createSheet(sheetName);
        if (!StringUtils.isBlank((String)sheetTitle)) {
            row = sheet.createRow(0);
            ExcelUtil.createCell(new ExcelCell(sheetTitle, true), 0, row);
        }
        if (!StringUtils.isBlank((String)dateHeader)) {
            row = sheet.createRow(1);
            ExcelUtil.createCell(new ExcelCell(dateHeader, false), 0, row);
            SimpleDateFormat titleDateFormat = new SimpleDateFormat("dd.MM.yyyy h a");
            ExcelUtil.createCell(new ExcelCell(titleDateFormat.format(new Date()), false), 1, row);
        }
        if (data != null) {
            for (int rowIndex = 0; rowIndex < data.length; ++rowIndex) {
                int rowIndexOffset = StringUtils.isBlank((String)sheetTitle) && StringUtils.isBlank((String)dateHeader) ? 0 : 4;
                Row row2 = sheet.createRow(rowIndex + rowIndexOffset);
                for (int columnIndex = 0; columnIndex < data[rowIndex].length; ++columnIndex) {
                    ExcelCell excelCell = data[rowIndex][columnIndex];
                    ExcelUtil.createCell(excelCell, columnIndex, row2);
                }
            }
        }
    }

    public static void createCell(ExcelCell excelCell, int cellnum, Row row) {
        if (excelCell != null) {
            Cell cell = row.createCell(cellnum);
            if (excelCell.getCellValue() != null && excelCell.getCellValue() instanceof Date) {
                SimpleDateFormat cellDateFormat = new SimpleDateFormat("dd.MM.yyyy");
                cell.setCellValue(cellDateFormat.format(excelCell.getCellValue()));
            } else if (excelCell.getCellValue() != null && excelCell.getCellValue() instanceof Double) {
                cell.setCellValue(((Double)excelCell.getCellValue()).doubleValue());
            } else if (excelCell.getCellValue() != null && excelCell.getCellValue() instanceof Long) {
                cell.setCellValue(((Long)excelCell.getCellValue()).doubleValue());
            } else if (excelCell.getCellValue() != null) {
                cell.setCellValue(excelCell.getCellValue().toString());
            }
            if (excelCell.getIsBold().booleanValue()) {
                cell.setCellStyle(boldStyle);
            }
        }
    }
}

