/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.dto;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.Vector;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;
import org.lamsfoundation.lams.workspace.WorkspaceFolderContent;

public class FolderContentDTO {
    public static final String LESSON = "Lesson";
    public static final String DESIGN = "LearningDesign";
    public static final String FOLDER = "Folder";
    public static final String FILE = "File";
    public String name;
    public String description;
    public Date creationDateTime;
    public Date lastModifiedDateTime;
    public String formattedLastModifiedDateTime;
    public String resourceType;
    public Long resourceTypeID;
    public Long resourceID;
    public Integer permissionCode;
    public Vector versionDetails;
    public Long licenseID;
    public String licenseText;
    public Boolean readOnly;
    public String author;
    public String originalAuthor;

    public FolderContentDTO() {
    }

    public FolderContentDTO(String name, String description, Date creationDateTime, Date lastModifiedDateTime, String resourceType, Long resourceID, Integer permissionCode, Long licenseID) {
        this.name = name;
        this.description = description;
        this.creationDateTime = creationDateTime;
        this.lastModifiedDateTime = lastModifiedDateTime;
        this.resourceType = resourceType;
        this.resourceID = resourceID;
        this.permissionCode = permissionCode;
        this.licenseID = licenseID;
        this.versionDetails = null;
        this.readOnly = false;
    }

    public FolderContentDTO(LearningDesign design, Integer permissionCode, User user) {
        this.name = design.getTitle();
        this.description = design.getDescription();
        this.creationDateTime = design.getCreateDateTime();
        this.lastModifiedDateTime = design.getLastModifiedDateTime();
        this.formattedLastModifiedDateTime = this.formatLastModifiedDateTime(TimeZone.getTimeZone(user.getTimeZone()));
        this.resourceType = DESIGN;
        this.resourceID = design.getLearningDesignId();
        this.permissionCode = permissionCode;
        this.licenseID = design.getLicense() != null ? design.getLicense().getLicenseID() : null;
        this.licenseText = design.getLicenseText();
        this.versionDetails = null;
        this.readOnly = design.getReadOnly();
        this.author = design.getUser().getFullName();
        this.originalAuthor = design.getOriginalUser() == null ? null : design.getOriginalUser().getFullName();
    }

    public FolderContentDTO(WorkspaceFolder workspaceFolder, Integer permissionCode, User user) {
        this.name = workspaceFolder.getName();
        this.description = FOLDER;
        this.creationDateTime = workspaceFolder.getCreationDate();
        this.lastModifiedDateTime = workspaceFolder.getLastModifiedDate();
        this.formattedLastModifiedDateTime = this.formatLastModifiedDateTime(TimeZone.getTimeZone(user.getTimeZone()));
        this.resourceType = FOLDER;
        this.resourceTypeID = new Long(workspaceFolder.getWorkspaceFolderType().intValue());
        this.resourceID = new Long(workspaceFolder.getWorkspaceFolderId().intValue());
        this.permissionCode = permissionCode;
        this.licenseID = null;
        this.versionDetails = null;
        this.readOnly = Boolean.FALSE;
    }

    public FolderContentDTO(Integer permissionCode, WorkspaceFolderContent workspaceFolderContent, SortedSet details, User user) {
        this.name = workspaceFolderContent.getName();
        this.description = workspaceFolderContent.getDescription();
        this.creationDateTime = workspaceFolderContent.getCreateDate();
        this.lastModifiedDateTime = workspaceFolderContent.getLastModified();
        this.formattedLastModifiedDateTime = this.formatLastModifiedDateTime(TimeZone.getTimeZone(user.getTimeZone()));
        this.resourceID = workspaceFolderContent.getFolderContentID();
        this.permissionCode = permissionCode;
        this.resourceType = workspaceFolderContent.getContentTypeID().equals(WorkspaceFolderContent.CONTENT_TYPE_FILE) ? FILE : FOLDER;
        this.licenseID = null;
        this.versionDetails = new Vector();
        this.versionDetails.addAll(details);
        this.readOnly = Boolean.FALSE;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime != null ? this.creationDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public String getDescription() {
        return this.description != null ? this.description : "string_null_value";
    }

    public Date getLastModifiedDateTime() {
        return this.lastModifiedDateTime != null ? this.lastModifiedDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public String getFormattedLastModifiedDateTime() {
        return this.formattedLastModifiedDateTime != null ? this.formattedLastModifiedDateTime : "string_null_value";
    }

    public String getName() {
        return this.name != null ? this.name : "string_null_value";
    }

    public Integer getPermissionCode() {
        return this.permissionCode != null ? this.permissionCode : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Long getResourceID() {
        return this.resourceID != null ? this.resourceID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public String getResourceType() {
        return this.resourceType != null ? this.resourceType : "string_null_value";
    }

    public Long getResourceTypeID() {
        return this.resourceTypeID != null ? this.resourceTypeID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Vector getVersionDetails() {
        return this.versionDetails;
    }

    public Long getLicenseID() {
        return this.licenseID;
    }

    public void setLicenseID(Long licenseID) {
        this.licenseID = licenseID;
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getOriginalAuthor() {
        return this.originalAuthor;
    }

    public void setOriginalAuthor(String originalAuthor) {
        this.originalAuthor = originalAuthor;
    }

    private String formatLastModifiedDateTime(TimeZone tz) {
        if (this.lastModifiedDateTime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            return sdf.format(DateUtil.convertToTimeZoneFromDefault(tz, this.lastModifiedDateTime));
        }
        return null;
    }
}

