/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.cache;

import org.apache.log4j.Logger;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jgroups.View;
import org.lamsfoundation.lams.cache.CacheManager;

public class CacheDebugListener
implements TreeCacheListener {
    protected Logger log = Logger.getLogger(CacheManager.class);
    private String cacheNameString = "Cache unknown: ";

    private void logMessage(String message) {
        this.log.info((Object)(this.cacheNameString + message));
    }

    public void cacheStarted(TreeCache cache) {
        this.cacheNameString = "Cache " + cache.getName() + ": ";
        this.logMessage("started");
    }

    public void cacheStopped(TreeCache cache) {
        this.logMessage("stopped");
    }

    public void nodeCreated(Fqn fqn) {
        this.logMessage("node created " + fqn);
    }

    public void nodeEvicted(Fqn fqn) {
        this.logMessage("node evicted " + fqn);
    }

    public void nodeLoaded(Fqn fqn) {
        this.logMessage("node loaded " + fqn);
    }

    public void nodeModified(Fqn fqn) {
        this.logMessage("node modified " + fqn);
    }

    public void nodeRemoved(Fqn fqn) {
        this.logMessage("node removed " + fqn);
    }

    public void nodeVisited(Fqn fqn) {
        this.logMessage("node visited " + fqn);
    }

    public void viewChange(View new_view) {
        this.logMessage("view changed ");
    }
}

