/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.config.dao.hibernate;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.config.ConfigurationItem;
import org.lamsfoundation.lams.config.dao.IConfigurationDAO;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.springframework.orm.hibernate3.HibernateCallback;

public class ConfigurationDAO
extends BaseDAO
implements IConfigurationDAO {
    private static final String LOAD_CONFIG_ITEM_BY_KEY = "from configuration in class " + ConfigurationItem.class.getName() + " where configuration.key=:key";

    public List getAllItems() {
        return super.findAll(ConfigurationItem.class);
    }

    public ConfigurationItem getConfigItemByKey(final String configKey) {
        return (ConfigurationItem)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LOAD_CONFIG_ITEM_BY_KEY).setString("key", configKey).uniqueResult();
            }
        });
    }
}

