/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.ActivityDTOOrderComparator;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.ChosenBranchingActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.GroupBranchingActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.NullGroup;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.SystemGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.ToolBranchingActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.LibraryActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.ProgressActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Activity
implements Serializable,
Nullable {
    public static final int TOOL_ACTIVITY_TYPE = 1;
    public static final int GROUPING_ACTIVITY_TYPE = 2;
    public static final int SYNCH_GATE_ACTIVITY_TYPE = 3;
    public static final int SCHEDULE_GATE_ACTIVITY_TYPE = 4;
    public static final int PERMISSION_GATE_ACTIVITY_TYPE = 5;
    public static final int PARALLEL_ACTIVITY_TYPE = 6;
    public static final int OPTIONS_ACTIVITY_TYPE = 7;
    public static final int SEQUENCE_ACTIVITY_TYPE = 8;
    public static final int SYSTEM_GATE_ACTIVITY_TYPE = 9;
    public static final int CHOSEN_BRANCHING_ACTIVITY_TYPE = 10;
    public static final int GROUP_BRANCHING_ACTIVITY_TYPE = 11;
    public static final int TOOL_BRANCHING_ACTIVITY_TYPE = 12;
    public static final int CATEGORY_SYSTEM = 1;
    public static final int CATEGORY_COLLABORATION = 2;
    public static final int CATEGORY_ASSESSMENT = 3;
    public static final int CATEGORY_CONTENT = 4;
    public static final int CATEGORY_SPLIT = 5;
    public static final int CATEGORY_RESPONSE = 6;
    public static final int GROUPING_SUPPORT_NONE = 1;
    public static final int GROUPING_SUPPORT_OPTIONAL = 2;
    public static final int GROUPING_SUPPORT_REQUIRED = 3;
    public static final String I18N_TITLE = "activity.title";
    public static final String I18N_DESCRIPTION = "activity.description";
    public static final String I18N_HELP_TEXT = "activity.helptext";
    public static final String OBJECT_TYPE = "Activity";
    private Long activityId;
    private Integer activityUIID;
    private String description;
    private String title;
    private String helpText;
    private Integer xcoord;
    private Integer ycoord;
    private Integer orderId;
    private Boolean defineLater;
    private Boolean runOffline;
    private Date createDateTime;
    private String libraryActivityUiImage;
    private LearningLibrary learningLibrary;
    private Activity parentActivity;
    private Activity libraryActivity;
    private LearningDesign learningDesign;
    private Grouping grouping;
    private Integer groupingUIID;
    private Integer activityTypeId;
    private Integer activityCategoryID;
    private Transition transitionTo;
    private Transition transitionFrom;
    private Integer parentUIID;
    private Boolean applyGrouping;
    private Integer groupingSupportType;
    private String languageFile;
    private Boolean readOnly;
    private Boolean initialised;

    public Activity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, String languageFile) {
        this.activityId = activityId;
        this.activityUIID = id;
        this.description = description;
        this.title = title;
        this.xcoord = xcoord;
        this.ycoord = ycoord;
        this.orderId = orderId;
        this.defineLater = defineLater;
        this.createDateTime = createDateTime != null ? createDateTime : new Date();
        this.learningLibrary = learningLibrary;
        this.parentActivity = parentActivity;
        this.parentUIID = parentUIID;
        this.libraryActivity = libraryActivity;
        this.learningDesign = learningDesign;
        this.grouping = grouping;
        this.activityTypeId = activityTypeId;
        this.transitionTo = transitionTo;
        this.transitionFrom = transitionFrom;
        this.languageFile = languageFile;
        this.readOnly = false;
        this.initialised = false;
    }

    public Activity() {
        this.grouping = null;
        this.createDateTime = new Date();
        this.readOnly = false;
        this.initialised = false;
    }

    public Activity(Long activityId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom) {
        this.activityId = activityId;
        this.defineLater = defineLater;
        this.createDateTime = createDateTime != null ? createDateTime : new Date();
        this.learningLibrary = learningLibrary;
        this.parentActivity = parentActivity;
        this.learningDesign = learningDesign;
        this.grouping = grouping;
        this.activityTypeId = activityTypeId;
        this.transitionTo = transitionTo;
        this.transitionFrom = transitionFrom;
        this.readOnly = false;
    }

    public static Activity getActivityInstance(int activityType) {
        Activity activity = null;
        switch (activityType) {
            case 1: {
                activity = new ToolActivity();
                activity.setActivityCategoryID(4);
                break;
            }
            case 7: {
                activity = new OptionsActivity();
                activity.setActivityCategoryID(1);
                break;
            }
            case 6: {
                activity = new ParallelActivity();
                activity.setActivityCategoryID(5);
                break;
            }
            case 8: {
                activity = new SequenceActivity();
                activity.setActivityCategoryID(1);
                break;
            }
            case 3: {
                activity = new SynchGateActivity();
                activity.setActivityCategoryID(1);
                break;
            }
            case 4: {
                activity = new ScheduleGateActivity();
                activity.setActivityCategoryID(1);
                break;
            }
            case 5: {
                activity = new PermissionGateActivity();
                activity.setActivityCategoryID(1);
                break;
            }
            case 9: {
                activity = new SystemGateActivity();
                activity.setActivityCategoryID(1);
                break;
            }
            case 10: {
                activity = new ChosenBranchingActivity();
                activity.setActivityCategoryID(1);
                break;
            }
            case 11: {
                activity = new GroupBranchingActivity();
                activity.setActivityCategoryID(1);
                break;
            }
            case 12: {
                activity = new ToolBranchingActivity();
                activity.setActivityCategoryID(1);
                break;
            }
            default: {
                activity = new GroupingActivity();
                activity.setActivityCategoryID(1);
            }
        }
        activity.setActivityTypeId(new Integer(activityType));
        return activity;
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityUIID() {
        return this.activityUIID;
    }

    public void setActivityUIID(Integer id) {
        this.activityUIID = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getXcoord() {
        return this.xcoord;
    }

    public void setXcoord(Integer xcoord) {
        this.xcoord = xcoord;
    }

    public Integer getYcoord() {
        return this.ycoord;
    }

    public void setYcoord(Integer ycoord) {
        this.ycoord = ycoord;
    }

    public Integer getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Integer orderId) {
        this.orderId = orderId;
    }

    public Boolean getDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(Boolean defineLater) {
        this.defineLater = defineLater;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime != null ? createDateTime : new Date();
    }

    public LearningLibrary getLearningLibrary() {
        return this.learningLibrary;
    }

    public void setLearningLibrary(LearningLibrary learningLibrary) {
        this.learningLibrary = learningLibrary;
    }

    public Activity getParentActivity() {
        return this.parentActivity;
    }

    public void setParentActivity(Activity parentActivity) {
        this.parentActivity = parentActivity;
    }

    public LearningDesign getLearningDesign() {
        return this.learningDesign;
    }

    public void setLearningDesign(LearningDesign learningDesign) {
        this.learningDesign = learningDesign;
    }

    public Grouping getGrouping() {
        return this.grouping;
    }

    public void setGrouping(Grouping grouping) {
        this.grouping = grouping;
    }

    public Integer getActivityTypeId() {
        return this.activityTypeId;
    }

    public void setActivityTypeId(Integer activityTypeId) {
        this.activityTypeId = activityTypeId;
    }

    public Boolean getApplyGrouping() {
        return this.applyGrouping;
    }

    public void setApplyGrouping(Boolean applyGrouping) {
        this.applyGrouping = applyGrouping;
    }

    public Integer getGroupingSupportType() {
        return this.groupingSupportType;
    }

    public void setGroupingSupportType(Integer groupingSupportType) {
        this.groupingSupportType = groupingSupportType;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Boolean isInitialised() {
        return this.initialised;
    }

    public void setInitialised(Boolean initialised) {
        this.initialised = initialised;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.activityId).append("activityUIID", (Object)this.activityUIID).append("description", (Object)this.description).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Activity)) {
            return false;
        }
        Activity castOther = (Activity)other;
        return new EqualsBuilder().append((Object)this.getActivityId(), (Object)castOther.getActivityId()).append((Object)this.getActivityUIID(), (Object)castOther.getActivityUIID()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getActivityId()).append((Object)this.getActivityUIID()).toHashCode();
    }

    public String getLibraryActivityUiImage() {
        return this.libraryActivityUiImage;
    }

    public void setLibraryActivityUiImage(String libraryActivityUiImage) {
        this.libraryActivityUiImage = libraryActivityUiImage;
    }

    public Transition getTransitionFrom() {
        return this.transitionFrom;
    }

    public void setTransitionFrom(Transition transitionFrom) {
        this.transitionFrom = transitionFrom;
    }

    public Transition getTransitionTo() {
        return this.transitionTo;
    }

    public void setTransitionTo(Transition transitionTo) {
        this.transitionTo = transitionTo;
    }

    public Integer getParentUIID() {
        return this.parentUIID;
    }

    public void setParentUIID(Integer parent_ui_id) {
        this.parentUIID = parent_ui_id;
    }

    public Activity getLibraryActivity() {
        return this.libraryActivity;
    }

    public void setLibraryActivity(Activity libraryActivity) {
        this.libraryActivity = libraryActivity;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public Integer getGroupingUIID() {
        return this.groupingUIID;
    }

    public void setGroupingUIID(Integer groupingUIID) {
        this.groupingUIID = groupingUIID;
    }

    public Boolean getRunOffline() {
        return this.runOffline;
    }

    public void setRunOffline(Boolean runOffline) {
        this.runOffline = runOffline;
    }

    public Integer getActivityCategoryID() {
        return this.activityCategoryID;
    }

    public void setActivityCategoryID(Integer activityCategoryID) {
        this.activityCategoryID = activityCategoryID;
    }

    public String getLanguageFile() {
        return this.languageFile;
    }

    public void setLanguageFile(String languageFile) {
        this.languageFile = languageFile;
    }

    public Set getAllToolActivities() {
        TreeSet toolActivities = new TreeSet(new ActivityOrderComparator());
        this.getToolActivitiesInActivity(toolActivities);
        return toolActivities;
    }

    protected void getToolActivitiesInActivity(SortedSet toolActivities) {
    }

    public Group getGroupFor(User learner) {
        return this.getGroupFor(learner, this.getGrouping());
    }

    protected Group getGroupFor(User learner, Grouping inGrouping) {
        if (inGrouping == null) {
            throw new IllegalArgumentException("Exception occured in getGroupFor, no grouping has been defined");
        }
        for (Group group : inGrouping.getGroups()) {
            if (!inGrouping.isLearnerGroup(group) || !group.hasLearner(learner)) continue;
            return group;
        }
        return new NullGroup();
    }

    public boolean isToolActivity() {
        return this.getActivityTypeId() == 1;
    }

    public boolean isSequenceActivity() {
        return this.getActivityTypeId() == 8;
    }

    public boolean isParallelActivity() {
        return this.getActivityTypeId() == 6;
    }

    public boolean isOptionsActivity() {
        return this.getActivityTypeId() == 7;
    }

    public boolean isComplexActivity() {
        return this.getActivityTypeId() == 8 || this.getActivityTypeId() == 6 || this.getActivityTypeId() == 7 || this.getActivityTypeId() == 10 || this.getActivityTypeId() == 11 || this.getActivityTypeId() == 12;
    }

    public boolean isSystemToolActivity() {
        return this.isGateActivity() || this.isGroupingActivity() || this.isBranchingActivity();
    }

    public boolean isGateActivity() {
        return this.getActivityTypeId() == 4 || this.getActivityTypeId() == 5 || this.getActivityTypeId() == 3 || this.getActivityTypeId() == 9;
    }

    public boolean isSynchGate() {
        return this.getActivityTypeId() == 3;
    }

    public boolean isPermissionGate() {
        return this.getActivityTypeId() == 5;
    }

    public boolean isScheduleGate() {
        return this.getActivityTypeId() == 4;
    }

    public boolean isSystemGate() {
        return this.getActivityTypeId() == 9;
    }

    public boolean isGroupingActivity() {
        return this.getActivityTypeId() == 2;
    }

    public boolean isBranchingActivity() {
        return this.getActivityTypeId() == 10 || this.getActivityTypeId() == 11 || this.getActivityTypeId() == 12;
    }

    public boolean isChosenBranchingActivity() {
        return this.getActivityTypeId() == 10;
    }

    public boolean isGroupBranchingActivity() {
        return this.getActivityTypeId() == 11;
    }

    public boolean isToolBranchingActivity() {
        return this.getActivityTypeId() == 12;
    }

    public boolean isActivityReadOnly() {
        return this.readOnly.equals(Boolean.TRUE);
    }

    public ProgressActivityDTO getProgressActivityData() {
        return new ProgressActivityDTO(this.activityId);
    }

    public Set<AuthoringActivityDTO> getAuthoringActivityDTOSet() {
        TreeSet<AuthoringActivityDTO> dtoSet = new TreeSet<AuthoringActivityDTO>(new ActivityDTOOrderComparator());
        dtoSet.add(new AuthoringActivityDTO(this));
        return dtoSet;
    }

    private AuthoringActivityDTO getAuthoringActivityDTO() {
        return new AuthoringActivityDTO(this);
    }

    public LibraryActivityDTO getLibraryActivityDTO() {
        return new LibraryActivityDTO(this);
    }

    public abstract Activity createCopy();

    protected void copyToNewActivity(Activity newActivity) {
        newActivity.setActivityUIID(this.getActivityUIID());
        newActivity.setDescription(this.getDescription());
        newActivity.setTitle(this.getTitle());
        newActivity.setHelpText(this.getHelpText());
        newActivity.setXcoord(this.getXcoord());
        newActivity.setYcoord(this.getYcoord());
        newActivity.setActivityTypeId(this.getActivityTypeId());
        newActivity.setGroupingSupportType(this.getGroupingSupportType());
        newActivity.setApplyGrouping(this.getApplyGrouping());
        newActivity.setActivityCategoryID(this.getActivityCategoryID());
        newActivity.setGrouping(this.getGrouping());
        newActivity.setGroupingUIID(this.getGroupingUIID());
        newActivity.setDefineLater(this.getDefineLater());
        newActivity.setCreateDateTime(new Date());
        newActivity.setRunOffline(this.getRunOffline());
        newActivity.setLearningLibrary(this.getLearningLibrary());
        newActivity.setLibraryActivity(this.getLibraryActivity());
        newActivity.setLibraryActivityUiImage(this.getLibraryActivityUiImage());
        newActivity.setLanguageFile(this.getLanguageFile());
        newActivity.setOrderId(this.getOrderId());
        newActivity.setReadOnly(this.getReadOnly());
    }

    public Vector<ValidationErrorDTO> validateActivity(MessageService messageService) {
        return null;
    }
}

