/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.SimpleActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignProcessorException;

public abstract class LearningDesignProcessor {
    private static Logger log = Logger.getLogger(LearningDesignProcessor.class);
    private LearningDesign design;
    private IActivityDAO activityDAO;

    public LearningDesignProcessor(LearningDesign design, IActivityDAO activityDAO) {
        this.design = design;
        this.activityDAO = activityDAO;
    }

    public abstract void startComplexActivity(ComplexActivity var1) throws LearningDesignProcessorException;

    public abstract void endComplexActivity(ComplexActivity var1) throws LearningDesignProcessorException;

    public abstract void startSimpleActivity(SimpleActivity var1) throws LearningDesignProcessorException;

    public abstract void endSimpleActivity(SimpleActivity var1) throws LearningDesignProcessorException;

    public void parseLearningDesign() throws LearningDesignProcessorException {
        if (this.getDesign() != null) {
            this.handleActivity(this.getDesign().getFirstActivity());
        }
    }

    protected void handleActivity(Activity activity) throws LearningDesignProcessorException {
        if (activity == null) {
            log.warn((Object)("Parsing activity method handleActivity got a null activity. Learning design was " + this.getDesign()));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing activity " + activity.getActivityId() + " " + activity.getTitle()));
            }
            if (activity.isComplexActivity()) {
                this.handleComplexActivity(activity);
            } else {
                this.handleSimpleActivity(activity);
            }
            if (activity.getTransitionFrom() != null) {
                this.handleActivity(activity.getTransitionFrom().getToActivity());
            }
        }
    }

    protected void handleComplexActivity(Activity activity) throws LearningDesignProcessorException {
        ComplexActivity complex = (ComplexActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId(), SimpleActivity.class);
        this.startComplexActivity(complex);
        TreeSet children = new TreeSet(new ActivityOrderComparator());
        children.addAll(complex.getActivities());
        Iterator i = children.iterator();
        while (i.hasNext()) {
            this.handleActivity((Activity)i.next());
        }
        this.endComplexActivity(complex);
    }

    protected void handleSimpleActivity(Activity activity) throws LearningDesignProcessorException {
        SimpleActivity simple = (SimpleActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId(), SimpleActivity.class);
        this.startSimpleActivity(simple);
        this.endSimpleActivity(simple);
    }

    public LearningDesign getDesign() {
        return this.design;
    }
}

